/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.net.Socket;
import org.mortbay.component.LifeCycle;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.AbstractBuffers;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.WaitingContinuation;

public abstract class AbstractConnector
extends AbstractBuffers
implements Connector {
    private String _name;
    private Server _server;
    private ThreadPool _threadPool;
    private String _host;
    private int _port = 0;
    private String _integralScheme = "https";
    private int _integralPort = 0;
    private String _confidentialScheme = "https";
    private int _confidentialPort = 0;
    private int _acceptQueueSize = 0;
    private int _acceptors = 1;
    private boolean _useDNS;
    protected int _maxIdleTime = 30000;
    protected int _lowResourceMaxIdleTime = -1;
    protected int _soLingerTime = -1;
    private transient Thread[] _acceptorThread;
    Object _statsLock = new Object();
    transient long _statsStartedAt = -1L;
    transient int _requests;
    transient int _connections;
    transient int _connectionsOpen;
    transient int _connectionsOpenMin;
    transient int _connectionsOpenMax;
    transient long _connectionsDurationMin;
    transient long _connectionsDurationMax;
    transient long _connectionsDurationTotal;
    transient int _connectionsRequestsMin;
    transient int _connectionsRequestsMax;

    public abstract void open() throws IOException;

    public Server getServer() {
        return this._server;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        this._threadPool = pool;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getLowResourceMaxIdleTime() {
        return this._lowResourceMaxIdleTime;
    }

    public void setLowResourceMaxIdleTime(int maxIdleTime) {
        this._lowResourceMaxIdleTime = maxIdleTime;
    }

    public long getSoLingerTime() {
        return this._soLingerTime;
    }

    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this._acceptQueueSize = acceptQueueSize;
    }

    public int getAcceptors() {
        return this._acceptors;
    }

    public void setAcceptors(int acceptors) {
        this._acceptors = acceptors;
    }

    public void setSoLingerTime(int soLingerTime) {
        this._soLingerTime = soLingerTime;
    }

    protected void doStart() throws Exception {
        this.open();
        super.doStart();
        if (this._threadPool == null) {
            this._threadPool = this._server.getThreadPool();
        }
        if (this._threadPool != this._server.getThreadPool() && this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).start();
        }
        this._acceptorThread = new Thread[this.getAcceptors()];
        for (int i = 0; i < this._acceptorThread.length; ++i) {
            if (this._threadPool.dispatch((Runnable)new Acceptor(i))) continue;
            Log.warn((String)"insufficient maxThreads configured for {}", (Object)this);
            break;
        }
        Log.info((String)"Started {}", (Object)this);
    }

    protected void doStop() throws Exception {
        if (this._threadPool == this._server.getThreadPool()) {
            this._threadPool = null;
        } else if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).stop();
        }
        Thread[] acceptors = this._acceptorThread;
        this._acceptorThread = null;
        if (acceptors != null) {
            for (int i = 0; i < acceptors.length; ++i) {
                Thread thread = acceptors[i];
                if (thread == null) continue;
                thread.interrupt();
            }
        }
        try {
            this.close();
        }
        catch (IOException e) {
            Log.warn((Throwable)e);
        }
        super.doStop();
    }

    public void join() throws InterruptedException {
        Thread[] threads = this._acceptorThread;
        if (threads != null) {
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                threads[i].join();
            }
        }
    }

    protected void configure(Socket socket) throws IOException {
        try {
            socket.setTcpNoDelay(true);
            if (this._maxIdleTime >= 0) {
                socket.setSoTimeout(this._maxIdleTime);
            }
            if (this._soLingerTime >= 0) {
                socket.setSoLinger(true, this._soLingerTime / 1000);
            } else {
                socket.setSoLinger(false, 0);
            }
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
    }

    public int getConfidentialPort() {
        return this._confidentialPort;
    }

    public String getConfidentialScheme() {
        return this._confidentialScheme;
    }

    public boolean isIntegral(Request request) {
        return false;
    }

    public int getIntegralPort() {
        return this._integralPort;
    }

    public String getIntegralScheme() {
        return this._integralScheme;
    }

    public boolean isConfidential(Request request) {
        return false;
    }

    public void setConfidentialPort(int confidentialPort) {
        this._confidentialPort = confidentialPort;
    }

    public void setConfidentialScheme(String confidentialScheme) {
        this._confidentialScheme = confidentialScheme;
    }

    public void setIntegralPort(int integralPort) {
        this._integralPort = integralPort;
    }

    public void setIntegralScheme(String integralScheme) {
        this._integralScheme = integralScheme;
    }

    public Continuation newContinuation() {
        return new WaitingContinuation();
    }

    protected abstract void accept(int var1) throws IOException, InterruptedException;

    public void stopAccept(int acceptorID) throws Exception {
    }

    public boolean getResolveNames() {
        return this._useDNS;
    }

    public void setResolveNames(boolean resolve) {
        this._useDNS = resolve;
    }

    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            name = name.substring(dot + 1);
        }
        return name + " @ " + (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
    }

    public String getName() {
        if (this._name == null) {
            this._name = (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
        }
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getRequests() {
        return this._requests;
    }

    public long getConnectionsDurationMin() {
        return this._connectionsDurationMin;
    }

    public long getConnectionsDurationTotal() {
        return this._connectionsDurationTotal;
    }

    public int getConnectionsOpenMin() {
        return this._connectionsOpenMin;
    }

    public int getConnectionsRequestsMin() {
        return this._connectionsRequestsMin;
    }

    public int getConnections() {
        return this._connections;
    }

    public int getConnectionsOpen() {
        return this._connectionsOpen;
    }

    public int getConnectionsOpenMax() {
        return this._connectionsOpenMax;
    }

    public long getConnectionsDurationAve() {
        return this._connections == 0 ? 0L : this._connectionsDurationTotal / (long)this._connections;
    }

    public long getConnectionsDurationMax() {
        return this._connectionsDurationMax;
    }

    public int getConnectionsRequestsAve() {
        return this._connections == 0 ? 0 : this._requests / this._connections;
    }

    public int getConnectionsRequestsMax() {
        return this._connectionsRequestsMax;
    }

    public void statsReset() {
        this._statsStartedAt = this._statsStartedAt == -1L ? -1L : System.currentTimeMillis();
        this._connections = 0;
        this._connectionsOpenMin = this._connectionsOpen;
        this._connectionsOpenMax = this._connectionsOpen;
        this._connectionsOpen = 0;
        this._connectionsDurationMin = 0L;
        this._connectionsDurationMax = 0L;
        this._connectionsDurationTotal = 0L;
        this._requests = 0;
        this._connectionsRequestsMin = 0;
        this._connectionsRequestsMax = 0;
    }

    public void setStatsOn(boolean on) {
        if (on && this._statsStartedAt != -1L) {
            return;
        }
        Log.info((String)("Statistics on = " + on + " for " + this));
        this.statsReset();
        this._statsStartedAt = on ? System.currentTimeMillis() : -1L;
    }

    public boolean getStatsOn() {
        return this._statsStartedAt != -1L;
    }

    public long getStatsOnMs() {
        return this._statsStartedAt != -1L ? System.currentTimeMillis() - this._statsStartedAt : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionOpened(HttpConnection connection) {
        if (this._statsStartedAt == -1L) {
            return;
        }
        Object object = this._statsLock;
        synchronized (object) {
            ++this._connectionsOpen;
            if (this._connectionsOpen > this._connectionsOpenMax) {
                this._connectionsOpenMax = this._connectionsOpen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(HttpConnection connection) {
        if (this._statsStartedAt >= 0L) {
            Object object = this._statsLock;
            synchronized (object) {
                int requests = connection.getRequests();
                this._requests += requests;
                long duration = System.currentTimeMillis() - connection.getTimeStamp();
                ++this._connections;
                --this._connectionsOpen;
                this._connectionsDurationTotal += duration;
                if (this._connectionsOpen < 0) {
                    this._connectionsOpen = 0;
                }
                if (this._connectionsOpen < this._connectionsOpenMin) {
                    this._connectionsOpenMin = this._connectionsOpen;
                }
                if (this._connectionsDurationMin == 0L || duration < this._connectionsDurationMin) {
                    this._connectionsDurationMin = duration;
                }
                if (duration > this._connectionsDurationMax) {
                    this._connectionsDurationMax = duration;
                }
                if (this._connectionsRequestsMin == 0 || requests < this._connectionsRequestsMin) {
                    this._connectionsRequestsMin = requests;
                }
                if (requests > this._connectionsRequestsMax) {
                    this._connectionsRequestsMax = requests;
                }
            }
        }
        connection.destroy();
    }

    private class Acceptor
    implements Runnable {
        int _acceptor = 0;

        Acceptor(int id) {
            this._acceptor = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread current;
            ((AbstractConnector)AbstractConnector.this)._acceptorThread[this._acceptor] = current = Thread.currentThread();
            String name = AbstractConnector.this._acceptorThread[this._acceptor].getName();
            current.setName(name + " - Acceptor" + this._acceptor + " " + AbstractConnector.this);
            Log.debug((String)("Starting " + this));
            try {
                current.setPriority(current.getPriority() - 1);
                while (AbstractConnector.this.isRunning()) {
                    try {
                        AbstractConnector.this.accept(this._acceptor);
                    }
                    catch (IOException e) {
                        Log.ignore((Throwable)e);
                    }
                    catch (Exception e) {
                        Log.warn((Throwable)e);
                    }
                }
            }
            finally {
                Log.debug((String)("Stopping " + this));
                current.setPriority(current.getPriority() + 1);
                current.setName(name);
                try {
                    if (this._acceptor == 0) {
                        AbstractConnector.this.close();
                    }
                }
                catch (IOException e) {
                    Log.warn((Throwable)e);
                }
            }
        }
    }
}

