/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.headerfooter;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfPageNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfHeaderFooter
extends HeaderFooter
implements RtfBasicElement {
    public static final int TYPE_HEADER = 1;
    public static final int TYPE_FOOTER = 2;
    public static final int DISPLAY_FIRST_PAGE = 0;
    public static final int DISPLAY_ALL_PAGES = 1;
    public static final int DISPLAY_LEFT_PAGES = 2;
    public static final int DISPLAY_RIGHT_PAGES = 4;
    private static final byte[] HEADER_ALL = "\\header".getBytes();
    private static final byte[] HEADER_FIRST = "\\headerf".getBytes();
    private static final byte[] HEADER_LEFT = "\\headerl".getBytes();
    private static final byte[] HEADER_RIGHT = "\\headerr".getBytes();
    private static final byte[] FOOTER_ALL = "\\footer".getBytes();
    private static final byte[] FOOTER_FIRST = "\\footerf".getBytes();
    private static final byte[] FOOTER_LEFT = "\\footerl".getBytes();
    private static final byte[] FOOTER_RIGHT = "\\footerr".getBytes();
    private RtfDocument document = null;
    private Object content = null;
    private int type = 1;
    private int displayAt = 1;

    protected RtfHeaderFooter(RtfDocument rtfDocument, HeaderFooter headerFooter, int n, int n2) {
        super(new Phrase(""), false);
        this.document = rtfDocument;
        this.type = n;
        this.displayAt = n2;
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(headerFooter.alignment());
        if (headerFooter.getBefore() != null) {
            paragraph.add(headerFooter.getBefore());
        }
        if (headerFooter.isNumbered()) {
            paragraph.add(new RtfPageNumber(this.document));
        }
        if (headerFooter.getAfter() != null) {
            paragraph.add(headerFooter.getAfter());
        }
        try {
            if (this.document != null) {
                this.content = this.document.getMapper().mapElement(paragraph);
                ((RtfBasicElement)this.content).setInHeader(true);
            } else {
                this.content = paragraph;
            }
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    protected RtfHeaderFooter(RtfDocument rtfDocument, RtfHeaderFooter rtfHeaderFooter, int n) {
        super(new Phrase(""), false);
        this.document = rtfDocument;
        this.content = rtfHeaderFooter.getContent();
        this.displayAt = n;
        if (this.content instanceof Element) {
            try {
                this.content = this.document.getMapper().mapElement((Element)this.content);
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
        ((RtfBasicElement)this.content).setInHeader(true);
    }

    protected RtfHeaderFooter(RtfDocument rtfDocument, HeaderFooter headerFooter) {
        super(new Phrase(""), false);
        this.document = rtfDocument;
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(headerFooter.alignment());
        if (headerFooter.getBefore() != null) {
            paragraph.add(headerFooter.getBefore());
        }
        if (headerFooter.isNumbered()) {
            paragraph.add(new RtfPageNumber(this.document));
        }
        if (headerFooter.getAfter() != null) {
            paragraph.add(headerFooter.getAfter());
        }
        try {
            this.content = rtfDocument.getMapper().mapElement(paragraph);
            ((RtfBasicElement)this.content).setInHeader(true);
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    public RtfHeaderFooter(Element element) {
        super(new Phrase(""), false);
        this.content = element;
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
        if (this.document != null) {
            try {
                if (this.content instanceof Element) {
                    this.content = this.document.getMapper().mapElement((Element)this.content);
                    ((RtfBasicElement)this.content).setInHeader(true);
                } else if (this.content instanceof RtfBasicElement) {
                    ((RtfBasicElement)this.content).setRtfDocument(this.document);
                    ((RtfBasicElement)this.content).setInHeader(true);
                }
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
            if (this.type == 1) {
                if (this.displayAt == 1) {
                    byteArrayOutputStream.write(HEADER_ALL);
                } else if (this.displayAt == 0) {
                    byteArrayOutputStream.write(HEADER_FIRST);
                } else if (this.displayAt == 2) {
                    byteArrayOutputStream.write(HEADER_LEFT);
                } else if (this.displayAt == 4) {
                    byteArrayOutputStream.write(HEADER_RIGHT);
                }
            } else if (this.displayAt == 1) {
                byteArrayOutputStream.write(FOOTER_ALL);
            } else if (this.displayAt == 0) {
                byteArrayOutputStream.write(FOOTER_FIRST);
            } else if (this.displayAt == 2) {
                byteArrayOutputStream.write(FOOTER_LEFT);
            } else if (this.displayAt == 4) {
                byteArrayOutputStream.write(FOOTER_RIGHT);
            }
            byteArrayOutputStream.write(RtfBasicElement.DELIMITER);
            if (this.content instanceof RtfBasicElement) {
                byteArrayOutputStream.write(((RtfBasicElement)this.content).write());
            }
            byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setDisplayAt(int n) {
        this.displayAt = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    private Object getContent() {
        return this.content;
    }

    public void setInTable(boolean bl) {
    }

    public void setInHeader(boolean bl) {
    }
}

