/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.nutch.protocol.ftp.FtpExceptionBadSystResponse;
import org.apache.nutch.protocol.ftp.FtpExceptionCanNotHaveDataConnection;
import org.apache.nutch.protocol.ftp.FtpExceptionControlClosedByForcedDataClose;
import org.apache.nutch.protocol.ftp.FtpExceptionUnknownForcedDataClose;

public class Client
extends FTP {
    private int __dataTimeout;
    private int __passivePort;
    private String __passiveHost;
    private boolean __remoteVerificationEnabled;
    private String __systemName;

    public Client() {
        this.__initDefaults();
        this.__dataTimeout = -1;
        this.__remoteVerificationEnabled = true;
    }

    private void __initDefaults() {
        this.__passiveHost = null;
        this.__passivePort = -1;
        this.__systemName = null;
    }

    private void __parsePassiveModeReply(String reply) throws MalformedServerReplyException {
        reply = reply.substring(reply.indexOf(40) + 1, reply.indexOf(41)).trim();
        StringBuffer host = new StringBuffer(24);
        int lastIndex = 0;
        int index = reply.indexOf(44);
        host.append(reply.substring(lastIndex, index));
        for (int i = 0; i < 3; ++i) {
            host.append('.');
            lastIndex = index + 1;
            index = reply.indexOf(44, lastIndex);
            host.append(reply.substring(lastIndex, index));
        }
        lastIndex = index + 1;
        index = reply.indexOf(44, lastIndex);
        String octet1 = reply.substring(lastIndex, index);
        String octet2 = reply.substring(index + 1);
        try {
            index = Integer.parseInt(octet1);
            lastIndex = Integer.parseInt(octet2);
        }
        catch (NumberFormatException e) {
            throw new MalformedServerReplyException("Could not parse passive host information.\nServer Reply: " + reply);
        }
        index <<= 8;
        this.__passiveHost = host.toString();
        this.__passivePort = index |= lastIndex;
    }

    protected Socket __openPassiveDataConnection(int command, String arg) throws IOException, FtpExceptionCanNotHaveDataConnection {
        if (this.pasv() != 227) {
            throw new FtpExceptionCanNotHaveDataConnection("pasv() failed. " + this.getReplyString());
        }
        try {
            this.__parsePassiveModeReply(this.getReplyStrings()[0]);
        }
        catch (MalformedServerReplyException e) {
            throw new FtpExceptionCanNotHaveDataConnection(e.getMessage());
        }
        Socket socket = this._socketFactory_.createSocket(this.__passiveHost, this.__passivePort);
        if (!FTPReply.isPositivePreliminary((int)this.sendCommand(command, arg))) {
            socket.close();
            return null;
        }
        if (this.__remoteVerificationEnabled && !this.verifyRemote(socket)) {
            InetAddress host1 = socket.getInetAddress();
            InetAddress host2 = this.getRemoteAddress();
            socket.close();
            throw new FtpExceptionCanNotHaveDataConnection("Host attempting data connection " + host1.getHostAddress() + " is not same as server " + host2.getHostAddress() + " So we intentionally close it for security precaution.");
        }
        if (this.__dataTimeout >= 0) {
            socket.setSoTimeout(this.__dataTimeout);
        }
        return socket;
    }

    public void setDataTimeout(int timeout) {
        this.__dataTimeout = timeout;
    }

    public void disconnect() throws IOException {
        this.__initDefaults();
        super.disconnect();
    }

    public void setRemoteVerificationEnabled(boolean enable) {
        this.__remoteVerificationEnabled = enable;
    }

    public boolean isRemoteVerificationEnabled() {
        return this.__remoteVerificationEnabled;
    }

    public boolean login(String username, String password) throws IOException {
        this.user(username);
        if (FTPReply.isPositiveCompletion((int)this.getReplyCode())) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate((int)this.getReplyCode())) {
            return false;
        }
        return FTPReply.isPositiveCompletion((int)this.pass(password));
    }

    public boolean logout() throws IOException {
        return FTPReply.isPositiveCompletion((int)this.quit());
    }

    public void retrieveList(String path, List<FTPFile> entries, int limit, FTPFileEntryParser parser) throws IOException, FtpExceptionCanNotHaveDataConnection, FtpExceptionUnknownForcedDataClose, FtpExceptionControlClosedByForcedDataClose {
        Socket socket = this.__openPassiveDataConnection(26, path);
        if (socket == null) {
            throw new FtpExceptionCanNotHaveDataConnection("LIST " + (path == null ? "" : path));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        int count = 0;
        String line = parser.readNextEntry(reader);
        while (line != null) {
            FTPFile ftpFile = parser.parseFTPEntry(line);
            if (ftpFile == null) {
                line = parser.readNextEntry(reader);
                continue;
            }
            entries.add(ftpFile);
            if (limit >= 0 && (count += line.length()) > limit) break;
            line = parser.readNextEntry(reader);
        }
        socket.close();
        try {
            int reply = this.getReply();
            if (!this._notBadReply(reply)) {
                throw new FtpExceptionUnknownForcedDataClose(this.getReplyString());
            }
        }
        catch (FTPConnectionClosedException e) {
            throw new FtpExceptionControlClosedByForcedDataClose(e.getMessage());
        }
    }

    public void retrieveFile(String path, OutputStream os, int limit) throws IOException, FtpExceptionCanNotHaveDataConnection, FtpExceptionUnknownForcedDataClose, FtpExceptionControlClosedByForcedDataClose {
        int len;
        Socket socket = this.__openPassiveDataConnection(13, path);
        if (socket == null) {
            throw new FtpExceptionCanNotHaveDataConnection("RETR " + (path == null ? "" : path));
        }
        InputStream input = socket.getInputStream();
        int count = 0;
        byte[] buf = new byte[1024];
        while ((len = input.read(buf, 0, buf.length)) != -1) {
            if (limit >= 0 && (count += len) > limit) {
                os.write(buf, 0, len - (count - limit));
                break;
            }
            os.write(buf, 0, len);
            os.flush();
        }
        socket.close();
        try {
            int reply = this.getReply();
            if (!this._notBadReply(reply)) {
                throw new FtpExceptionUnknownForcedDataClose(this.getReplyString());
            }
        }
        catch (FTPConnectionClosedException e) {
            throw new FtpExceptionControlClosedByForcedDataClose(e.getMessage());
        }
    }

    private boolean _notBadReply(int reply) {
        return FTPReply.isPositiveCompletion((int)reply) || reply == 426 || reply == 450 || reply == 451 || reply == 451;
        {
        }
    }

    public boolean setFileType(int fileType) throws IOException {
        return FTPReply.isPositiveCompletion((int)this.type(fileType));
    }

    public String getSystemName() throws IOException, FtpExceptionBadSystResponse {
        if (this.__systemName != null || !FTPReply.isPositiveCompletion((int)this.syst())) {
            throw new FtpExceptionBadSystResponse("Bad response of SYST: " + this.getReplyString());
        }
        this.__systemName = this.getReplyStrings()[0].substring(4);
        return this.__systemName;
    }

    public boolean sendNoOp() throws IOException {
        return FTPReply.isPositiveCompletion((int)this.noop());
    }
}

