/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.ftp;

import crawlercommons.robots.BaseRobotRules;
import crawlercommons.robots.SimpleRobotRules;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.protocol.Protocol;
import org.apache.nutch.protocol.ProtocolOutput;
import org.apache.nutch.protocol.ProtocolStatus;
import org.apache.nutch.protocol.RobotRulesParser;
import org.apache.nutch.protocol.ftp.Ftp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpRobotRulesParser
extends RobotRulesParser {
    private static final String CONTENT_TYPE = "text/plain";
    public static final Logger LOG = LoggerFactory.getLogger(FtpRobotRulesParser.class);

    FtpRobotRulesParser() {
    }

    public FtpRobotRulesParser(Configuration conf) {
        super(conf);
    }

    public BaseRobotRules getRobotRulesSet(Protocol ftp, URL url) {
        String protocol = url.getProtocol().toLowerCase();
        String host = url.getHost().toLowerCase();
        SimpleRobotRules robotRules = (SimpleRobotRules)CACHE.get(protocol + ":" + host);
        boolean cacheRule = true;
        if (robotRules == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("cache miss " + url);
            }
            try {
                Text robotsUrl = new Text(new URL(url, "/robots.txt").toString());
                ProtocolOutput output = ((Ftp)ftp).getProtocolOutput(robotsUrl, new CrawlDatum());
                ProtocolStatus status = output.getStatus();
                robotRules = status.getCode() == 1 ? this.parseRules(url.toString(), output.getContent().getContent(), CONTENT_TYPE, this.agentNames) : EMPTY_RULES;
            }
            catch (Throwable t) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Couldn't get robots.txt for " + url + ": " + t.toString());
                }
                cacheRule = false;
                robotRules = EMPTY_RULES;
            }
            if (cacheRule) {
                CACHE.put(protocol + ":" + host, robotRules);
            }
        }
        return robotRules;
    }
}

