/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.video;

import com.anotherbigidea.flash.video.ScreenVideoImageBlock;
import java.awt.image.BufferedImage;

public class ScreenVideoImage {
    private int imageWidth;
    private int imageHeight;
    private int[] pixels;

    public ScreenVideoImage(int n, int n2, int[] nArray) {
        this.imageWidth = n;
        this.imageHeight = n2;
        this.pixels = nArray;
    }

    public ScreenVideoImage(BufferedImage bufferedImage) {
        int n = this.imageWidth = bufferedImage.getWidth();
        int n2 = this.imageHeight = bufferedImage.getHeight();
        this.pixels = new int[n * n2];
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        for (int i = 0; i < n2; ++i) {
            int n3 = i * n;
            int n4 = (n2 - i - 1) * n;
            for (int j = 0; j < n; ++j) {
                this.pixels[n3 + j] = nArray[n4 + j] & 0xFFFFFF;
            }
        }
    }

    public ScreenVideoImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        this(bufferedImage.getSubimage(n, n2, n3, n4));
    }

    public ScreenVideoImageBlock[] toBlocks(int n, int n2) {
        int n3 = (this.imageWidth / n + (this.imageWidth % n == 0 ? 0 : 1)) * (this.imageHeight / n2 + (this.imageHeight % n2 == 0 ? 0 : 1));
        ScreenVideoImageBlock[] screenVideoImageBlockArray = new ScreenVideoImageBlock[n3];
        int n4 = 0;
        for (int i = 0; i < this.imageHeight; i += n2) {
            for (int j = 0; j < this.imageWidth; j += n) {
                int n5 = Math.min(n, this.imageWidth - j);
                int n6 = Math.min(n2, this.imageHeight - i);
                int[] nArray = new int[n5 * n6];
                int n7 = 0;
                for (int k = 0; k < n6; ++k) {
                    int n8 = (i + k) * this.imageWidth + j;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        nArray[n7++] = this.pixels[n8 + i2];
                    }
                }
                screenVideoImageBlockArray[n4++] = new ScreenVideoImageBlock(nArray);
            }
        }
        return screenVideoImageBlockArray;
    }

    public int getPixelAt(int n, int n2) {
        int n3 = n2 * this.imageWidth + n;
        if (n3 > this.pixels.length) {
            return 0;
        }
        return this.pixels[n3];
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int n) {
        this.imageHeight = n;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int n) {
        this.imageWidth = n;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void setPixels(int[] nArray) {
        this.pixels = nArray;
    }
}

