/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.compression;

import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.mg4j.compression.Decoder;
import it.unimi.dsi.mg4j.io.InputBitStream;
import java.io.IOException;
import java.io.Serializable;

final class TreeDecoder
implements Decoder,
Serializable {
    private final Node root;

    public final int decode(BooleanIterator iterator) {
        Node n = this.root;
        while (!(n instanceof LeafNode)) {
            Node node = n = iterator.nextBoolean() ? n.right : n.left;
        }
        return ((LeafNode)n).symbol;
    }

    public final int decode(InputBitStream ibs) throws IOException {
        Node n = this.root;
        while (!(n instanceof LeafNode)) {
            Node node = n = ibs.readBit() == 0 ? n.left : n.right;
        }
        return ((LeafNode)n).symbol;
    }

    public TreeDecoder(Node root) {
        this.root = root;
    }

    public static class Node
    implements Serializable {
        public Node left;
        public Node right;
    }

    public static class LeafNode
    extends Node {
        public final int symbol;

        public LeafNode(int symbol) {
            this.symbol = symbol;
        }
    }
}

