/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.io.WordReader;
import java.io.IOException;
import java.io.InputStream;

public class CompositeDocumentFactory
extends AbstractDocumentFactory {
    public final DocumentFactory[] documentFactory;
    public final int numberOfFields;
    public final String[] fieldName;
    public final int[] fieldType;
    public final int[] factoryIndex;
    public final int[] originalFieldIndex;
    private final Object2IntOpenHashMap field2Index;

    public static DocumentFactory getFactory(DocumentFactory[] documentFactory, String[] fieldName) {
        if (documentFactory.length == 1 && fieldName == null) {
            return documentFactory[0];
        }
        return new CompositeDocumentFactory(documentFactory, fieldName);
    }

    public static DocumentFactory getFactory(DocumentFactory[] documentFactory) {
        return CompositeDocumentFactory.getFactory(documentFactory, null);
    }

    public int numberOfFields() {
        return this.numberOfFields;
    }

    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return this.fieldName[field];
    }

    public int fieldIndex(String fieldName) {
        return this.field2Index.getInt((Object)fieldName);
    }

    public int fieldType(int field) {
        this.ensureFieldIndex(field);
        return this.fieldType[field];
    }

    public Document getDocument(InputStream rawContent, Reference2ObjectMap metadata) throws IOException {
        return new CompositeDocument(metadata, rawContent);
    }

    private CompositeDocumentFactory(DocumentFactory[] documentFactory, String[] fieldName) {
        boolean hasNames;
        this.documentFactory = documentFactory;
        int n = 0;
        int i = 0;
        while (i < this.documentFactory.length) {
            n += documentFactory[i].numberOfFields();
            ++i;
        }
        this.numberOfFields = n;
        boolean bl = false;
        if (fieldName != null) {
            bl = true;
        }
        if ((hasNames = bl) && fieldName.length != this.numberOfFields) {
            throw new IllegalArgumentException("There is a mismatch between the number of fields (" + this.numberOfFields + ") and the number of names (" + fieldName.length + ')');
        }
        this.fieldName = hasNames ? fieldName : new String[this.numberOfFields];
        this.fieldType = new int[this.numberOfFields];
        this.factoryIndex = new int[this.numberOfFields];
        this.originalFieldIndex = new int[this.numberOfFields];
        n = 0;
        int i2 = 0;
        while (i2 < this.documentFactory.length) {
            int j = 0;
            while (j < documentFactory[i2].numberOfFields()) {
                if (!hasNames) {
                    fieldName[n] = documentFactory[i2].fieldName(j);
                }
                this.fieldType[n] = documentFactory[i2].fieldType(j);
                this.factoryIndex[n] = i2;
                this.originalFieldIndex[n] = j++;
                ++n;
            }
            ++i2;
        }
        this.field2Index = new Object2IntOpenHashMap(fieldName.length, 0.5f);
        this.field2Index.defaultReturnValue(-1);
        i2 = 0;
        while (i2 < fieldName.length) {
            this.field2Index.put((Object)fieldName[i2], i2);
            ++i2;
        }
        if (this.field2Index.size() != fieldName.length) {
            throw new IllegalArgumentException("The field name array " + ObjectArrayList.wrap((Object[])fieldName) + " contains duplicates");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class CompositeDocument
    implements Document {
        private int currFactory;
        private int currField;
        private int fieldOffset;
        private Document currDocument;
        private CharSequence title;
        private CharSequence uri;
        private final Reference2ObjectMap metadata;
        private final InputStream rawContent;

        public CharSequence title() {
            return this.title;
        }

        public String toString() {
            return this.title.toString();
        }

        public CharSequence uri() {
            return this.uri;
        }

        private final void advanceToField(int field) {
            if (field <= this.currField) {
                throw new IllegalStateException("Composite document factories require sequential access");
            }
        }

        /*
         * Unable to fully structure code
         */
        public Object content(int field) throws IOException {
            CompositeDocumentFactory.this.ensureFieldIndex(field);
            if (field > this.currField) ** GOTO lbl6
            throw new IllegalStateException("Composite document factories require sequential access");
lbl-1000:
            // 1 sources

            {
                this.rawContent.reset();
                ++this.currFactory;
lbl6:
                // 2 sources

                ** while (this.currFactory < CompositeDocumentFactory.this.factoryIndex[field])
            }
lbl7:
            // 1 sources

            this.currField = field;
            this.currDocument = CompositeDocumentFactory.this.documentFactory[this.currFactory].getDocument(this.rawContent, this.metadata);
            return this.currDocument.content(CompositeDocumentFactory.this.originalFieldIndex[field]);
        }

        public WordReader wordReader(int field) {
            CompositeDocumentFactory.this.ensureFieldIndex(field);
            if (field != this.currField) {
                throw new IllegalStateException("The specified field (" + field + ") is not the one of the last document returned (" + this.currField + ')');
            }
            return this.currDocument.wordReader(CompositeDocumentFactory.this.originalFieldIndex[field]);
        }

        public void close() throws IOException {
            this.rawContent.close();
        }

        private final /* synthetic */ void this() {
            this.currFactory = 0;
            this.currField = -1;
        }

        protected CompositeDocument(Reference2ObjectMap metadata, InputStream rawContent) throws IOException {
            this.this();
            this.metadata = metadata;
            this.rawContent = rawContent;
            this.currDocument = CompositeDocumentFactory.this.documentFactory[0].getDocument(rawContent, metadata);
            this.title = this.currDocument.title();
            this.uri = this.currDocument.uri();
        }
    }
}

