/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.document.CompositeDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.MultipleInputStream;
import it.unimi.dsi.mg4j.io.NullInputStream;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JdbcDocumentCollection
extends AbstractDocumentCollection
implements Serializable {
    final Int2IntMap id2doc;
    final int[] doc2id;
    final String dbUri;
    transient Class jdbcDriver;
    final String jdbcDriverName;
    final DocumentFactory factory;
    final String select;
    final String where;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$JdbcDocumentCollection;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory;

    private final String buildQuery(String additionalWhere) {
        MutableString query = new MutableString();
        query.append("SELECT ").append(this.select);
        if (this.where == null && additionalWhere != null) {
            query.append(" WHERE (").append(additionalWhere).append(")");
        }
        if (this.where != null && additionalWhere == null) {
            query.append(" WHERE (").append(this.where).append(")");
        }
        if (this.where != null && additionalWhere != null) {
            query.append(" WHERE (").append(this.where).append(") AND (").append(additionalWhere).append(")");
        }
        return query.append(" ORDER BY id").toString();
    }

    private final void initDriver() throws ClassNotFoundException {
        this.jdbcDriver = this.jdbcDriverName != null ? Class.forName(this.jdbcDriverName) : null;
    }

    public DocumentFactory factory() {
        return this.factory;
    }

    public int size() {
        return this.doc2id.length;
    }

    public Document document(int index) throws IOException {
        MutableString title = new MutableString();
        return this.factory.getDocument(this.stream(index, title), this.metadata(index, title));
    }

    private final Reference2ObjectMap metadata(int index, CharSequence title) {
        Reference2ObjectOpenHashMap metadata = new Reference2ObjectOpenHashMap();
        if (title == null) {
            try {
                Connection connection = DriverManager.getConnection(this.dbUri);
                Statement s = connection.createStatement();
                ResultSet rs = s.executeQuery(this.buildQuery("id=" + this.doc2id[index]));
                if (!rs.next()) {
                    throw new IllegalStateException("Id " + this.doc2id[index] + " is no longer in the database");
                }
                title = rs.getString(2);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        metadata.put((Object)"title", (Object)title);
        metadata.put((Object)"uri", (Object)Integer.toString(this.doc2id[index]));
        return metadata;
    }

    public Reference2ObjectMap metadata(int index) {
        this.ensureDocumentIndex(index);
        return this.metadata(index, null);
    }

    public InputStream stream(int index) throws IOException {
        return this.stream(index, null);
    }

    private final InputStream getStreamFromResultSet(ResultSet rs, MutableString title) throws SQLException {
        InputStream[] a = new InputStream[this.factory.numberOfFields()];
        int i = 0;
        while (i < a.length) {
            a[i] = rs.getBinaryStream(i + 3);
            if (a[i] == null) {
                a[i] = NullInputStream.getInstance();
            }
            ++i;
        }
        if (title != null) {
            title.replace(rs.getString(2));
        }
        return MultipleInputStream.getStream(a);
    }

    private final InputStream stream(int index, MutableString title) throws IOException {
        this.ensureDocumentIndex(index);
        try {
            Connection connection = DriverManager.getConnection(this.dbUri);
            Statement s = connection.createStatement();
            ResultSet rs = s.executeQuery(this.buildQuery("id=" + this.doc2id[index]));
            if (!rs.next()) {
                throw new IllegalStateException("Id " + this.doc2id[index] + " is no longer in the database");
            }
            return this.getStreamFromResultSet(rs, title);
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    public DocumentIterator iterator() throws IOException {
        try {
            return new JdbcDocumentIterator();
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initDriver();
    }

    public void close() {
    }

    public static void main(String[] arg) throws JSAPException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, IOException, SQLException, ClassNotFoundException, InstantiationException {
        Class clazz = class$it$unimi$dsi$mg4j$document$JdbcDocumentCollection;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$document$JdbcDocumentCollection = JdbcDocumentCollection.class("[Lit.unimi.dsi.mg4j.document.JdbcDocumentCollection;", false);
        }
        String string = clazz.getName();
        Parameter[] parameterArray = new Parameter[7];
        parameterArray[0] = new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true);
        parameterArray[1] = new FlaggedOption("jdbcDriver", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'd', "driver", "The JDBC driver. You can omit it if it is already loaded.");
        Class clazz2 = class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory;
        if (clazz2 == null) {
            clazz2 = class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory = JdbcDocumentCollection.class("[Lit.unimi.dsi.mg4j.document.IdentityDocumentFactory;", false);
        }
        parameterArray[2] = new FlaggedOption("factory", (StringParser)JSAP.CLASS_PARSER, clazz2.getName(), false, 'f', "factory", "One document factory for each indexed field.").setAllowMultipleDeclarations(true);
        parameterArray[3] = new UnflaggedOption("collection", (StringParser)JSAP.STRING_PARSER, true, "The filename for the serialised collection.");
        parameterArray[4] = new UnflaggedOption("dburi", (StringParser)JSAP.STRING_PARSER, true, "The JDBC URI defining the database.");
        parameterArray[5] = new UnflaggedOption("select", (StringParser)JSAP.STRING_PARSER, true, "A SQL query generating the collection, except for the WHERE part.");
        parameterArray[6] = new FlaggedOption("where", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'w', "where", "The the WHERE part (without the WHERE keyword) of the SQL query generating the collection.");
        SimpleJSAP jsap = new SimpleJSAP(string, "Saves a serialised document collection based on a set of database rows.", parameterArray);
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        Class<?> jdbcDriver = Class.forName(jsapResult.getString("jdbcDriver"));
        Connection connection = DriverManager.getConnection(jsapResult.getString("dburi"));
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery("SELECT " + jsapResult.getString("select"));
        ResultSetMetaData metaData = rs.getMetaData();
        String[] column = new String[metaData.getColumnCount() - 2];
        int i = 3;
        while (i <= metaData.getColumnCount()) {
            column[i - 3] = metaData.getColumnName(i);
            ++i;
        }
        rs.close();
        DocumentFactory[] factory = new DocumentFactory[column.length];
        Class[] factoryClass = jsapResult.getClassArray("factory");
        String[] property = jsapResult.getStringArray("property");
        int i2 = 0;
        while (i2 < factory.length) {
            factory[i2] = PropertyBasedDocumentFactory.getInstance(factoryClass[Math.min(i2, factoryClass.length - 1)], property);
            ++i2;
        }
        BinIO.storeObject((Object)new JdbcDocumentCollection(jsapResult.getString("dburi"), jsapResult.getString("jdbcDriver"), jsapResult.getString("select"), jsapResult.getString("where"), CompositeDocumentFactory.getFactory(factory, column)), (CharSequence)jsapResult.getString("collection"));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JdbcDocumentCollection(String dbUri, String jdbcDriverName, String select, String where, DocumentFactory factory) throws SQLException, ClassNotFoundException {
        this.dbUri = dbUri;
        this.jdbcDriverName = jdbcDriverName;
        this.select = select;
        this.where = where;
        this.factory = factory;
        this.initDriver();
        Connection connection = DriverManager.getConnection(dbUri);
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery(this.buildQuery(null));
        this.id2doc = new Int2IntOpenHashMap();
        this.id2doc.defaultReturnValue(-1);
        IntArrayList ids = new IntArrayList();
        int i = 0;
        while (rs.next()) {
            int id = rs.getInt(1);
            ids.add(id);
            this.id2doc.put(i, id);
            ++i;
        }
        this.doc2id = ids.toIntArray();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class JdbcDocumentIterator
    extends AbstractDocumentIterator {
        private final Connection connection;
        private final ResultSet rs;
        private final MutableString title;
        private int index;

        public Document nextDocument() throws IOException {
            if (!this.rs.next()) {
                return null;
            }
            try {
                while (this.rs.getInt(1) < JdbcDocumentCollection.this.doc2id[this.index]) {
                    this.rs.next();
                }
                if (this.rs.getInt(1) > JdbcDocumentCollection.this.doc2id[this.index]) {
                    throw new IllegalStateException("Row with id " + JdbcDocumentCollection.this.doc2id[this.index] + " is missing");
                }
                return JdbcDocumentCollection.this.factory.getDocument(JdbcDocumentCollection.this.getStreamFromResultSet(this.rs, this.title), JdbcDocumentCollection.this.metadata(this.index++, this.title));
            }
            catch (SQLException e) {
                throw new IOException(e.toString());
            }
        }

        public void close() throws IOException {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                throw new IOException(e.toString());
            }
        }

        private final /* synthetic */ void this() {
            this.title = new MutableString();
            this.index = 0;
        }

        private JdbcDocumentIterator() throws SQLException {
            this.this();
            this.connection = DriverManager.getConnection(JdbcDocumentCollection.this.dbUri);
            Statement s = this.connection.createStatement();
            this.rs = s.executeQuery(JdbcDocumentCollection.this.buildQuery(null));
        }
    }
}

