/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.io.WordReader;
import java.io.IOException;
import java.io.InputStream;

public class ReplicatedDocumentFactory
extends AbstractDocumentFactory {
    public final DocumentFactory documentFactory;
    public final int numberOfCopies;
    private final Object2IntOpenHashMap field2Index;
    private final String[] fieldName;

    public static DocumentFactory getFactory(DocumentFactory documentFactory, int numberOfCopies, String[] fieldName) {
        return new ReplicatedDocumentFactory(documentFactory, numberOfCopies, fieldName);
    }

    public int numberOfFields() {
        return this.numberOfCopies * this.documentFactory.numberOfFields();
    }

    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return this.documentFactory.fieldName(field % this.documentFactory.numberOfFields());
    }

    public int fieldIndex(String fieldName) {
        return this.field2Index.getInt((Object)fieldName);
    }

    public int fieldType(int field) {
        this.ensureFieldIndex(field);
        return this.documentFactory.fieldType(field % this.documentFactory.numberOfFields());
    }

    public Document getDocument(InputStream rawContent, Reference2ObjectMap metadata) throws IOException {
        return new ReplicatedDocument(rawContent, metadata);
    }

    private ReplicatedDocumentFactory(DocumentFactory documentFactory, int numberOfCopies, String[] fieldName) {
        this.documentFactory = documentFactory;
        this.numberOfCopies = numberOfCopies;
        this.fieldName = fieldName;
        if (this.numberOfFields() != fieldName.length) {
            throw new IllegalArgumentException("The number of field names (" + fieldName.length + ") is not equal to the number of fields in the replicated factory (" + this.numberOfFields() + ')');
        }
        this.field2Index = new Object2IntOpenHashMap(fieldName.length, 0.5f);
        this.field2Index.defaultReturnValue(-1);
        int i = 0;
        while (i < fieldName.length) {
            this.field2Index.put((Object)fieldName[i], i);
            ++i;
        }
        if (this.field2Index.size() != fieldName.length) {
            throw new IllegalArgumentException("The field name array " + ObjectArrayList.wrap((Object[])fieldName) + " contains duplicates");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ReplicatedDocument
    implements Document {
        private int currFactory;
        private int currField;
        private Document currDocument;
        private CharSequence title;
        private CharSequence uri;
        private final InputStream rawContent;
        private final Reference2ObjectMap metadata;

        public CharSequence title() {
            return this.title;
        }

        public String toString() {
            return this.title().toString();
        }

        public CharSequence uri() {
            return this.uri;
        }

        /*
         * Unable to fully structure code
         */
        public Object content(int field) throws IOException {
            ReplicatedDocumentFactory.this.ensureFieldIndex(field);
            if (field > this.currField) ** GOTO lbl9
            throw new IOException("Composite document factories require sequential access");
lbl-1000:
            // 1 sources

            {
                ++this.currField;
                if (this.currField % ReplicatedDocumentFactory.this.documentFactory.numberOfFields() != 0) continue;
                if (this.currField > 0) {
                    this.rawContent.reset();
                }
                this.currDocument = ReplicatedDocumentFactory.this.documentFactory.getDocument(this.rawContent, this.metadata);
lbl9:
                // 3 sources

                ** while (this.currField < field)
            }
lbl10:
            // 1 sources

            return this.currDocument.content(field % ReplicatedDocumentFactory.this.documentFactory.numberOfFields());
        }

        public WordReader wordReader(int field) {
            ReplicatedDocumentFactory.this.ensureFieldIndex(field);
            return this.currDocument.wordReader(field % ReplicatedDocumentFactory.this.documentFactory.numberOfFields());
        }

        public void close() throws IOException {
            this.rawContent.close();
        }

        private final /* synthetic */ void this() {
            this.currField = -1;
        }

        protected ReplicatedDocument(InputStream rawContent, Reference2ObjectMap metadata) throws IOException {
            this.this();
            this.rawContent = rawContent;
            this.metadata = metadata;
            this.currDocument = ReplicatedDocumentFactory.this.documentFactory.getDocument(rawContent, metadata);
            this.title = this.currDocument.title();
            this.uri = this.currDocument.uri();
        }
    }
}

