/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.mg4j.index.BitStreamIndexReader;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.PrefixMap;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileIndex
extends Index
implements CompressionFlags {
    private static final Logger LOGGER;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    public final String basename;
    public final File indexFile;
    public final int frequencyCoding;
    public final int pointerCoding;
    public final int countCoding;
    public final int positionCoding;
    public final LongList offsets;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$FileIndex;

    public IndexReader getReader() throws IOException {
        return this.getReader(8192);
    }

    public IndexReader getReader(int bufferSize) throws IOException {
        return new BitStreamIndexReader(this, new InputBitStream(this.indexFile, bufferSize));
    }

    public String toString() {
        return this.basename;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected FileIndex(CharSequence basename, TermMap termMap, PrefixMap prefixMap, boolean randomAccess, boolean documentSizes) throws ConfigurationException, IOException {
        super(new Properties(basename + ".properties"), termMap, prefixMap);
        this.basename = basename.toString();
        this.indexFile = new File(this.basename + ".index");
        if (!this.indexFile.exists()) {
            throw new FileNotFoundException("Cannot find index file " + this.indexFile.getName());
        }
        long flags = FileIndex.string2Flags(this.properties.getString("compressionflags"));
        this.frequencyCoding = (int)(((flags & 0xFFL) != 0L ? flags : (long)2) & 0xFFL);
        this.pointerCoding = (int)(((flags >>> 8 & 0xFFL) != 0L ? flags : 768L) >>> 8 & 0xFFL);
        this.countCoding = (int)(((flags >>> 16 & 0xFFL) != 0L ? flags : 131072L) >>> 16 & 0xFFL);
        if (!this.hasCounts) {
            this.positionCoding = (int)(((flags >>> 24 & 0xFFL) != 0L ? flags : 0xFF000000L) >>> 24 & 0xFFL);
            if (this.positionCoding != 255) {
                throw new IllegalArgumentException("Index " + this.basename + " has positions but no counts (this can't happen)");
            }
        } else {
            this.positionCoding = (int)(((flags >>> 24 & 0xFFL) != 0L ? flags : 0x3000000L) >>> 24 & 0xFFL);
        }
        if (!this.hasCounts && this.hasPositions) {
            throw new IllegalArgumentException("Index " + this.basename + " has positions but no counts (this can't happen)");
        }
        if (documentSizes || this.positionCoding == 3 || this.positionCoding == 6) {
            this.sizes = FileIndex.readSizes(new InputBitStream(basename + ".sizes"), this.numberOfDocuments);
        }
        this.offsets = randomAccess ? FileIndex.readOffsets(new InputBitStream(basename + ".offsets"), this.numberOfTerms) : null;
    }

    public FileIndex(String basename, File indexFile, Properties properties, int numberOfDocuments, int numberOfTerms, int maxCount, long flags, TermMap termMap, PrefixMap prefixMap, LongList offsets, IntList sizes) throws IOException {
        boolean bl = false;
        if ((int)(((flags >>> 16 & 0xFFL) != 0L ? flags : 131072L) >>> 16 & 0xFFL) != 255) {
            bl = true;
        }
        boolean bl2 = false;
        if ((int)(((flags >>> 24 & 0xFFL) != 0L ? flags : 0xFF000000L) >>> 24 & 0xFFL) != 255) {
            bl2 = true;
        }
        super(numberOfDocuments, numberOfTerms, maxCount, bl, bl2, FileIndex.getTermProcessor(properties), null, properties, termMap, prefixMap);
        this.basename = basename;
        this.indexFile = indexFile;
        this.offsets = offsets;
        this.frequencyCoding = (int)(((flags & 0xFFL) != 0L ? flags : (long)2) & 0xFFL);
        this.pointerCoding = (int)(((flags >>> 8 & 0xFFL) != 0L ? flags : 768L) >>> 8 & 0xFFL);
        this.countCoding = (int)(((flags >>> 16 & 0xFFL) != 0L ? flags : 131072L) >>> 16 & 0xFFL);
        if (!this.hasCounts) {
            this.positionCoding = (int)(((flags >>> 24 & 0xFFL) != 0L ? flags : 0xFF000000L) >>> 24 & 0xFFL);
            if (this.positionCoding != 255) {
                throw new IllegalArgumentException("Index " + this.basename + " has positions but no counts (this can't happen)");
            }
        } else {
            this.positionCoding = (int)(((flags >>> 24 & 0xFFL) != 0L ? flags : 0x3000000L) >>> 24 & 0xFFL);
        }
        if (!this.hasCounts && this.hasPositions) {
            throw new IllegalArgumentException("Index " + this.basename + " has positions but no counts (this can't happen)");
        }
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$index$FileIndex;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$index$FileIndex = FileIndex.class("[Lit.unimi.dsi.mg4j.index.FileIndex;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }
}

