/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.mg4j.index.BitStreamIndexReader;
import it.unimi.dsi.mg4j.index.FileIndex;
import it.unimi.dsi.mg4j.index.SkipIndex;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SkipIndexReader
extends BitStreamIndexReader {
    protected static final int BEFORE_TOWER = 4;
    private static final boolean ASSERTS = true;
    private static final boolean DEBUG = false;
    protected final SkipIndex skipIndex;
    private int maxh;
    private int s;
    private int w;
    private int[] towerTopB;
    private int[] towerTopLog2B;
    private int[] towerLowerB;
    private int[] towerLowerLog2B;
    private int[] pointerPrediction;
    private long[] bitSkip;
    private int[] pointerSkip;
    private long readBitsAtLastSkipTower;
    private int pointerAtLastSkipTower;
    private int quantumBitLength;
    private int entryBitLength;
    private static final /* synthetic */ boolean assert;

    private final void init() {
        this.w = (1 << this.skipIndex.height) * this.skipIndex.quantum;
        this.bitSkip = new long[this.skipIndex.height + 1];
        this.pointerSkip = new int[this.skipIndex.height + 1];
        this.towerTopB = new int[this.skipIndex.height + 1];
        this.towerTopLog2B = new int[this.skipIndex.height + 1];
        this.towerLowerB = new int[this.skipIndex.height + 1];
        this.towerLowerLog2B = new int[this.skipIndex.height + 1];
        this.pointerPrediction = new int[this.skipIndex.height + 1];
    }

    public int readFrequency() throws IOException, IllegalStateException {
        if (this.state == 4) {
            this.readTower();
        }
        int res = super.readFrequency();
        this.entryBitLength = -1;
        this.quantumBitLength = -1;
        int i = this.skipIndex.height;
        while (i > Math.min(this.skipIndex.height, Fast.mostSignificantBit(this.frequency / this.skipIndex.quantum))) {
            this.pointerPrediction[i] = -1;
            this.towerLowerB[i] = -1;
            this.towerTopB[i] = -1;
            --i;
        }
        double pointerQuantumSigma = Math.sqrt((double)this.skipIndex.quantum * (1.0 - this.relativeFrequency)) / this.relativeFrequency;
        int i2 = Math.min(this.skipIndex.height, Fast.mostSignificantBit(this.frequency / this.skipIndex.quantum));
        while (i2 >= 0) {
            this.towerTopB[i2] = Fast.gaussianGolombModulus(pointerQuantumSigma * Math.sqrt(1 << i2));
            this.towerTopLog2B[i2] = Fast.mostSignificantBit(this.towerTopB[i2]);
            this.towerLowerB[i2] = Fast.gaussianGolombModulus(pointerQuantumSigma * Math.sqrt((double)(1 << i2) / (double)2));
            this.towerLowerLog2B[i2] = Fast.mostSignificantBit(this.towerLowerB[i2]);
            this.pointerPrediction[i2] = (int)Math.round((double)(this.skipIndex.quantum * (1 << i2)) / this.relativeFrequency);
            --i2;
        }
        return res;
    }

    public int readDocumentPointer() throws IOException {
        if (this.state == 4) {
            this.readTower();
        }
        int pointer = super.readDocumentPointer();
        if (this.numberOfDocumentRecord % this.skipIndex.quantum == 0) {
            this.state = 4;
        }
        return pointer;
    }

    public int readPositionCount() throws IOException {
        if (this.state == 4) {
            this.readTower();
        }
        return super.readPositionCount();
    }

    private final void readTower() throws IOException {
        this.readTower(-1);
    }

    private final void readTower(int pointer) throws IOException {
        int j;
        int towerLength = 0;
        long bitsAtTowerStart = 0L;
        boolean truncated = false;
        if (!assert && this.numberOfDocumentRecord % this.skipIndex.quantum != 0) {
            throw new AssertionError();
        }
        if (this.state != 4) {
            throw new IllegalStateException("readTower() called in state " + this.state);
        }
        int cacheOffset = this.numberOfDocumentRecord % this.w;
        int k = cacheOffset / this.skipIndex.quantum;
        if (k == 0) {
            IntArrays.fill((int[])this.pointerSkip, (int)Integer.MAX_VALUE);
            LongArrays.fill((long[])this.bitSkip, (long)Integer.MAX_VALUE);
        }
        this.s = k == 0 ? this.skipIndex.height : Fast.leastSignificantBit(k);
        int cache = this.frequency - this.w * (this.numberOfDocumentRecord / this.w);
        if (cache < this.w) {
            this.maxh = Fast.mostSignificantBit(cache / this.skipIndex.quantum - k);
            if (this.maxh < this.s) {
                this.s = this.maxh;
                truncated = true;
            } else {
                truncated = false;
            }
        } else {
            cache = this.w;
            this.maxh = this.skipIndex.height;
            boolean bl = false;
            if (k == 0) {
                bl = true;
            }
            truncated = bl;
        }
        int i = this.s;
        if (this.s >= 0) {
            if (k == 0) {
                if (this.quantumBitLength < 0) {
                    this.quantumBitLength = this.ibs.readDelta();
                    this.entryBitLength = this.ibs.readDelta();
                } else {
                    this.quantumBitLength += Fast.nat2int(this.ibs.readDelta());
                    this.entryBitLength += Fast.nat2int(this.ibs.readDelta());
                }
            }
            if (this.s > 0) {
                towerLength = this.entryBitLength * (this.s + 1) + Fast.nat2int(this.ibs.readDelta());
            }
            bitsAtTowerStart = this.ibs.readBits();
            if (truncated) {
                this.pointerSkip[this.s] = Fast.nat2int(this.ibs.readGolomb(this.towerTopB[this.s], this.towerTopLog2B[this.s])) + this.pointerPrediction[this.s];
                this.bitSkip[this.s] = this.quantumBitLength * (1 << this.s) + this.entryBitLength * ((1 << this.s + 1) - this.s - 2) + Fast.nat2int(this.ibs.readDelta());
            } else {
                this.pointerSkip[this.s] = this.pointerSkip[this.s + 1] - (this.currentDocument - this.pointerAtLastSkipTower);
                this.bitSkip[this.s] = this.bitSkip[this.s + 1] - (bitsAtTowerStart - this.readBitsAtLastSkipTower) - (long)towerLength;
            }
            if (this.currentDocument + this.pointerSkip[i] > pointer) {
                i = this.s - 1;
                while (i >= 0) {
                    this.pointerSkip[i] = Fast.nat2int(this.ibs.readGolomb(this.towerLowerB[i], this.towerLowerLog2B[i])) + this.pointerSkip[i + 1] / 2;
                    this.bitSkip[i] = (this.bitSkip[i + 1] - (long)(this.entryBitLength * (i + 1))) / (long)2 - (long)Fast.nat2int(this.ibs.readDelta());
                    if (this.currentDocument + this.pointerSkip[i] <= pointer) break;
                    --i;
                }
            }
        }
        if (i > 0) {
            long fix = this.ibs.readBits() - bitsAtTowerStart;
            j = this.s;
            while (j >= i) {
                int n = j--;
                this.bitSkip[n] = this.bitSkip[n] + ((long)towerLength - fix);
            }
            while (j >= 0) {
                this.pointerSkip[j] = Integer.MAX_VALUE;
                --j;
            }
        } else {
            this.state = this.skipIndex.hasCounts + 1;
        }
        long deltaBits = this.ibs.readBits() - this.readBitsAtLastSkipTower;
        int deltaPointers = this.currentDocument - this.pointerAtLastSkipTower;
        j = Fast.mostSignificantBit(k ^ cache / this.skipIndex.quantum);
        while (j >= this.s + 1) {
            int n = j;
            this.bitSkip[n] = this.bitSkip[n] - deltaBits;
            int n2 = j--;
            this.pointerSkip[n2] = this.pointerSkip[n2] - deltaPointers;
        }
        this.readBitsAtLastSkipTower = this.ibs.readBits();
        this.pointerAtLastSkipTower = this.currentDocument;
    }

    /*
     * Unable to fully structure code
     */
    public boolean skipTo(int p) throws IOException {
        if (this.numberOfDocumentRecord == -1) {
            this.readDocumentPointer();
        }
        if (this.currentDocument >= p) {
            return true;
        }
        if (this.state == 4) {
            this.readTower(p);
        }
        do {
            cacheOffset = this.numberOfDocumentRecord % this.w;
            k = cacheOffset / this.skipIndex.quantum;
            if (this.maxh < 0) ** GOTO lbl38
            i = Fast.mostSignificantBit(k ^ Math.min(this.w, this.frequency - this.numberOfDocumentRecord + cacheOffset) / this.skipIndex.quantum);
            while (i >= 0) {
                if ((k & 1 << i) != 0 && !SkipIndexReader.assert && this.pointerSkip[i] != this.pointerSkip[i + 1]) {
                    throw new AssertionError();
                }
                if (this.pointerAtLastSkipTower + this.pointerSkip[i] <= p) break;
                --i;
            }
            if (i < 0) ** GOTO lbl38
            this.ibs.skip(this.bitSkip[i] - (this.ibs.readBits() - this.readBitsAtLastSkipTower));
            this.state = 4;
            this.currentDocument = this.pointerSkip[i] + this.pointerAtLastSkipTower;
            this.numberOfDocumentRecord += ((k & -(1 << i)) + (1 << i)) * this.skipIndex.quantum - cacheOffset;
            if (this.numberOfDocumentRecord == this.frequency) {
                this.currentDocument = -1;
            }
            this.readTower(p);
            this.count = -1;
        } while (!this.endOfList());
        v0 = false;
        if (this.currentDocument == p) {
            v0 = true;
        }
        return v0;
lbl-1000:
        // 1 sources

        {
            if (this.endOfList()) {
                return false;
            }
            this.readDocumentPointer();
lbl38:
            // 3 sources

            ** while (this.currentDocument < p)
        }
lbl39:
        // 1 sources

        return true;
    }

    public String toString() {
        return "SkipIndexReader read bits=" + this.readBits() + " term=" + this.term + " freq=" + this.frequency + " pointer=" + this.currentDocument + " docNum=" + this.numberOfDocumentRecord;
    }

    public SkipIndexReader(FileIndex index, InputBitStream ibs) {
        super(index, ibs);
        this.skipIndex = (SkipIndex)index;
        this.init();
    }

    static {
        assert = Class.forName("[Lit.unimi.dsi.mg4j.index.SkipIndexReader;").getComponentType().desiredAssertionStatus() ^ true;
    }
}

