/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.Int2IntRBTreeMap;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.mg4j.index.CachingOutputBitStream;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.io.FastByteArrayOutputStream;
import it.unimi.dsi.mg4j.io.NullOutputStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import org.apache.commons.configuration.ConfigurationException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SkipIndexWriter
extends IndexWriter {
    public static final int DEFAULT_TEMP_FILE_BUFFER_SIZE = 0x1000000;
    private static final boolean ASSERTS = true;
    private static final boolean DEBUG = false;
    private static final boolean STATS = false;
    private static final int MAX_TRY = 32;
    private int h;
    private int q;
    private int w;
    private int cache;
    private int[] skipPointer;
    private OutputBitStream[] cachePointer;
    private FastByteArrayOutputStream[] cachePointerByte;
    private OutputBitStream[] cacheSkip;
    private OutputBitStream[] cacheSkipBitCount;
    private FastByteArrayOutputStream[] cacheSkipByte;
    private CachingOutputBitStream cacheDataOut;
    private FastBufferedInputStream cacheDataIn;
    private FileChannel cacheDataInChannel;
    private int[] cacheDataLength;
    private OutputBitStream bitCount;
    public TowerData towerData;
    public long bitsForQuantumBitLengths;
    public long bitsForEntryBitLengths;
    public long numberOfBlocks;
    public int prevEntryBitLength;
    public int prevQuantumBitLength;
    private int[] towerTopB;
    private int[] towerTopLog2B;
    private int[] towerLowerB;
    private int[] towerLowerLog2B;
    private int[] pointerPrediction;
    private PrintWriter pointerSkipStats;
    private PrintWriter pointerTopSkipStats;
    private PrintWriter bitSkipStats;
    private PrintWriter bitTopSkipStats;
    private String pointerSkipLine;
    private String bitSkipLine;
    private final long[] distance;
    private final File tempFile;
    private boolean writeStats;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$SkipIndex;
    private static final /* synthetic */ boolean assert;

    public long newInvertedList() throws IOException, IllegalStateException {
        if (this.cache != 0) {
            this.writeOutCache(-1);
        }
        return super.newInvertedList();
    }

    public int writeFrequency(int frequency) throws IOException, IllegalStateException {
        int res = super.writeFrequency(frequency);
        this.prevEntryBitLength = -1;
        this.prevQuantumBitLength = -1;
        double pointerQuantumSigma = Math.sqrt((double)this.q * (1.0 - this.relativeFrequency)) / this.relativeFrequency;
        int i = Math.min(this.h, Fast.mostSignificantBit(frequency / this.q));
        while (i >= 0) {
            this.towerTopB[i] = Fast.gaussianGolombModulus(pointerQuantumSigma * Math.sqrt(1 << i));
            this.towerTopLog2B[i] = Fast.mostSignificantBit(this.towerTopB[i]);
            this.towerLowerB[i] = Fast.gaussianGolombModulus(pointerQuantumSigma * Math.sqrt((double)(1 << i) / (double)2));
            this.towerLowerLog2B[i] = Fast.mostSignificantBit(this.towerLowerB[i]);
            this.pointerPrediction[i] = (int)Math.round((double)(this.q * (1 << i)) / this.relativeFrequency);
            --i;
        }
        return res;
    }

    public OutputBitStream newDocumentRecord() throws IOException, IllegalStateException {
        super.newDocumentRecord();
        return this.cacheDataOut;
    }

    public int writeDocumentPointer(OutputBitStream out, int pointer) throws IOException, IllegalStateException {
        if (this.cache == this.w) {
            this.writeOutCache(pointer);
        }
        if (this.cache % this.q == 0) {
            if (this.cache / this.q > 0) {
                this.cacheDataLength[this.cache / this.q - 1] = (int)this.cacheDataOut.writtenBits();
            }
            this.cacheDataOut.align();
            this.cacheDataOut.writtenBits(0L);
            this.skipPointer[this.cache / this.q] = pointer;
            return super.writeDocumentPointer(this.cachePointer[this.cache++ / this.q], pointer);
        }
        ++this.cache;
        return super.writeDocumentPointer(this.cacheDataOut, pointer);
    }

    private final int writeOutPointer(OutputBitStream out, int pointer) throws IOException {
        if (this.frequency == this.numberOfDocuments) {
            return 0;
        }
        switch (this.pointerCoding) {
            case 2: {
                return out.writeGamma(pointer - this.lastDocument - 1);
            }
            case 1: {
                return out.writeDelta(pointer - this.lastDocument - 1);
            }
            case 3: {
                return out.writeGolomb(pointer - this.lastDocument - 1, this.b, this.log2b);
            }
        }
        throw new IllegalStateException("The required pointer coding (" + this.pointerCoding + ") is not supported.");
    }

    public void close() throws IllegalStateException, ConfigurationException, IOException {
        if (this.cache != 0) {
            this.writeOutCache(-1);
        }
        super.close();
        this.cacheDataIn.close();
        this.cacheDataOut.close();
        this.tempFile.delete();
    }

    private final void tryTower(int quantumBitLength, int entryBitLength, long toTheEnd, OutputBitStream[] skip, TowerData towerData, boolean doinIt) throws IOException {
        boolean truncated = false;
        int k = (this.cache - 1) / this.q;
        while (k >= 0) {
            int s;
            toTheEnd += (long)this.cacheDataLength[k];
            int n = s = k == 0 ? this.h : Fast.leastSignificantBit(k);
            if (this.cache < this.w) {
                int upperBound = Fast.mostSignificantBit(this.cache / this.q - k);
                if (s > upperBound) {
                    s = upperBound;
                    truncated = true;
                } else {
                    truncated = false;
                }
            } else {
                boolean bl = false;
                if (k == 0) {
                    bl = true;
                }
                truncated = bl;
            }
            skip[k].writtenBits(0L);
            if (s >= 0) {
                int basePointer = this.skipPointer[k];
                if (truncated) {
                    ++towerData.numberOfTopEntries;
                    towerData.bitsForTopSkipPointers += (long)skip[k].writeGolomb(Fast.int2nat(this.skipPointer[k + (1 << s)] - basePointer - this.pointerPrediction[s]), this.towerTopB[s], this.towerTopLog2B[s]);
                    towerData.bitsForTopBitSkips += (long)skip[k].writeDelta(Fast.int2nat((int)(toTheEnd - this.distance[k + (1 << s)] - (long)(quantumBitLength * (1 << s) + entryBitLength * ((1 << s + 1) - s - 2)))));
                }
                int i = s - 1;
                while (i >= 0) {
                    towerData.bitsForLowerSkipPointers += (long)skip[k].writeGolomb(Fast.int2nat(this.skipPointer[k + (1 << i)] - basePointer - (this.skipPointer[k + (1 << i + 1)] - basePointer) / 2), this.towerLowerB[i], this.towerLowerLog2B[i]);
                    towerData.bitsForLowerBitSkips += (long)skip[k].writeDelta(Fast.int2nat((int)((toTheEnd - this.distance[k + (1 << i + 1)] - (long)(entryBitLength * (i + 1))) / (long)2 - (toTheEnd - this.distance[k + (1 << i)]))));
                    --i;
                }
                if (s > 0) {
                    long d = this.bitCount.writeDelta(Fast.int2nat((int)skip[k].writtenBits() - (s + 1) * entryBitLength));
                    towerData.bitsForTowerLengths += d;
                    toTheEnd += d;
                }
                toTheEnd += skip[k].writtenBits();
                towerData.numberOfLowerEntries += (long)s;
                ++towerData.numberOfSkipTowers;
            }
            this.distance[k] = toTheEnd;
            toTheEnd += this.cachePointer[k].writtenBits();
            --k;
        }
    }

    private final void writeOutCache(int nextPointer) throws IOException {
        boolean direct;
        byte[] buffer;
        long toTheEnd;
        this.cacheDataLength[(this.cache + this.q - 1) / this.q - 1] = (int)this.cacheDataOut.writtenBits();
        int nextAfter = (this.cache + this.q - 1) / this.q;
        if (nextPointer >= 0) {
            this.skipPointer[nextAfter] = nextPointer;
            toTheEnd = this.writeOutPointer(this.bitCount, nextPointer);
        } else {
            this.skipPointer[nextAfter] = this.currentDocument + 1;
            toTheEnd = 0L;
        }
        this.distance[nextAfter] = 0L;
        int quantumBitLength = 0;
        int entryBitLength = 0;
        int k = 0;
        long d = 0;
        while (k <= (this.cache - 1) / this.q) {
            d += this.cachePointer[k].writtenBits() + (long)this.cacheDataLength[k];
            ++k;
        }
        quantumBitLength = (int)((d * (long)this.q + (long)(this.cache - 1)) / (long)this.cache);
        TowerData td = new TowerData();
        Int2IntRBTreeMap candidates = new Int2IntRBTreeMap();
        this.tryTower(quantumBitLength, 0, toTheEnd, this.cacheSkipBitCount, td, false);
        if (td.numberOfSkipTowers > 0L) {
            while (candidates.size() < 32 && !candidates.containsValue(entryBitLength = (int)(td.bitsForTowers() / td.numberOfEntries()))) {
                td.clear();
                this.tryTower(quantumBitLength, entryBitLength, toTheEnd, this.cacheSkipBitCount, td, false);
                candidates.put((int)(td.bitsForTowers() / td.numberOfEntries()), entryBitLength);
            }
            if (!assert && candidates.size() >= 32) {
                throw new AssertionError();
            }
            entryBitLength = candidates.get(candidates.firstIntKey());
            this.tryTower(quantumBitLength, entryBitLength, toTheEnd, this.cacheSkip, this.towerData, true);
        }
        int maxCacheDataLength = 0;
        k = 0;
        while (k <= (this.cache - 1) / this.q) {
            if (this.cacheDataLength[k] > maxCacheDataLength) {
                maxCacheDataLength = this.cacheDataLength[k];
            }
            ++k;
        }
        int pos = 0;
        this.cacheDataOut.align();
        if (this.cacheDataOut.buffer() != null) {
            buffer = this.cacheDataOut.buffer();
            direct = true;
        } else {
            this.cacheDataOut.flush();
            buffer = new byte[(maxCacheDataLength + 7) / 8];
            direct = false;
            this.cacheDataIn.reset();
            this.cacheDataIn.position(0L);
        }
        k = 0;
        while (k <= (this.cache - 1) / this.q) {
            int s;
            int n = s = k == 0 ? this.h : Fast.leastSignificantBit(k);
            if (this.cache < this.w) {
                s = Math.min(s, Fast.mostSignificantBit(this.cache / this.q - k));
            }
            d = this.cachePointer[k].writtenBits();
            this.cachePointer[k].flush();
            this.obs.write(this.cachePointerByte[k].array, (int)d);
            d = this.cacheSkip[k].writtenBits();
            this.cacheSkip[k].flush();
            if (s >= 0) {
                if (k == 0) {
                    if (this.prevQuantumBitLength < 0) {
                        this.bitsForQuantumBitLengths += (long)this.obs.writeLongDelta(quantumBitLength);
                        this.bitsForEntryBitLengths += (long)this.obs.writeLongDelta(entryBitLength);
                    } else {
                        this.bitsForQuantumBitLengths += (long)this.obs.writeLongDelta(Fast.int2nat(quantumBitLength - this.prevQuantumBitLength));
                        this.bitsForEntryBitLengths += (long)this.obs.writeLongDelta(Fast.int2nat(entryBitLength - this.prevEntryBitLength));
                    }
                    this.prevQuantumBitLength = quantumBitLength;
                    this.prevEntryBitLength = entryBitLength;
                    ++this.numberOfBlocks;
                }
                if (s > 0) {
                    this.obs.writeDelta(Fast.int2nat((int)d - entryBitLength * (s + 1)));
                }
            } else if (!assert && d != 0L) {
                throw new AssertionError();
            }
            this.obs.write(this.cacheSkipByte[k].array, (int)d);
            if (direct) {
                this.obs.write(buffer, pos * 8, this.cacheDataLength[k]);
                pos += (this.cacheDataLength[k] + 7) / 8;
            } else {
                this.cacheDataIn.read(buffer, 0, (this.cacheDataLength[k] + 7) / 8);
                this.obs.write(buffer, this.cacheDataLength[k]);
            }
            ++k;
        }
        k = 0;
        while (k <= (this.cache - 1) / this.q) {
            this.cachePointerByte[k].reset();
            this.cachePointer[k].writtenBits(0L);
            this.cacheSkipByte[k].reset();
            this.cacheSkip[k].writtenBits(0L);
            this.cacheDataOut.position(0L);
            this.cacheDataOut.writtenBits(0L);
            ++k;
        }
        this.cache = 0;
        if (!assert && this.obs.writtenBits() != this.writtenBits()) {
            throw new AssertionError();
        }
    }

    public long writtenBits() {
        return super.writtenBits() + this.towerData.bitsForTopSkipPointers + this.towerData.bitsForTopBitSkips + this.towerData.bitsForLowerSkipPointers + this.towerData.bitsForLowerBitSkips + this.towerData.bitsForTowerLengths + this.bitsForQuantumBitLengths + this.bitsForEntryBitLengths;
    }

    public Properties properties() {
        Properties result = super.properties();
        Class clazz = class$it$unimi$dsi$mg4j$index$SkipIndex;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$index$SkipIndex = SkipIndexWriter.class("[Lit.unimi.dsi.mg4j.index.SkipIndex;", false);
        }
        result.setProperty("indexclass", clazz.getName());
        result.setProperty("skipquantum", this.q);
        result.setProperty("skipheight", this.h);
        return result;
    }

    public void printStats(PrintStream stats) {
        stats.println("Skip towers: " + Fast.format(this.towerData.numberOfSkipTowers) + " (" + Fast.format(this.towerData.bitsForTowers()) + " bits [" + Fast.format((double)this.towerData.bitsForTowers() * 100.0 / (double)this.writtenBits()) + "%], " + Fast.format((double)this.towerData.bitsForTowers() / (double)this.towerData.numberOfSkipTowers) + " bits/tower)");
        stats.println("Skip entries: " + Fast.format(this.towerData.numberOfEntries()) + " (" + Fast.format((double)this.towerData.bitsForEntries() / (double)this.towerData.numberOfEntries()) + " bits/entry)");
        stats.println("Skip tower lengths: " + Fast.format(this.towerData.bitsForTowerLengths) + " bits (" + Fast.format((double)2 * (double)this.towerData.bitsForTowerLengths / (double)this.towerData.numberOfSkipTowers) + " bits/tower)");
        stats.println("Quantum bit lengths: " + Fast.format(this.bitsForQuantumBitLengths) + " bits (" + Fast.format((double)this.bitsForQuantumBitLengths / (double)this.numberOfBlocks) + " bits/block)");
        stats.println("Entry bit lengths: " + Fast.format(this.bitsForEntryBitLengths) + " bits (" + Fast.format((double)this.bitsForEntryBitLengths / (double)this.numberOfBlocks) + " bits/block)");
        stats.println("Top bit skips: " + Fast.format(this.towerData.bitsForTopBitSkips) + " bits (" + Fast.format((double)this.towerData.bitsForTopBitSkips / (double)this.towerData.numberOfTopEntries) + " bits/skip)");
        stats.println("Top pointer skips: " + Fast.format(this.towerData.bitsForTopSkipPointers) + " bits (" + Fast.format((double)this.towerData.bitsForTopSkipPointers / (double)this.towerData.numberOfTopEntries) + " bits/skip)");
        stats.println("Lower bit skips: " + Fast.format(this.towerData.bitsForLowerBitSkips) + " bits (" + Fast.format((double)this.towerData.bitsForLowerBitSkips / (double)this.towerData.numberOfLowerEntries) + " bits/skip)");
        stats.println("Lower pointer skips: " + Fast.format(this.towerData.bitsForLowerSkipPointers) + " bits (" + Fast.format((double)this.towerData.bitsForLowerSkipPointers / (double)this.towerData.numberOfLowerEntries) + " bits/skip)");
        stats.println("Bit skips: " + Fast.format(this.towerData.bitsForBitSkips()) + " bits (" + Fast.format((double)this.towerData.bitsForBitSkips() / (double)this.towerData.numberOfEntries()) + " bits/skip)");
        stats.println("Pointer skips: " + Fast.format(this.towerData.bitsForSkipPointers()) + " bits (" + Fast.format((double)this.towerData.bitsForSkipPointers() / (double)this.towerData.numberOfEntries()) + " bits/skip)");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public SkipIndexWriter(OutputBitStream obs, OutputBitStream offset, int N, long flags, int q, int h) throws IOException {
        super(obs, offset, N, flags);
        this.h = h;
        this.q = q;
        int two2h = 1 << h;
        this.w = two2h * q;
        this.towerData = new TowerData();
        this.tempFile = File.createTempFile("MG4J", ".data");
        this.cacheDataIn = new FastBufferedInputStream((InputStream)new FileInputStream(this.tempFile));
        this.cacheDataOut = new CachingOutputBitStream(this.tempFile, 0x1000000);
        this.cacheDataLength = new int[two2h];
        this.cachePointer = new OutputBitStream[two2h];
        this.cachePointerByte = new FastByteArrayOutputStream[two2h];
        int i = 0;
        while (i < two2h) {
            this.cachePointerByte[i] = new FastByteArrayOutputStream();
            this.cachePointer[i] = new OutputBitStream(this.cachePointerByte[i], 0);
            ++i;
        }
        this.cacheSkip = new OutputBitStream[two2h];
        this.cacheSkipBitCount = new OutputBitStream[two2h];
        this.cacheSkipByte = new FastByteArrayOutputStream[two2h];
        i = 0;
        while (i < two2h) {
            this.cacheSkipByte[i] = new FastByteArrayOutputStream();
            this.cacheSkip[i] = new OutputBitStream(this.cacheSkipByte[i]);
            this.cacheSkipBitCount[i] = new OutputBitStream(NullOutputStream.getInstance(), 0);
            ++i;
        }
        this.skipPointer = new int[two2h + 1];
        this.distance = new long[two2h + 1];
        this.bitCount = new OutputBitStream(NullOutputStream.getInstance(), 0);
        this.towerTopB = new int[h + 1];
        this.towerTopLog2B = new int[h + 1];
        this.towerLowerB = new int[h + 1];
        this.towerLowerLog2B = new int[h + 1];
        this.pointerPrediction = new int[h + 1];
    }

    public SkipIndexWriter(OutputBitStream obs, int N, int flags, int q, int h) throws IOException {
        this(obs, null, N, flags, q, h);
    }

    static {
        assert = Class.forName("[Lit.unimi.dsi.mg4j.index.SkipIndexWriter;").getComponentType().desiredAssertionStatus() ^ true;
    }

    public static class TowerData {
        public long bitsForTopBitSkips;
        public long bitsForTopSkipPointers;
        public long bitsForLowerBitSkips;
        public long bitsForLowerSkipPointers;
        public long bitsForTowerLengths;
        public long numberOfSkipTowers;
        public long numberOfTopEntries;
        public long numberOfLowerEntries;

        void clear() {
            this.bitsForTopBitSkips = 0L;
            this.bitsForTopSkipPointers = 0L;
            this.bitsForLowerBitSkips = 0L;
            this.bitsForLowerSkipPointers = 0L;
            this.bitsForTowerLengths = 0L;
            this.numberOfSkipTowers = 0L;
            this.numberOfTopEntries = 0L;
            this.numberOfLowerEntries = 0L;
        }

        public long bitsForSkipPointers() {
            return this.bitsForTopSkipPointers + this.bitsForLowerSkipPointers;
        }

        public long bitsForBitSkips() {
            return this.bitsForTopBitSkips + this.bitsForLowerBitSkips;
        }

        public long bitsForEntries() {
            return this.bitsForSkipPointers() + this.bitsForBitSkips();
        }

        public long bitsForTowers() {
            return this.bitsForTowerLengths + this.bitsForEntries();
        }

        public long numberOfEntries() {
            return this.numberOfTopEntries + this.numberOfLowerEntries;
        }
    }
}

