/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.io;

import it.unimi.dsi.mg4j.io.InputBitStream;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ArithmeticDecoder {
    public static final int BITS = 63;
    private static final long HALF = 0x4000000000000000L;
    private static final long QUARTER = 0x2000000000000000L;
    private int[] count;
    private int total;
    private int n;
    private long range;
    private long buffer;
    private long window;

    private final void incrementCount(int x) {
        ++x;
        while (x <= this.n) {
            int n = x;
            this.count[n] = this.count[n] + 1;
            x += x & -x;
        }
    }

    private final int getCount(int x) {
        int c = 0;
        while (x != 0) {
            c += this.count[x];
            x &= x - 1;
        }
        return c;
    }

    public final int decode(InputBitStream ibs) throws IOException {
        long r;
        int x;
        if (this.buffer == (long)-1) {
            this.window = this.buffer = ibs.readLong(62);
        }
        if (this.total - 1 < (x = (int)(this.buffer / (r = this.range / (long)this.total)))) {
            x = this.total - 1;
        }
        int i = 1;
        while (i <= this.n) {
            if (x < this.getCount(i)) {
                x = i - 1;
                break;
            }
            ++i;
        }
        int lowCount = this.getCount(x);
        int highCount = this.getCount(x + 1);
        this.buffer -= r * (long)lowCount;
        this.range = x != this.n - 1 ? r * (long)(highCount - lowCount) : (this.range -= r * (long)lowCount);
        this.incrementCount(x);
        ++this.total;
        while (this.range <= 0x2000000000000000L) {
            this.buffer <<= 1;
            this.range <<= 1;
            this.window <<= 1;
            if (ibs.readBit() == 0) continue;
            ++this.buffer;
            ++this.window;
        }
        return x;
    }

    public final void flush(InputBitStream ibs) throws IOException {
        long low = (this.window & 0x3FFFFFFFFFFFFFFFL) + 0x4000000000000000L - this.buffer;
        int nbits = 1;
        while (nbits <= 63) {
            long roundup = (1L << 63 - nbits) - 1L;
            long bits = low + roundup >>> 63 - nbits;
            long value = bits << 63 - nbits;
            if (low <= value && (value + roundup <= low + (this.range - 1L) || value + roundup >= 0L && low + (this.range - 1L) < 0L)) break;
            ++nbits;
        }
        int i = 1;
        while (i <= nbits) {
            this.window <<= 1;
            this.window |= (long)ibs.readBit();
            ++i;
        }
    }

    public final long getWindow() {
        return this.window & Long.MAX_VALUE;
    }

    private final /* synthetic */ void this() {
        this.range = 0x4000000000000000L;
        this.buffer = -1;
        this.window = 0L;
    }

    public ArithmeticDecoder(int n) {
        this.this();
        if (n < 1) {
            throw new IllegalArgumentException("You cannot use " + n + " symbols.");
        }
        this.n = n;
        this.count = new int[n + 1];
        int i = 0;
        while (i < n) {
            this.incrementCount(i);
            ++i;
        }
        this.total = n;
    }
}

