/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.io;

import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.io.PrintStream;

public class DebugOutputBitStream
extends OutputBitStream {
    private PrintStream pw;
    private OutputBitStream obs;

    public void flush() throws IOException {
        this.pw.print(" |");
        this.obs.flush();
    }

    public void close() throws IOException {
        this.pw.print(" |]");
        this.obs.close();
    }

    public long writtenBits() {
        return this.obs.writtenBits();
    }

    public void writtenBits(long writtenBits) {
        this.obs.writtenBits(writtenBits);
    }

    public int align() throws IOException {
        this.pw.print(" |");
        return this.obs.align();
    }

    public void position(long position) throws IOException {
        this.pw.print(" ->" + position);
        this.obs.position(position);
    }

    private static final MutableString byte2Binary(int x) {
        MutableString s = new MutableString();
        int i = 0;
        while (i < 8) {
            s.append((char)(48 + x % 2));
            x >>= 1;
            ++i;
        }
        return s.reverse();
    }

    private static final MutableString int2Binary(long x, int len) {
        MutableString s = new MutableString();
        int i = 0;
        while (i < 64) {
            s.append((char)(48L + x % (long)2));
            x >>= 1;
            ++i;
        }
        return s.length(len).reverse();
    }

    public int write(byte[] bits, int len) throws IOException {
        MutableString s = new MutableString(" {");
        int i = 0;
        while (i < bits.length) {
            s.append(DebugOutputBitStream.byte2Binary(bits[i]));
            ++i;
        }
        this.pw.print(s.length(len).append("}"));
        return this.obs.write(bits, len);
    }

    public int writeBit(boolean bit) throws IOException {
        this.pw.print(" {" + (bit + 48) + '}');
        return this.obs.writeBit(bit);
    }

    public int writeBit(int bit) throws IOException {
        this.pw.print(" {" + bit + '}');
        return this.obs.writeBit(bit);
    }

    public int writeInt(int x, int len) throws IOException {
        this.pw.print(" {" + DebugOutputBitStream.int2Binary(x, len) + '}');
        return this.obs.writeInt(x, len);
    }

    public int writeLong(long x, int len) throws IOException {
        this.pw.print(" {" + DebugOutputBitStream.int2Binary(x, len) + '}');
        return this.obs.writeLong(x, len);
    }

    public int writeUnary(int x) throws IOException {
        this.pw.print(" {U:" + x + '}');
        return this.obs.writeUnary(x);
    }

    public long writeLongUnary(long x) throws IOException {
        this.pw.print(" {U:" + x + '}');
        return this.obs.writeLongUnary(x);
    }

    public int writeGamma(int x) throws IOException {
        this.pw.print(" {g:" + x + '}');
        return this.obs.writeGamma(x);
    }

    public int writeLongGamma(long x) throws IOException {
        this.pw.print(" {g:" + x + '}');
        return this.obs.writeLongGamma(x);
    }

    public int writeDelta(int x) throws IOException {
        this.pw.print(" {d:" + x + '}');
        return this.obs.writeDelta(x);
    }

    public int writeLongDelta(long x) throws IOException {
        this.pw.print(" {d:" + x + '}');
        return this.obs.writeLongDelta(x);
    }

    public int writeMinimalBinary(int x, int b) throws IOException {
        this.pw.print(" {m:" + x + '<' + b + '}');
        return this.obs.writeMinimalBinary(x, b);
    }

    public int writeMinimalBinary(int x, int b, int log2b) throws IOException {
        this.pw.print(" {m:" + x + '<' + b + '}');
        return this.obs.writeMinimalBinary(x, b, log2b);
    }

    public int writeLongMinimalBinary(long x, long b) throws IOException {
        this.pw.print(" {m:" + x + '<' + b + '}');
        return this.obs.writeLongMinimalBinary(x, b);
    }

    public int writeLongMinimalBinary(long x, long b, int log2b) throws IOException {
        this.pw.print(" {m:" + x + '<' + b + '}');
        return this.obs.writeLongMinimalBinary(x, b, log2b);
    }

    public int writeGolomb(int x, int b) throws IOException {
        this.pw.print(" {G:" + x + ':' + b + '}');
        return this.obs.writeGolomb(x, b);
    }

    public int writeGolomb(int x, int b, int log2b) throws IOException {
        this.pw.print(" {G:" + x + ':' + b + '}');
        return this.obs.writeGolomb(x, b, log2b);
    }

    public long writeLongGolomb(long x, long b) throws IOException {
        this.pw.print(" {G:" + x + ':' + b + '}');
        return this.obs.writeLongGolomb(x, b);
    }

    public long writeLongGolomb(long x, long b, int log2b) throws IOException {
        this.pw.print(" {G:" + x + ':' + b + '}');
        return this.obs.writeLongGolomb(x, b, log2b);
    }

    public int writeSkewedGolomb(int x, int b) throws IOException {
        this.pw.print(" {SG:" + x + ':' + b + '}');
        return this.obs.writeSkewedGolomb(x, b);
    }

    public long writeLongSkewedGolomb(long x, long b) throws IOException {
        this.pw.print(" {SG:" + x + ':' + b + '}');
        return this.obs.writeLongSkewedGolomb(x, b);
    }

    public int writeZeta(int x, int k) throws IOException {
        this.pw.print(" {z" + k + ':' + x + '}');
        return this.obs.writeZeta(x, k);
    }

    public long writeLongZeta(long x, int k) throws IOException {
        this.pw.print(" {z" + k + ':' + x + '}');
        return this.obs.writeLongZeta(x, k);
    }

    public DebugOutputBitStream(OutputBitStream obs, PrintStream pw) {
        this.obs = obs;
        this.pw = pw;
        pw.print("[");
    }

    public DebugOutputBitStream(OutputBitStream obs) {
        this(obs, System.err);
    }
}

