/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.io;

import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import java.io.IOException;

public final class InterpolativeCoding {
    public static final int write(OutputBitStream out, int[] data, int offset, int len, int lo, int hi) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (len == 1) {
            return out.writeMinimalBinary(data[offset] - lo, hi - lo + 1);
        }
        int h = len / 2;
        int m = data[offset + h];
        int l = out.writeMinimalBinary(m - (lo + h), hi - len + h + 1 - (lo + h) + 1);
        return (l += InterpolativeCoding.write(out, data, offset, h, lo, m - 1)) + InterpolativeCoding.write(out, data, offset + h + 1, len - h - 1, m + 1, hi);
    }

    public static final void read(InputBitStream in, int[] data, int offset, int len, int lo, int hi) throws IOException {
        if (len == 0) {
            return;
        }
        if (len == 1) {
            if (data != null) {
                data[offset] = in.readMinimalBinary(hi - lo + 1) + lo;
            } else {
                in.readMinimalBinary(hi - lo + 1);
            }
            return;
        }
        int h = len / 2;
        int m = in.readMinimalBinary(hi - len + h + 1 - (lo + h) + 1) + lo + h;
        if (data != null) {
            data[offset + h] = m;
        }
        InterpolativeCoding.read(in, data, offset, h, lo, m - 1);
        InterpolativeCoding.read(in, data, offset + h + 1, len - h - 1, m + 1, hi);
    }

    private InterpolativeCoding() {
    }
}

