/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.query.IntervalSelector;
import it.unimi.dsi.mg4j.query.Query;
import it.unimi.dsi.mg4j.query.QueryEngine;
import it.unimi.dsi.mg4j.query.parser.QueryParser;
import it.unimi.dsi.mg4j.search.score.Scorer;
import it.unimi.dsi.mg4j.search.score.VignaScorer;
import it.unimi.dsi.mg4j.util.Fast;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.velocity.app.Velocity;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HttpQueryServer {
    private static final Logger LOGGER;
    private static final boolean DEBUG = true;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$query$HttpQueryServer;
    static /* synthetic */ Class class$org$apache$velocity$runtime$resource$loader$ClasspathResourceLoader;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$query$Query;

    public static void main(String[] arg) throws Exception {
        Class clazz = class$it$unimi$dsi$mg4j$query$Query;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$query$Query = HttpQueryServer.class("[Lit.unimi.dsi.mg4j.query.Query;", false);
        }
        SimpleJSAP jsap = new SimpleJSAP(clazz.getName(), "Starts an HTTP server that provide query services for a document collection.", new Parameter[]{new FlaggedOption("itemClass", (StringParser)JSAP.CLASS_PARSER, JSAP.NO_DEFAULT, false, 'i', "item-class", "The class that will handle item display."), new FlaggedOption("itemMimeType", (StringParser)JSAP.STRING_PARSER, "text/html", false, 'm', "item-mime-type", "A MIME type suggested to the class handling item display."), new FlaggedOption("port", (StringParser)JSAP.INTEGER_PARSER, "4242", false, 'p', "port", "The port on localhost where the server will appear."), new FlaggedOption("collection", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "collection", "The collection of documents indexed by the given indices."), new UnflaggedOption("basenameWeight", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "The indices that the servlet will use. Indices are specified using their basename, optionally followed by a colon and a double representing the weight used to score results from that index. Indices without a specified weight are weighted 1.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        DocumentCollection documentCollection = (DocumentCollection)(jsapResult.getString("collection") != null ? BinIO.loadObject((CharSequence)jsapResult.getString("collection")) : null);
        String[] basenameWeight = jsapResult.getStringArray("basenameWeight");
        Reference2DoubleOpenHashMap weights = new Reference2DoubleOpenHashMap(basenameWeight.length, 0.5f);
        Object2ObjectLinkedOpenHashMap indexMap = new Object2ObjectLinkedOpenHashMap(basenameWeight.length, 0.5f);
        Query.parseBasenameWeights(basenameWeight, documentCollection, (Object2ObjectMap)indexMap, (Reference2DoubleMap)weights);
        QueryEngine queryEngine = new QueryEngine(new QueryParser((Map)indexMap, (String)indexMap.keySet().iterator().next(), documentCollection));
        queryEngine.countAll(true);
        queryEngine.weight((Reference2DoubleMap)weights);
        queryEngine.intervalSelector(new IntervalSelector());
        queryEngine.score(new Scorer[]{new VignaScorer()}, new double[]{1.0});
        new HttpQueryServer(queryEngine, jsapResult.getClass("itemClass"), jsapResult.getString("itemMimeType"), jsapResult.getInt("port"));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public HttpQueryServer(QueryEngine queryEngine, Class itemClass, String itemMimeType, int port) throws Exception {
        LOGGER.debug((Object)("itemClass: " + itemClass));
        LOGGER.debug((Object)("itemMimeType: " + itemMimeType));
        LOGGER.debug((Object)("queryEngine: " + queryEngine));
        LOGGER.debug((Object)("port: " + port));
        HttpServer server = new HttpServer();
        SocketListener listener = new SocketListener();
        listener.setPort(port);
        server.addListener((HttpListener)listener);
        HttpContext context = new HttpContext();
        context.setContextPath("");
        server.addContext(context);
        ServletHandler servlets = new ServletHandler();
        context.addHandler((HttpHandler)servlets);
        context.setAttribute("queryEngine", (Object)queryEngine);
        context.setAttribute("action", (Object)"/Query");
        servlets.addServlet("Query", "/Query", "it.unimi.dsi.mg4j.query.QueryServlet");
        Properties properties = new Properties();
        properties.setProperty("resource.loader", "class");
        Class clazz = class$org$apache$velocity$runtime$resource$loader$ClasspathResourceLoader;
        if (clazz == null) {
            clazz = class$org$apache$velocity$runtime$resource$loader$ClasspathResourceLoader = HttpQueryServer.class("[Lorg.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;", false);
        }
        properties.setProperty("class.resource.loader.class", clazz.getName());
        properties.setProperty("input.encoding", "utf-8");
        properties.setProperty("output.encoding", "utf-8");
        properties.setProperty("default.contentType", "text/html; charset=UTF-8");
        Velocity.init((Properties)properties);
        if (itemClass != null) {
            servlets.addServlet("Item", "/Item", itemClass.getName());
        } else {
            context.setAttribute("uri", (Object)Boolean.TRUE);
        }
        context.setAttribute("mimeType", (Object)itemMimeType);
        server.start();
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$query$HttpQueryServer;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$query$HttpQueryServer = HttpQueryServer.class("[Lit.unimi.dsi.mg4j.query.HttpQueryServer;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }
}

