/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.Intervals;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IntervalSelector {
    public static final int MAX_INTERVALS = 8;
    public static final int INTERVAL_MAX_LENGTH = 100;
    private static final Interval[] INIT = new Interval[]{Interval.getInstance(-1), Interval.getInstance(Integer.MAX_VALUE)};
    private final int maxIntervals;
    private final int intervalMaxLength;
    private final ObjectRBTreeSet leftOrderedIntervals;
    private final ObjectArrayList intervals;

    public Interval[] select(IntervalIterator intervalIterator) {
        ObjectBidirectionalIterator iterator;
        if (intervalIterator == IntervalIterators.TRUE || !intervalIterator.hasNext()) {
            return Intervals.EMPTY_ARRAY;
        }
        this.intervals.clear();
        ObjectIterators.pour((Iterator)intervalIterator, (ObjectCollection)this.intervals);
        ObjectHeapPriorityQueue shortIntervals = new ObjectHeapPriorityQueue(this.intervals.elements(), this.intervals.size(), Intervals.LENGTH_COMPARATOR);
        this.leftOrderedIntervals.add((Object)INIT[0]);
        this.leftOrderedIntervals.add((Object)INIT[1]);
        Interval interval = (Interval)shortIntervals.dequeue();
        if (interval.length() < this.intervalMaxLength) {
            this.leftOrderedIntervals.add((Object)interval);
        } else {
            this.leftOrderedIntervals.add((Object)Interval.getInstance(interval.left, interval.left + this.intervalMaxLength / 2));
            this.leftOrderedIntervals.add((Object)Interval.getInstance(interval.right - this.intervalMaxLength / 2, interval.right));
        }
        while (this.leftOrderedIntervals.size() < this.maxIntervals + INIT.length && !shortIntervals.isEmpty()) {
            interval = (Interval)shortIntervals.dequeue();
            if (interval.length() > this.intervalMaxLength) break;
            iterator = this.leftOrderedIntervals.iterator((Object)interval);
            iterator.previous();
            Interval left = (Interval)iterator.next();
            Interval right = (Interval)iterator.next();
            if (interval.left <= left.right || interval.right >= right.left) continue;
            this.leftOrderedIntervals.add((Object)interval);
        }
        iterator = (ObjectBidirectionalIterator)this.leftOrderedIntervals.iterator();
        iterator.next();
        Interval[] result = new Interval[this.leftOrderedIntervals.size() - INIT.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (Interval)iterator.next();
            ++i;
        }
        this.leftOrderedIntervals.clear();
        return result;
    }

    public Reference2ReferenceMap select(DocumentIterator documentIterator, Reference2ReferenceMap index2Interval) {
        index2Interval.clear();
        Iterator i = documentIterator.indices().iterator();
        while (i.hasNext()) {
            IntervalIterator intervalIterator;
            Index index = (Index)i.next();
            if (!index.hasPositions || (intervalIterator = documentIterator.intervalIterator(index)) == IntervalIterators.TRUE) continue;
            index2Interval.put((Object)index, (Object)this.select(documentIterator.intervalIterator(index)));
        }
        return index2Interval;
    }

    public static Reference2ReferenceMap selectAll(DocumentIterator documentIterator, Reference2ReferenceMap index2Interval) {
        index2Interval.clear();
        ObjectArrayList intervals = new ObjectArrayList();
        Iterator i = documentIterator.indices().iterator();
        while (i.hasNext()) {
            IntervalIterator intervalIterator;
            Index index = (Index)i.next();
            if (!index.hasPositions || (intervalIterator = documentIterator.intervalIterator(index)) == IntervalIterators.TRUE) continue;
            intervals.clear();
            ObjectIterators.pour((Iterator)intervalIterator, (ObjectCollection)intervals);
            index2Interval.put((Object)index, (Object)intervals.toArray((Object[])Intervals.EMPTY_ARRAY));
        }
        return index2Interval;
    }

    private final /* synthetic */ void this() {
        this.leftOrderedIntervals = new ObjectRBTreeSet(Intervals.STARTS_BEFORE_OR_PROLONGS);
        this.intervals = new ObjectArrayList();
    }

    public IntervalSelector(int maxIntervals, int intervalMaxLength) {
        this.this();
        this.maxIntervals = maxIntervals;
        this.intervalMaxLength = intervalMaxLength;
    }

    public IntervalSelector() {
        this(8, 100);
    }
}

