/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.score.AbstractIntervalScorer;
import it.unimi.dsi.mg4j.util.MutableString;

public class ClarkeCormackScorer
extends AbstractIntervalScorer {
    private int h;
    private double alpha;
    private boolean normalize;

    protected double score(IntervalIterator it) {
        if (it == IntervalIterators.TRUE || it == IntervalIterators.FALSE) {
            return 0.0;
        }
        double result = 0.0;
        int count = 0;
        while (it.hasNext()) {
            ++count;
            int lt = it.nextInterval().length();
            if (lt < this.h) {
                result += 1.0;
                continue;
            }
            result += Math.pow((double)this.h / (double)lt, this.alpha);
        }
        return this.normalize ? result / (double)count : result;
    }

    public boolean isNormalized() {
        return this.normalize;
    }

    public String toString() {
        return new MutableString("Clarke-Cormack(").append(this.h).append(", ").append(this.alpha).append(", ").append(this.normalize).append(')').toString();
    }

    public ClarkeCormackScorer(int h, double alpha, boolean normalize) {
        this.h = h;
        this.alpha = alpha;
        this.normalize = normalize;
    }

    public ClarkeCormackScorer() {
        this(16, 1.0, false);
    }
}

