/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.LongSizeStringParser;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.document.InputStreamDocumentSequence;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.index.DowncaseTermProcessor;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.io.FileLinesCollection;
import it.unimi.dsi.mg4j.tool.Combine;
import it.unimi.dsi.mg4j.tool.Concatenate;
import it.unimi.dsi.mg4j.tool.Merge;
import it.unimi.dsi.mg4j.tool.Scan;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.ImmutableExternalTriePrefixDictionary;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Index {
    private static final Logger LOGGER;
    public static final String DEFAULT_BUFFER_SIZE = "1Mi";
    public static final String DEFAULT_BATCH_SIZE = "2Mi";
    public static final int DEFAULT_DELIMITER = 10;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$tool$Index;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$IndexWriter;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$NullTermProcessor;

    public static DocumentSequence getSequence(String sequenceName, Class factoryClass, String[] property, int delimiter) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, ClassNotFoundException, InstantiationException {
        if (sequenceName != null) {
            return (DocumentSequence)BinIO.loadObject((CharSequence)sequenceName);
        }
        LOGGER.debug((Object)("Documents will be separated by the Unicode character " + delimiter));
        PropertyBasedDocumentFactory factory = PropertyBasedDocumentFactory.getInstance(factoryClass, property);
        return new InputStreamDocumentSequence(System.in, delimiter, factory);
    }

    public static int[] parseFieldNames(String[] indexedFieldName, DocumentFactory factory) {
        int i;
        IntArrayList indexedFields = new IntArrayList();
        if (indexedFieldName.length == 0) {
            i = 0;
            while (i < factory.numberOfFields()) {
                if (factory.fieldType(i) == 0) {
                    indexedFields.add(i);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < indexedFieldName.length) {
                int field = factory.fieldIndex(indexedFieldName[i]);
                if (field < 0) {
                    throw new IllegalArgumentException("Field " + indexedFieldName[i] + " is not part of factory " + factory.getClass().getName());
                }
                if (factory.fieldType(field) != 0) {
                    throw new IllegalArgumentException("You cannot index field " + indexedFieldName[i] + " as it is not a text field");
                }
                indexedFields.add(field);
                ++i;
            }
        }
        int[] indexedField = indexedFields.toIntArray();
        Arrays.sort(indexedField);
        return indexedField;
    }

    public static int[] parseQualifiedSizes(String[] qualifiedSizes, String defaultSize, int[] indexedField, DocumentFactory factory) throws ParseException {
        int[] size = new int[indexedField.length];
        String defaultSpec = defaultSize;
        IntArrayList indexedFields = IntArrayList.wrap((int[])indexedField);
        int i = 0;
        while (i < qualifiedSizes.length) {
            if (qualifiedSizes[i].indexOf(58) == -1) {
                defaultSpec = qualifiedSizes[i];
            }
            ++i;
        }
        i = 0;
        while (i < size.length) {
            size[i] = (int)LongSizeStringParser.parseSize((CharSequence)defaultSpec);
            ++i;
        }
        i = 0;
        while (i < qualifiedSizes.length) {
            int split = qualifiedSizes[i].indexOf(58);
            if (split >= 0) {
                String fieldName = qualifiedSizes[i].substring(0, split);
                int field = factory.fieldIndex(fieldName);
                if (field < 0) {
                    throw new IllegalArgumentException("Field " + fieldName + " is not part of factory " + factory.getClass().getName());
                }
                if (!indexedFields.contains(field)) {
                    throw new IllegalArgumentException("Field " + factory.fieldName(field) + " is not being indexed");
                }
                size[indexedFields.indexOf((int)field)] = (int)LongSizeStringParser.parseSize((CharSequence)qualifiedSizes[i].substring(split + 1));
            }
            ++i;
        }
        return size;
    }

    public static long parseCompressionFlags(String[] compFlag, MutableString writerFlagsString) {
        long writerFlags = 0L;
        writerFlagsString.length(0);
        int i = 0;
        while (i < compFlag.length) {
            try {
                Class clazz = class$it$unimi$dsi$mg4j$index$IndexWriter;
                if (clazz == null) {
                    clazz = Index.class("[Lit.unimi.dsi.mg4j.index.IndexWriter;", false);
                }
                Field field = clazz.getField(compFlag[i]);
                Class clazz2 = class$it$unimi$dsi$mg4j$index$IndexWriter;
                if (clazz2 == null) {
                    clazz2 = Index.class("[Lit.unimi.dsi.mg4j.index.IndexWriter;", false);
                }
                writerFlags |= field.getLong(clazz2);
                if (writerFlagsString.length() != 0) {
                    writerFlagsString.append(" | ");
                }
                writerFlagsString.append(compFlag[i]);
            }
            catch (Exception notFound) {
                throw new IllegalArgumentException("Compression method " + compFlag[i] + " unknown.");
            }
            ++i;
        }
        return writerFlags;
    }

    public static void run(String basename, DocumentSequence documentSequence, TermProcessor termProcessor, String zipCollectionBasename, int bufferSize, boolean keepUnsorted, int[] indexedField, int[] occsPerBatch, String permutationFile, boolean skips, long writerFlags, CharSequence writerFlagsString, int quantum, int height, long logInterval, String tempDirName) throws ConfigurationException, IOException {
        DocumentFactory factory = documentSequence.factory();
        String[] basenameField = new String[indexedField.length];
        int i = 0;
        while (i < indexedField.length) {
            basenameField[i] = basename + '-' + factory.fieldName(indexedField[i]);
            ++i;
        }
        LOGGER.info((Object)("Creating indices " + Arrays.asList(basenameField) + "..."));
        Scan.run(basename, documentSequence, termProcessor, zipCollectionBasename, bufferSize, indexedField, occsPerBatch, permutationFile, keepUnsorted, logInterval, tempDirName);
        i = 0;
        while (i < indexedField.length) {
            if (permutationFile != null) {
                new Merge(basenameField[i], Combine.batches(basenameField[i]), bufferSize, writerFlags, writerFlagsString, skips, quantum, height, logInterval).run();
            } else {
                new Concatenate(basenameField[i], Combine.batches(basenameField[i]), bufferSize, writerFlags, writerFlagsString, skips, quantum, height, logInterval).run();
            }
            ++i;
        }
        LOGGER.info((Object)"Creating prefix maps...");
        i = 0;
        while (i < indexedField.length) {
            BinIO.storeObject((Object)new ImmutableExternalTriePrefixDictionary(new FileLinesCollection(basenameField[i] + ".terms", "UTF-8")), (CharSequence)(basenameField[i] + ".termmap"));
            ++i;
        }
        LOGGER.info((Object)"Indexing completed.");
    }

    public static void main(String[] arg) throws JSAPException, InvocationTargetException, NoSuchMethodException, IllegalArgumentException, SecurityException, IllegalAccessException, ConfigurationException, ClassNotFoundException, IOException, InstantiationException {
        Class clazz = class$it$unimi$dsi$mg4j$tool$Index;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$tool$Index = Index.class("[Lit.unimi.dsi.mg4j.tool.Index;", false);
        }
        String string = clazz.getName();
        Parameter[] parameterArray = new Parameter[19];
        parameterArray[0] = new FlaggedOption("sequence", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'S', "sequence", "A serialised document sequence that will be used instead of stdin.");
        Class clazz2 = class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory;
        if (clazz2 == null) {
            clazz2 = class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory = Index.class("[Lit.unimi.dsi.mg4j.document.IdentityDocumentFactory;", false);
        }
        parameterArray[1] = new FlaggedOption("factory", (StringParser)JSAP.CLASS_PARSER, clazz2.getName(), false, 'f', "factory", "A document factory with a standard constructor.");
        parameterArray[2] = new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true);
        Class clazz3 = class$it$unimi$dsi$mg4j$index$NullTermProcessor;
        if (clazz3 == null) {
            clazz3 = class$it$unimi$dsi$mg4j$index$NullTermProcessor = Index.class("[Lit.unimi.dsi.mg4j.index.NullTermProcessor;", false);
        }
        parameterArray[3] = new FlaggedOption("termProcessor", (StringParser)JSAP.CLASS_PARSER, clazz3.getName(), false, 't', "term-processor", "Sets the term processor to the given class.");
        parameterArray[4] = new Switch("downcase", '\u0000', "downcase", "A shortcut for setting the term processor to the downcasing processor.");
        parameterArray[5] = new FlaggedOption("indexedField", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'I', "indexed-field", "The field(s) of the document factory that will be indexed. (default: all fields)").setAllowMultipleDeclarations(true);
        parameterArray[6] = new FlaggedOption("batchSize", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 's', "batch-size", "The size of a batch. It can be specified several times in the form [<field>:]<size>. If the field is omitted, it sets the batch size for all fields. (default: 2Mi)").setAllowMultipleDeclarations(true);
        parameterArray[7] = new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, DEFAULT_BUFFER_SIZE, false, 'b', "buffer-size", "The size of an I/O buffer.");
        parameterArray[8] = new FlaggedOption("delimiter", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(10), false, 'd', "delimiter", "The document delimiter.");
        parameterArray[9] = new FlaggedOption("renumber", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'r', "renumber", "The filename of a document renumbering.");
        parameterArray[10] = new FlaggedOption("zipCollection", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'z', "zip", "Creates a support ZipDocumentCollection with given basename.");
        parameterArray[11] = new FlaggedOption("comp", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "comp", "A compression flag for the index (may be specified several times).").setAllowMultipleDeclarations(true);
        parameterArray[12] = new Switch("skips", '\u0000', "skips", "Whether the resulting index should contain skips.");
        parameterArray[13] = new FlaggedOption("quantum", (StringParser)JSAP.INTSIZE_PARSER, "64", false, 'Q', "quantum", "Enable skips with given quantum.");
        parameterArray[14] = new FlaggedOption("height", (StringParser)JSAP.INTSIZE_PARSER, "8", false, 'H', "height", "Enable skips with given height.");
        parameterArray[15] = new Switch("keepUnsorted", 'u', "keep-unsorted", "Keep the unsorted term file.");
        parameterArray[16] = new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds.");
        parameterArray[17] = new FlaggedOption("tempDir", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for all temporary files (e.g., batches).");
        parameterArray[18] = new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the resulting index.");
        SimpleJSAP jsap = new SimpleJSAP(string, "Builds a set of batches from a sequence of documents.", parameterArray);
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        DocumentSequence documentSequence = Index.getSequence(jsapResult.getString("sequence"), jsapResult.getClass("factory"), jsapResult.getStringArray("property"), jsapResult.getInt("delimiter"));
        DocumentFactory factory = documentSequence.factory();
        Class termProcessorClass = jsapResult.getClass("termProcessor");
        int[] indexedField = Index.parseFieldNames(jsapResult.getStringArray("indexedField"), factory);
        int[] occsPerBatch = Index.parseQualifiedSizes(jsapResult.getStringArray("batchSize"), DEFAULT_BATCH_SIZE, indexedField, factory);
        TermProcessor termProcessor = jsapResult.getBoolean("downcase") ? DowncaseTermProcessor.getInstance() : (TermProcessor)termProcessorClass.getMethod("getInstance", null).invoke((Object)termProcessorClass, null);
        String basename = jsapResult.getString("basename");
        int bufferSize = jsapResult.getInt("bufferSize");
        MutableString writerFlagsString = new MutableString();
        long writerFlags = Index.parseCompressionFlags(jsapResult.getStringArray("comp"), writerFlagsString);
        boolean skips = jsapResult.getBoolean("skips");
        if (!skips && (jsapResult.userSpecified("quantum") || jsapResult.userSpecified("height"))) {
            System.err.println("You specified quantum or height, but did not turn on skips.");
            return;
        }
        Index.run(basename, documentSequence, termProcessor, jsapResult.getString("zipCollection"), bufferSize, jsapResult.getBoolean("keepUnsorted"), indexedField, occsPerBatch, jsapResult.getString("renumber"), skips, writerFlags, writerFlagsString, jsapResult.getInt("quantum"), jsapResult.getInt("height"), jsapResult.getLong("logInterval"), jsapResult.getString("tempDir"));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$tool$Index;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$tool$Index = Index.class("[Lit.unimi.dsi.mg4j.tool.Index;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }
}

