/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import cern.colt.bitvector.QuickBitVector;
import cern.jet.random.engine.MersenneTwister;
import java.io.Serializable;

public class BloomFilter
implements Serializable {
    public static final int NUMBER_OF_WEIGHTS = 16;
    private static final double NATURAL_LOG_OF_2 = Math.log(2);
    private static final boolean DEBUG = false;
    public final int m;
    public final int d;
    private final long[] bits;
    private final int[][] weight;
    private int size;

    public int size() {
        return this.size;
    }

    private final int hash(CharSequence s, int l, int k) {
        int[] w = this.weight[k];
        int h = 0;
        int i = l;
        while (i-- != 0) {
            h ^= s.charAt(i) * w[i % 16];
        }
        return (h & Integer.MAX_VALUE) % this.m;
    }

    public boolean contains(CharSequence s) {
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            if (QuickBitVector.get((long[])this.bits, (int)this.hash(s, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean add(CharSequence s) {
        boolean result = false;
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            int h = this.hash(s, l, i);
            if (!QuickBitVector.get((long[])this.bits, (int)h)) {
                result = true;
            }
            QuickBitVector.set((long[])this.bits, (int)h);
        }
        if (result) {
            ++this.size;
        }
        return result;
    }

    public BloomFilter(int n, int d) {
        this.d = d;
        this.bits = new long[(int)Math.ceil((double)(n * d) / NATURAL_LOG_OF_2 / 64.0)];
        if (this.bits.length > 0x1FFFFFF) {
            throw new IllegalArgumentException("This filter would require " + (long)this.bits.length * 64L + " bits");
        }
        this.m = this.bits.length * 64;
        MersenneTwister mersenneTwister = new MersenneTwister();
        this.weight = new int[d][];
        int i = 0;
        while (i < d) {
            this.weight[i] = new int[16];
            int j = 0;
            while (j < 16) {
                this.weight[i][j] = mersenneTwister.nextInt();
                ++j;
            }
            ++i;
        }
    }
}

