/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class Fast {
    public static final double[] GOLOMB_STEP = new double[]{0.3819660112501052, 0.245122333753307, 0.1808274866038356, 0.1433251161454971, 0.1187285383664304, 0.1013462873713007, 0.0884076465179451, 0.078400680366017, 0.0704298717679771, 0.0639308889222416, 0.0585303826783648, 0.0539714717143864, 0.0500716000363801, 0.0466974625983358, 0.0437494423620109};
    public static final int GOLOMB_STEP_LENGTH = GOLOMB_STEP.length;
    public static final double GOLOMB_THRESHOLD = 0.0411515989924386;
    public static final double GOLOMB_ADD = -(1.0 + Math.log(2)) / (double)2;
    public static final double GOLOMB_MULT = Math.log(2);
    protected static final double GOLOMB_GAUSSIAN = (double)2 * Math.sqrt(0.6366197723675814) * Math.log(2);
    private static final NumberFormat formatDouble = new DecimalFormat("#,##0.00");
    private static final NumberFormat formatLong = new DecimalFormat("#,###");
    private static final Pattern PARSE_SIZE_REGEX = Pattern.compile("(\\d+)([KMGT]i?)?");
    private static final Object2LongOpenHashMap UNIT2SIZE = new Object2LongOpenHashMap();
    public static final int[] BYTELSB;
    public static final int[] BYTEMSB;

    public static final int mostSignificantBit(int x) {
        int n;
        if (x < 32768) {
            if (x < 128) {
                if (x < 8) {
                    if (x < 2) {
                        n = 0;
                        if (x < 1) {
                            n = x < 0 ? 31 : -1;
                        }
                    } else {
                        int n2 = 0;
                        if (x < 4) {
                            n2 = 1;
                        }
                        n = 2 - n2;
                    }
                } else if (x < 32) {
                    int n3 = 0;
                    if (x < 16) {
                        n3 = 1;
                    }
                    n = 4 - n3;
                } else {
                    int n4 = 0;
                    if (x < 64) {
                        n4 = 1;
                    }
                    n = 6 - n4;
                }
            } else if (x < 2048) {
                if (x < 512) {
                    int n5 = 0;
                    if (x < 256) {
                        n5 = 1;
                    }
                    n = 8 - n5;
                } else {
                    int n6 = 0;
                    if (x < 1024) {
                        n6 = 1;
                    }
                    n = 10 - n6;
                }
            } else if (x < 8192) {
                int n7 = 0;
                if (x < 4096) {
                    n7 = 1;
                }
                n = 12 - n7;
            } else {
                int n8 = 0;
                if (x < 16384) {
                    n8 = 1;
                }
                n = 14 - n8;
            }
        } else if (x < 0x800000) {
            if (x < 524288) {
                if (x < 131072) {
                    int n9 = 0;
                    if (x < 65536) {
                        n9 = 1;
                    }
                    n = 16 - n9;
                } else {
                    int n10 = 0;
                    if (x < 262144) {
                        n10 = 1;
                    }
                    n = 18 - n10;
                }
            } else if (x < 0x200000) {
                int n11 = 0;
                if (x < 0x100000) {
                    n11 = 1;
                }
                n = 20 - n11;
            } else {
                int n12 = 0;
                if (x < 0x400000) {
                    n12 = 1;
                }
                n = 22 - n12;
            }
        } else if (x < 0x8000000) {
            if (x < 0x2000000) {
                int n13 = 0;
                if (x < 0x1000000) {
                    n13 = 1;
                }
                n = 24 - n13;
            } else {
                int n14 = 0;
                if (x < 0x4000000) {
                    n14 = 1;
                }
                n = 26 - n14;
            }
        } else if (x < 0x20000000) {
            int n15 = 0;
            if (x < 0x10000000) {
                n15 = 1;
            }
            n = 28 - n15;
        } else {
            int n16 = 0;
            if (x < 0x40000000) {
                n16 = 1;
            }
            n = 30 - n16;
        }
        return n;
    }

    public static final int mostSignificantBit(long x) {
        int n;
        if (x < 0x80000000L) {
            if (x < 32768L) {
                if (x < 128L) {
                    if (x < 8L) {
                        if (x < (long)2) {
                            n = 0;
                            if (x < 1L) {
                                n = x < 0L ? 63 : -1;
                            }
                        } else {
                            int n2 = 0;
                            if (x < (long)4) {
                                n2 = 1;
                            }
                            n = 2 - n2;
                        }
                    } else if (x < 32L) {
                        int n3 = 0;
                        if (x < 16L) {
                            n3 = 1;
                        }
                        n = 4 - n3;
                    } else {
                        int n4 = 0;
                        if (x < 64L) {
                            n4 = 1;
                        }
                        n = 6 - n4;
                    }
                } else if (x < 2048L) {
                    if (x < 512L) {
                        int n5 = 0;
                        if (x < 256L) {
                            n5 = 1;
                        }
                        n = 8 - n5;
                    } else {
                        int n6 = 0;
                        if (x < 1024L) {
                            n6 = 1;
                        }
                        n = 10 - n6;
                    }
                } else if (x < 8192L) {
                    int n7 = 0;
                    if (x < 4096L) {
                        n7 = 1;
                    }
                    n = 12 - n7;
                } else {
                    int n8 = 0;
                    if (x < 16384L) {
                        n8 = 1;
                    }
                    n = 14 - n8;
                }
            } else if (x < 0x800000L) {
                if (x < 524288L) {
                    if (x < 131072L) {
                        int n9 = 0;
                        if (x < 65536L) {
                            n9 = 1;
                        }
                        n = 16 - n9;
                    } else {
                        int n10 = 0;
                        if (x < 262144L) {
                            n10 = 1;
                        }
                        n = 18 - n10;
                    }
                } else if (x < 0x200000L) {
                    int n11 = 0;
                    if (x < 0x100000L) {
                        n11 = 1;
                    }
                    n = 20 - n11;
                } else {
                    int n12 = 0;
                    if (x < 0x400000L) {
                        n12 = 1;
                    }
                    n = 22 - n12;
                }
            } else if (x < 0x8000000L) {
                if (x < 0x2000000L) {
                    int n13 = 0;
                    if (x < 0x1000000L) {
                        n13 = 1;
                    }
                    n = 24 - n13;
                } else {
                    int n14 = 0;
                    if (x < 0x4000000L) {
                        n14 = 1;
                    }
                    n = 26 - n14;
                }
            } else if (x < 0x20000000L) {
                int n15 = 0;
                if (x < 0x10000000L) {
                    n15 = 1;
                }
                n = 28 - n15;
            } else {
                int n16 = 0;
                if (x < 0x40000000L) {
                    n16 = 1;
                }
                n = 30 - n16;
            }
        } else if (x < 0x800000000000L) {
            if (x < 0x8000000000L) {
                if (x < 0x800000000L) {
                    if (x < 0x200000000L) {
                        int n17 = 0;
                        if (x < 0x100000000L) {
                            n17 = 1;
                        }
                        n = 32 - n17;
                    } else {
                        int n18 = 0;
                        if (x < 0x400000000L) {
                            n18 = 1;
                        }
                        n = 34 - n18;
                    }
                } else if (x < 0x2000000000L) {
                    int n19 = 0;
                    if (x < 0x1000000000L) {
                        n19 = 1;
                    }
                    n = 36 - n19;
                } else {
                    int n20 = 0;
                    if (x < 0x4000000000L) {
                        n20 = 1;
                    }
                    n = 38 - n20;
                }
            } else if (x < 0x80000000000L) {
                if (x < 0x20000000000L) {
                    int n21 = 0;
                    if (x < 0x10000000000L) {
                        n21 = 1;
                    }
                    n = 40 - n21;
                } else {
                    int n22 = 0;
                    if (x < 0x40000000000L) {
                        n22 = 1;
                    }
                    n = 42 - n22;
                }
            } else if (x < 0x200000000000L) {
                int n23 = 0;
                if (x < 0x100000000000L) {
                    n23 = 1;
                }
                n = 44 - n23;
            } else {
                int n24 = 0;
                if (x < 0x400000000000L) {
                    n24 = 1;
                }
                n = 46 - n24;
            }
        } else if (x < 0x80000000000000L) {
            if (x < 0x8000000000000L) {
                if (x < 0x2000000000000L) {
                    int n25 = 0;
                    if (x < 0x1000000000000L) {
                        n25 = 1;
                    }
                    n = 48 - n25;
                } else {
                    int n26 = 0;
                    if (x < 0x4000000000000L) {
                        n26 = 1;
                    }
                    n = 50 - n26;
                }
            } else if (x < 0x20000000000000L) {
                int n27 = 0;
                if (x < 0x10000000000000L) {
                    n27 = 1;
                }
                n = 52 - n27;
            } else {
                int n28 = 0;
                if (x < 0x40000000000000L) {
                    n28 = 1;
                }
                n = 54 - n28;
            }
        } else if (x < 0x800000000000000L) {
            if (x < 0x200000000000000L) {
                int n29 = 0;
                if (x < 0x100000000000000L) {
                    n29 = 1;
                }
                n = 56 - n29;
            } else {
                int n30 = 0;
                if (x < 0x400000000000000L) {
                    n30 = 1;
                }
                n = 58 - n30;
            }
        } else if (x < 0x2000000000000000L) {
            int n31 = 0;
            if (x < 0x1000000000000000L) {
                n31 = 1;
            }
            n = 60 - n31;
        } else {
            int n32 = 0;
            if (x < 0x4000000000000000L) {
                n32 = 1;
            }
            n = 62 - n32;
        }
        return n;
    }

    public static final int leastSignificantBit(int x) {
        if (x == 0) {
            return -1;
        }
        if ((x & 0xFF) != 0) {
            return BYTELSB[x & 0xFF];
        }
        if ((x & (char)-1) != 0) {
            return BYTELSB[x >>> 8 & 0xFF] + 8;
        }
        if ((x & 0xFFFFFF) != 0) {
            return BYTELSB[x >>> 16 & 0xFF] + 16;
        }
        return BYTELSB[x >>> 24 & 0xFF] + 24;
    }

    public static final int leastSignificantBit(long x) {
        if (x == 0L) {
            return -1;
        }
        if ((x & 0xFFL) != 0L) {
            return BYTELSB[(int)(x & 0xFFL)];
        }
        if ((x & 0xFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 8 & 0xFFL)] + 8;
        }
        if ((x & 0xFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 16 & 0xFFL)] + 16;
        }
        if ((x & (long)-1) != 0L) {
            return BYTELSB[(int)(x >>> 24 & 0xFFL)] + 24;
        }
        if ((x & 0xFFFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 32 & 0xFFL)] + 32;
        }
        if ((x & 0xFFFFFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 40 & 0xFFL)] + 40;
        }
        if ((x & 0xFFFFFFFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 48 & 0xFFL)] + 48;
        }
        return BYTELSB[(int)(x >>> 56 & 0xFFL)] + 56;
    }

    public static final int golombModulus(double p) {
        if (p < 0.0411515989924386) {
            return (int)Math.ceil(GOLOMB_ADD + GOLOMB_MULT / p);
        }
        int i = GOLOMB_STEP_LENGTH;
        while (i-- != 0) {
            if (!(p < GOLOMB_STEP[i])) continue;
            return i + 2;
        }
        return 1;
    }

    public static final int gaussianGolombModulus(double sigma) {
        return (int)Math.ceil(GOLOMB_GAUSSIAN * sigma);
    }

    public static final int int2nat(int x) {
        return x >= 0 ? x << 1 : (-x << 1) - 1;
    }

    public static final int nat2int(int x) {
        return x % 2 == 0 ? x >> 1 : -(x + 1 >> 1);
    }

    public static final String format(double d) {
        StringBuffer s = new StringBuffer();
        return formatDouble.format(d, s, new FieldPosition(0)).toString();
    }

    public static final String format(long l) {
        StringBuffer s = new StringBuffer();
        return formatLong.format(l, s, new FieldPosition(0)).toString();
    }

    public static final long parseSize(CharSequence s) {
        long size;
        Matcher m = PARSE_SIZE_REGEX.matcher(s);
        long unitSize = 1L;
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid size specification " + s);
        }
        if (m.group(2) != null) {
            unitSize = UNIT2SIZE.getLong((Object)m.group(2));
        }
        if (unitSize == 0L) {
            throw new IllegalArgumentException("Invalid unit specification " + m.group(2));
        }
        try {
            size = Integer.parseInt(m.group(1));
            if (size < 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid size specification " + m.group(1));
        }
        return size * unitSize;
    }

    public static final int parseIntSize(CharSequence s) {
        long size = Fast.parseSize(s);
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size specification " + s + " is larger than 2147483647");
        }
        return (int)size;
    }

    public static final boolean log4JIsConfigured() {
        if (Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            return true;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getAllAppenders().hasMoreElements()) continue;
            return true;
        }
        return false;
    }

    public static final void ensureLog4JIsConfigured() {
        if (!Fast.log4JIsConfigured()) {
            System.err.println("WARNING: MG4J is autoconfiguring Log4J. You should configure Log4J properly instead.");
            BasicConfigurator.configure();
            LogManager.getRootLogger().setLevel(Level.INFO);
        }
    }

    public static final Logger getLogger(Class klass) {
        Logger logger = Logger.getLogger((Class)klass);
        Fast.ensureLog4JIsConfigured();
        return logger;
    }

    private Fast() {
    }

    static {
        UNIT2SIZE.put((Object)"K", 1000L);
        UNIT2SIZE.put((Object)"M", 1000000L);
        UNIT2SIZE.put((Object)"G", 1000000000L);
        UNIT2SIZE.put((Object)"T", 1000000000000L);
        UNIT2SIZE.put((Object)"Ki", 1024L);
        UNIT2SIZE.put((Object)"Mi", 0x100000L);
        UNIT2SIZE.put((Object)"Gi", 0x40000000L);
        UNIT2SIZE.put((Object)"Ti", 0x10000000000L);
        int[] nArray = new int[256];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[4] = 2;
        nArray[6] = 1;
        nArray[8] = 3;
        nArray[10] = 1;
        nArray[12] = 2;
        nArray[14] = 1;
        nArray[16] = 4;
        nArray[18] = 1;
        nArray[20] = 2;
        nArray[22] = 1;
        nArray[24] = 3;
        nArray[26] = 1;
        nArray[28] = 2;
        nArray[30] = 1;
        nArray[32] = 5;
        nArray[34] = 1;
        nArray[36] = 2;
        nArray[38] = 1;
        nArray[40] = 3;
        nArray[42] = 1;
        nArray[44] = 2;
        nArray[46] = 1;
        nArray[48] = 4;
        nArray[50] = 1;
        nArray[52] = 2;
        nArray[54] = 1;
        nArray[56] = 3;
        nArray[58] = 1;
        nArray[60] = 2;
        nArray[62] = 1;
        nArray[64] = 6;
        nArray[66] = 1;
        nArray[68] = 2;
        nArray[70] = 1;
        nArray[72] = 3;
        nArray[74] = 1;
        nArray[76] = 2;
        nArray[78] = 1;
        nArray[80] = 4;
        nArray[82] = 1;
        nArray[84] = 2;
        nArray[86] = 1;
        nArray[88] = 3;
        nArray[90] = 1;
        nArray[92] = 2;
        nArray[94] = 1;
        nArray[96] = 5;
        nArray[98] = 1;
        nArray[100] = 2;
        nArray[102] = 1;
        nArray[104] = 3;
        nArray[106] = 1;
        nArray[108] = 2;
        nArray[110] = 1;
        nArray[112] = 4;
        nArray[114] = 1;
        nArray[116] = 2;
        nArray[118] = 1;
        nArray[120] = 3;
        nArray[122] = 1;
        nArray[124] = 2;
        nArray[126] = 1;
        nArray[128] = 7;
        nArray[130] = 1;
        nArray[132] = 2;
        nArray[134] = 1;
        nArray[136] = 3;
        nArray[138] = 1;
        nArray[140] = 2;
        nArray[142] = 1;
        nArray[144] = 4;
        nArray[146] = 1;
        nArray[148] = 2;
        nArray[150] = 1;
        nArray[152] = 3;
        nArray[154] = 1;
        nArray[156] = 2;
        nArray[158] = 1;
        nArray[160] = 5;
        nArray[162] = 1;
        nArray[164] = 2;
        nArray[166] = 1;
        nArray[168] = 3;
        nArray[170] = 1;
        nArray[172] = 2;
        nArray[174] = 1;
        nArray[176] = 4;
        nArray[178] = 1;
        nArray[180] = 2;
        nArray[182] = 1;
        nArray[184] = 3;
        nArray[186] = 1;
        nArray[188] = 2;
        nArray[190] = 1;
        nArray[192] = 6;
        nArray[194] = 1;
        nArray[196] = 2;
        nArray[198] = 1;
        nArray[200] = 3;
        nArray[202] = 1;
        nArray[204] = 2;
        nArray[206] = 1;
        nArray[208] = 4;
        nArray[210] = 1;
        nArray[212] = 2;
        nArray[214] = 1;
        nArray[216] = 3;
        nArray[218] = 1;
        nArray[220] = 2;
        nArray[222] = 1;
        nArray[224] = 5;
        nArray[226] = 1;
        nArray[228] = 2;
        nArray[230] = 1;
        nArray[232] = 3;
        nArray[234] = 1;
        nArray[236] = 2;
        nArray[238] = 1;
        nArray[240] = 4;
        nArray[242] = 1;
        nArray[244] = 2;
        nArray[246] = 1;
        nArray[248] = 3;
        nArray[250] = 1;
        nArray[252] = 2;
        nArray[254] = 1;
        BYTELSB = nArray;
        int[] nArray2 = new int[256];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 2;
        nArray2[5] = 2;
        nArray2[6] = 2;
        nArray2[7] = 2;
        nArray2[8] = 3;
        nArray2[9] = 3;
        nArray2[10] = 3;
        nArray2[11] = 3;
        nArray2[12] = 3;
        nArray2[13] = 3;
        nArray2[14] = 3;
        nArray2[15] = 3;
        nArray2[16] = 4;
        nArray2[17] = 4;
        nArray2[18] = 4;
        nArray2[19] = 4;
        nArray2[20] = 4;
        nArray2[21] = 4;
        nArray2[22] = 4;
        nArray2[23] = 4;
        nArray2[24] = 4;
        nArray2[25] = 4;
        nArray2[26] = 4;
        nArray2[27] = 4;
        nArray2[28] = 4;
        nArray2[29] = 4;
        nArray2[30] = 4;
        nArray2[31] = 4;
        nArray2[32] = 5;
        nArray2[33] = 5;
        nArray2[34] = 5;
        nArray2[35] = 5;
        nArray2[36] = 5;
        nArray2[37] = 5;
        nArray2[38] = 5;
        nArray2[39] = 5;
        nArray2[40] = 5;
        nArray2[41] = 5;
        nArray2[42] = 5;
        nArray2[43] = 5;
        nArray2[44] = 5;
        nArray2[45] = 5;
        nArray2[46] = 5;
        nArray2[47] = 5;
        nArray2[48] = 5;
        nArray2[49] = 5;
        nArray2[50] = 5;
        nArray2[51] = 5;
        nArray2[52] = 5;
        nArray2[53] = 5;
        nArray2[54] = 5;
        nArray2[55] = 5;
        nArray2[56] = 5;
        nArray2[57] = 5;
        nArray2[58] = 5;
        nArray2[59] = 5;
        nArray2[60] = 5;
        nArray2[61] = 5;
        nArray2[62] = 5;
        nArray2[63] = 5;
        nArray2[64] = 6;
        nArray2[65] = 6;
        nArray2[66] = 6;
        nArray2[67] = 6;
        nArray2[68] = 6;
        nArray2[69] = 6;
        nArray2[70] = 6;
        nArray2[71] = 6;
        nArray2[72] = 6;
        nArray2[73] = 6;
        nArray2[74] = 6;
        nArray2[75] = 6;
        nArray2[76] = 6;
        nArray2[77] = 6;
        nArray2[78] = 6;
        nArray2[79] = 6;
        nArray2[80] = 6;
        nArray2[81] = 6;
        nArray2[82] = 6;
        nArray2[83] = 6;
        nArray2[84] = 6;
        nArray2[85] = 6;
        nArray2[86] = 6;
        nArray2[87] = 6;
        nArray2[88] = 6;
        nArray2[89] = 6;
        nArray2[90] = 6;
        nArray2[91] = 6;
        nArray2[92] = 6;
        nArray2[93] = 6;
        nArray2[94] = 6;
        nArray2[95] = 6;
        nArray2[96] = 6;
        nArray2[97] = 6;
        nArray2[98] = 6;
        nArray2[99] = 6;
        nArray2[100] = 6;
        nArray2[101] = 6;
        nArray2[102] = 6;
        nArray2[103] = 6;
        nArray2[104] = 6;
        nArray2[105] = 6;
        nArray2[106] = 6;
        nArray2[107] = 6;
        nArray2[108] = 6;
        nArray2[109] = 6;
        nArray2[110] = 6;
        nArray2[111] = 6;
        nArray2[112] = 6;
        nArray2[113] = 6;
        nArray2[114] = 6;
        nArray2[115] = 6;
        nArray2[116] = 6;
        nArray2[117] = 6;
        nArray2[118] = 6;
        nArray2[119] = 6;
        nArray2[120] = 6;
        nArray2[121] = 6;
        nArray2[122] = 6;
        nArray2[123] = 6;
        nArray2[124] = 6;
        nArray2[125] = 6;
        nArray2[126] = 6;
        nArray2[127] = 6;
        nArray2[128] = 7;
        nArray2[129] = 7;
        nArray2[130] = 7;
        nArray2[131] = 7;
        nArray2[132] = 7;
        nArray2[133] = 7;
        nArray2[134] = 7;
        nArray2[135] = 7;
        nArray2[136] = 7;
        nArray2[137] = 7;
        nArray2[138] = 7;
        nArray2[139] = 7;
        nArray2[140] = 7;
        nArray2[141] = 7;
        nArray2[142] = 7;
        nArray2[143] = 7;
        nArray2[144] = 7;
        nArray2[145] = 7;
        nArray2[146] = 7;
        nArray2[147] = 7;
        nArray2[148] = 7;
        nArray2[149] = 7;
        nArray2[150] = 7;
        nArray2[151] = 7;
        nArray2[152] = 7;
        nArray2[153] = 7;
        nArray2[154] = 7;
        nArray2[155] = 7;
        nArray2[156] = 7;
        nArray2[157] = 7;
        nArray2[158] = 7;
        nArray2[159] = 7;
        nArray2[160] = 7;
        nArray2[161] = 7;
        nArray2[162] = 7;
        nArray2[163] = 7;
        nArray2[164] = 7;
        nArray2[165] = 7;
        nArray2[166] = 7;
        nArray2[167] = 7;
        nArray2[168] = 7;
        nArray2[169] = 7;
        nArray2[170] = 7;
        nArray2[171] = 7;
        nArray2[172] = 7;
        nArray2[173] = 7;
        nArray2[174] = 7;
        nArray2[175] = 7;
        nArray2[176] = 7;
        nArray2[177] = 7;
        nArray2[178] = 7;
        nArray2[179] = 7;
        nArray2[180] = 7;
        nArray2[181] = 7;
        nArray2[182] = 7;
        nArray2[183] = 7;
        nArray2[184] = 7;
        nArray2[185] = 7;
        nArray2[186] = 7;
        nArray2[187] = 7;
        nArray2[188] = 7;
        nArray2[189] = 7;
        nArray2[190] = 7;
        nArray2[191] = 7;
        nArray2[192] = 7;
        nArray2[193] = 7;
        nArray2[194] = 7;
        nArray2[195] = 7;
        nArray2[196] = 7;
        nArray2[197] = 7;
        nArray2[198] = 7;
        nArray2[199] = 7;
        nArray2[200] = 7;
        nArray2[201] = 7;
        nArray2[202] = 7;
        nArray2[203] = 7;
        nArray2[204] = 7;
        nArray2[205] = 7;
        nArray2[206] = 7;
        nArray2[207] = 7;
        nArray2[208] = 7;
        nArray2[209] = 7;
        nArray2[210] = 7;
        nArray2[211] = 7;
        nArray2[212] = 7;
        nArray2[213] = 7;
        nArray2[214] = 7;
        nArray2[215] = 7;
        nArray2[216] = 7;
        nArray2[217] = 7;
        nArray2[218] = 7;
        nArray2[219] = 7;
        nArray2[220] = 7;
        nArray2[221] = 7;
        nArray2[222] = 7;
        nArray2[223] = 7;
        nArray2[224] = 7;
        nArray2[225] = 7;
        nArray2[226] = 7;
        nArray2[227] = 7;
        nArray2[228] = 7;
        nArray2[229] = 7;
        nArray2[230] = 7;
        nArray2[231] = 7;
        nArray2[232] = 7;
        nArray2[233] = 7;
        nArray2[234] = 7;
        nArray2[235] = 7;
        nArray2[236] = 7;
        nArray2[237] = 7;
        nArray2[238] = 7;
        nArray2[239] = 7;
        nArray2[240] = 7;
        nArray2[241] = 7;
        nArray2[242] = 7;
        nArray2[243] = 7;
        nArray2[244] = 7;
        nArray2[245] = 7;
        nArray2[246] = 7;
        nArray2[247] = 7;
        nArray2[248] = 7;
        nArray2[249] = 7;
        nArray2[250] = 7;
        nArray2[251] = 7;
        nArray2[252] = 7;
        nArray2[253] = 7;
        nArray2[254] = 7;
        nArray2[255] = 7;
        BYTEMSB = nArray2;
    }
}

