/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import com.martiansoftware.jsap.stringparsers.IntSizeStringParser;
import it.unimi.dsi.fastutil.bytes.ByteArrayFrontCodedList;
import it.unimi.dsi.fastutil.chars.CharArrayFrontCodedList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.LineIterator;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressMeter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FrontCodedStringList
extends AbstractObjectList
implements Serializable {
    public static final long serialVersionUID = -7046029254386353130L;
    protected ObjectList frontCodedList;
    protected transient ByteArrayFrontCodedList byteFrontCodedList;
    protected transient CharArrayFrontCodedList charFrontCodedList;
    protected boolean utf8;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$util$FrontCodedStringList;
    static /* synthetic */ Class class$java$nio$charset$Charset;

    public boolean utf8() {
        return this.utf8;
    }

    public int ratio() {
        return this.utf8 ? this.byteFrontCodedList.ratio() : this.charFrontCodedList.ratio();
    }

    public Object get(int index) {
        return MutableString.wrap(this.utf8 ? FrontCodedStringList.byte2Char(this.byteFrontCodedList.getArray(index), null) : this.charFrontCodedList.getArray(index));
    }

    public void get(int index, MutableString s) {
        if (this.utf8) {
            byte[] a = this.byteFrontCodedList.getArray(index);
            s.length(FrontCodedStringList.countUTF8Chars(a));
            FrontCodedStringList.byte2Char(a, s.array());
        } else {
            int res = this.charFrontCodedList.get(index, s.array);
            if (res < 0) {
                s.length(s.array.length - res);
                res = this.charFrontCodedList.get(index, s.array);
            } else {
                s.length(res);
            }
        }
    }

    private static final int countUTF8Chars(byte[] a) {
        int length = a.length;
        int result = 0;
        int i = 0;
        while (i < length) {
            int b = (a[i] & 0xFF) >> 4;
            if (b < 8) {
                ++result;
            } else if (b < 14) {
                ++result;
                ++i;
            } else {
                ++result;
                i += 2;
            }
            ++i;
        }
        return result;
    }

    private static final char[] byte2Char(byte[] a, char[] s) {
        int length = a.length;
        if (s == null) {
            s = new char[FrontCodedStringList.countUTF8Chars(a)];
        }
        int i = 0;
        int j = 0;
        while (i < length) {
            int c;
            int b = a[i] & 0xFF;
            if (b >> 4 < 8) {
                s[j++] = (char)b;
            } else if (b >> 4 < 14) {
                if (((c = a[++i] & 0xFF) & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s[j++] = (char)((b & 0x1F) << 6 | c & 0x3F);
            } else {
                c = a[++i] & 0xFF;
                byte d = a[++i];
                if ((c & 0xC0) != 128 || (d & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s[j++] = (char)((b & 0xF) << 12 | (c & 0x3F) << 6 | d & 0x3F);
            }
            ++i;
        }
        return s;
    }

    public ObjectListIterator objectListIterator(final int k) {
        return new AbstractObjectListIterator(){
            ObjectListIterator i;

            public final boolean hasNext() {
                return this.i.hasNext();
            }

            public final boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            public final Object next() {
                return MutableString.wrap(FrontCodedStringList.this.utf8 ? FrontCodedStringList.byte2Char((byte[])this.i.next(), null) : (char[])this.i.next());
            }

            public final Object previous() {
                return MutableString.wrap(FrontCodedStringList.this.utf8 ? FrontCodedStringList.byte2Char((byte[])this.i.next(), null) : (char[])this.i.previous());
            }

            public final int nextIndex() {
                return this.i.nextIndex();
            }

            public final int previousIndex() {
                return this.i.previousIndex();
            }

            private final /* synthetic */ void this() {
                this.i = FrontCodedStringList.this.frontCodedList.objectListIterator(k);
            }
            {
                this.this();
            }
        };
    }

    public int size() {
        return this.frontCodedList.size();
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.utf8) {
            this.byteFrontCodedList = (ByteArrayFrontCodedList)this.frontCodedList;
        } else {
            this.charFrontCodedList = (CharArrayFrontCodedList)this.frontCodedList;
        }
    }

    public static void main(String[] arg) throws FileNotFoundException, IOException, JSAPException, SecurityException, NoSuchMethodException {
        Class clazz = class$it$unimi$dsi$mg4j$util$FrontCodedStringList;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$util$FrontCodedStringList = FrontCodedStringList.class("[Lit.unimi.dsi.mg4j.util.FrontCodedStringList;", false);
        }
        String string = clazz.getName();
        Parameter[] parameterArray = new Parameter[5];
        parameterArray[0] = new FlaggedOption("bufferSize", (StringParser)IntSizeStringParser.getParser(), "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read terms.");
        Class clazz2 = class$java$nio$charset$Charset;
        if (clazz2 == null) {
            clazz2 = class$java$nio$charset$Charset = FrontCodedStringList.class("[Ljava.nio.charset.Charset;", false);
        }
        parameterArray[1] = new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser((Class)clazz2), "UTF-8", false, 'e', "encoding", "The term file encoding.");
        parameterArray[2] = new FlaggedOption("ratio", (StringParser)IntSizeStringParser.getParser(), "4", false, 'r', "ratio", "The compression ratio.");
        parameterArray[3] = new Switch("utf8", 'u', "utf8", "Store the strings as UTF-8 byte arrays.");
        parameterArray[4] = new UnflaggedOption("frontCodedList", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised front-coded list.");
        SimpleJSAP jsap = new SimpleJSAP(string, "Builds a front-coded string list reading from standard input a newline-separated ordered list of terms.", parameterArray);
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        int ratio = jsapResult.getInt("ratio");
        boolean utf8 = jsapResult.getBoolean("utf8");
        String listName = jsapResult.getString("frontCodedList");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        ProgressMeter pm = new ProgressMeter(100000, "words");
        pm.start("Reading words...");
        FrontCodedStringList frontCodedStringList = new FrontCodedStringList((Iterator)((Object)new LineIterator(new FastBufferedReader(new InputStreamReader(System.in, encoding), bufferSize), pm)), ratio, utf8);
        pm.done();
        System.err.print("Writing to file...");
        BinIO.storeObject((Object)frontCodedStringList, (CharSequence)listName);
        System.err.println(" done.");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public FrontCodedStringList(final Iterator words, int ratio, boolean utf8) {
        ByteArrayFrontCodedList byteArrayFrontCodedList;
        this.utf8 = utf8;
        if (utf8) {
            byteArrayFrontCodedList = this.byteFrontCodedList = new ByteArrayFrontCodedList((Iterator)new AbstractObjectIterator(){

                public final boolean hasNext() {
                    return words.hasNext();
                }

                public final Object next() {
                    try {
                        return ((CharSequence)words.next()).toString().getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException cantHappen) {
                        return null;
                    }
                }
            }, ratio);
        } else {
            this.charFrontCodedList = new CharArrayFrontCodedList((Iterator)new AbstractObjectIterator(){

                public final boolean hasNext() {
                    return words.hasNext();
                }

                public final Object next() {
                    CharSequence s = (CharSequence)words.next();
                    int i = s.length();
                    char[] a = new char[i];
                    while (i-- != 0) {
                        a[i] = s.charAt(i);
                    }
                    return a;
                }
            }, ratio);
            byteArrayFrontCodedList = this.charFrontCodedList;
        }
        this.frontCodedList = byteArrayFrontCodedList;
    }

    public FrontCodedStringList(Collection c, int ratio, boolean utf8) {
        this(c.iterator(), ratio, utf8);
    }
}

