/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import cern.colt.bitvector.BitVector;
import cern.colt.bitvector.QuickBitVector;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.Intervals;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ImmutableBinaryTrie
implements Serializable {
    private static final boolean ASSERTS = false;
    public static final long serialVersionUID = -7046029254386353130L;
    protected final Node root;
    private int size;
    private static final /* synthetic */ boolean assert;

    private final Node buildTrie(List words, int pos) {
        Node n;
        BitVector curr;
        if (words.size() == 0) {
            return null;
        }
        BitVector first = (BitVector)words.get(0);
        int prefix = first.size();
        int change = -1;
        if (words.size() == 1) {
            return new Node(pos < prefix ? first.partFromTo(pos, prefix - 1) : null, this.size++);
        }
        ListIterator i = words.listIterator(1);
        while (i.hasNext()) {
            curr = (BitVector)i.next();
            if (curr.size() < prefix) {
                prefix = curr.size();
            }
            int j = pos;
            while (j < prefix) {
                if (first.get(j) != curr.get(j)) break;
                ++j;
            }
            if (j >= prefix) continue;
            change = i.previousIndex();
            prefix = j;
        }
        if (prefix == first.size()) {
            change = 1;
            ListIterator i2 = words.listIterator(1);
            while (i2.hasNext()) {
                curr = (BitVector)i2.next();
                if (curr.get(prefix)) break;
                ++change;
            }
            n = new Node(prefix > pos ? first.partFromTo(pos, prefix - 1) : null, this.size++);
            n.left = this.buildTrie(words.subList(1, change), prefix + 1);
            n.right = this.buildTrie(words.subList(change, words.size()), prefix + 1);
        } else {
            n = new Node(prefix > pos ? first.partFromTo(pos, prefix - 1) : null);
            n.left = this.buildTrie(words.subList(0, change), prefix + 1);
            n.right = this.buildTrie(words.subList(change, words.size()), prefix + 1);
        }
        return n;
    }

    public int get(BitVector word) {
        int length = word.size();
        Node n = this.root;
        int pos = 0;
        while (n != null) {
            if (pos == length) {
                return n.word;
            }
            long[] path = n.path;
            if (path != null) {
                int minLength = Math.min(length - pos, n.pathLength);
                int i = 0;
                while (i < minLength) {
                    if (word.get(pos + i) != QuickBitVector.get((long[])path, (int)i)) break;
                    ++i;
                }
                if (i < minLength) {
                    return -1;
                }
                if ((pos += i) == length) {
                    return n.word;
                }
            }
            Node node = n = word.get(pos++) ? n.right : n.left;
        }
        return -1;
    }

    public int get(BooleanIterator iterator) {
        Node n = this.root;
        while (n != null) {
            if (!iterator.hasNext()) {
                return n.word;
            }
            int pathLength = n.pathLength;
            if (pathLength != 0) {
                long[] path = n.path;
                int i = 0;
                while (i < pathLength && iterator.hasNext()) {
                    if (iterator.nextBoolean() != QuickBitVector.get((long[])path, (int)i)) break;
                    ++i;
                }
                if (i < pathLength) {
                    return -1;
                }
                if (!iterator.hasNext()) {
                    return n.word;
                }
            }
            Node node = n = iterator.nextBoolean() ? n.right : n.left;
        }
        return -1;
    }

    public Interval getInterval(BitVector word) {
        int length = word.size();
        Node n = this.root;
        int pos = 0;
        while (n != null) {
            if (pos == length) break;
            long[] path = n.path;
            if (path != null) {
                int maxLength = Math.min(length - pos, n.pathLength);
                int i = 0;
                while (i < maxLength) {
                    if (word.get(pos + i) != QuickBitVector.get((long[])path, (int)i)) break;
                    ++i;
                }
                if (i < maxLength) {
                    return Intervals.EMPTY_INTERVAL;
                }
                if ((pos += i) == length) break;
            }
            Node node = n = word.get(pos++) ? n.right : n.left;
        }
        if (n == null) {
            return Intervals.EMPTY_INTERVAL;
        }
        Node l = n;
        while (l.word < 0) {
            Node node = l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            Node node = n = n.right != null ? n.right : n.left;
        }
        return Interval.getInstance(l.word, n.word);
    }

    public Interval getInterval(BooleanIterator iterator) {
        Node n = this.root;
        boolean mismatch = false;
        while (n != null) {
            if (!iterator.hasNext()) break;
            int pathLength = n.pathLength;
            if (pathLength != 0) {
                long[] path = n.path;
                int i = 0;
                while (i < pathLength && iterator.hasNext()) {
                    mismatch = iterator.nextBoolean() ^ QuickBitVector.get((long[])path, (int)i);
                    if (mismatch) break;
                    ++i;
                }
                if (mismatch) {
                    return Intervals.EMPTY_INTERVAL;
                }
                if (!iterator.hasNext()) break;
            }
            Node node = n = iterator.nextBoolean() ? n.right : n.left;
        }
        if (n == null) {
            return Intervals.EMPTY_INTERVAL;
        }
        Node l = n;
        while (l.word < 0) {
            Node node = l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            Node node = n = n.right != null ? n.right : n.left;
        }
        return Interval.getInstance(l.word, n.word);
    }

    /*
     * Unable to fully structure code
     */
    public Interval getApproximatedInterval(BitVector word) {
        length = word.size();
        n = this.root;
        exactMatch = false;
        pos = 0;
        while (n != null) {
            block14: {
                block15: {
                    path = n.path;
                    if (pos == length) {
                        if (n.word < 0 || path != null) break;
                        exactMatch = true;
                        break;
                    }
                    if (path == null) break block14;
                    maxLength = Math.min(length - pos, n.pathLength);
                    i = 0;
                    while (i < maxLength) {
                        if (word.get(pos + i) != QuickBitVector.get((long[])path, (int)i)) break;
                        ++i;
                    }
                    if (i >= maxLength) break block15;
                    if (!QuickBitVector.get((long[])path, (int)i)) ** GOTO lbl25
                    while (n.word < 0) {
                        v0 = n = n.left != null ? n.left : n.right;
                    }
                    return n.word > 0 ? Interval.getInstance(n.word - 1) : Intervals.EMPTY_INTERVAL;
lbl-1000:
                    // 1 sources

                    {
                        v1 = n = n.right != null ? n.right : n.left;
lbl25:
                        // 2 sources

                        ** while (!n.isLeaf())
                    }
lbl26:
                    // 1 sources

                    return Interval.getInstance(n.word);
                }
                if ((pos += i) == length) {
                    if (i != n.pathLength || n.word < 0) break;
                    exactMatch = true;
                    break;
                }
            }
            if (n.isLeaf()) break;
            if ((nextBit = word.get(pos++)) && n.right == null) {
                while (!n.isLeaf()) {
                    v2 = n = n.right != null ? n.right : n.left;
                }
                return Interval.getInstance(n.word);
            }
            if (!nextBit && n.left == null) {
                while (n.word < 0) {
                    v3 = n = n.left != null ? n.left : n.right;
                }
                return Interval.getInstance(n.word);
            }
            v4 = n = nextBit != false ? n.right : n.left;
        }
        l = n;
        while (l.word < 0) {
            v5 = l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            v6 = n = n.right != null ? n.right : n.left;
        }
        if (pos == length && !exactMatch) {
            if (l.word == 0) {
                return Intervals.EMPTY_INTERVAL;
            }
            return Interval.getInstance(l.word - 1, n.word);
        }
        return Interval.getInstance(l.word, n.word);
    }

    /*
     * Unable to fully structure code
     */
    public Interval getApproximatedInterval(BooleanIterator iterator) {
        n = this.root;
        exactMatch = false;
        mismatch = false;
        while (true) {
            block14: {
                block15: {
                    path = n.path;
                    if (!iterator.hasNext()) {
                        if (n.word < 0 || path != null) break;
                        exactMatch = true;
                        break;
                    }
                    if (path == null) break block14;
                    pathSize = n.pathLength;
                    i = 0;
                    while (i < pathSize && iterator.hasNext()) {
                        mismatch = iterator.nextBoolean() ^ QuickBitVector.get((long[])path, (int)i);
                        if (mismatch) break;
                        ++i;
                    }
                    if (!mismatch) break block15;
                    if (!QuickBitVector.get((long[])path, (int)i)) ** GOTO lbl25
                    while (n.word < 0) {
                        v0 = n = n.left != null ? n.left : n.right;
                    }
                    return n.word > 0 ? Interval.getInstance(n.word - 1) : Intervals.EMPTY_INTERVAL;
lbl-1000:
                    // 1 sources

                    {
                        v1 = n = n.right != null ? n.right : n.left;
lbl25:
                        // 2 sources

                        ** while (!n.isLeaf())
                    }
lbl26:
                    // 1 sources

                    return Interval.getInstance(n.word);
                }
                if (!iterator.hasNext()) {
                    if (i != pathSize || n.word < 0) break;
                    exactMatch = true;
                    break;
                }
            }
            if (n.isLeaf()) break;
            nextBit = iterator.nextBoolean();
            if (nextBit && n.right == null) {
                while (!n.isLeaf()) {
                    v2 = n = n.right != null ? n.right : n.left;
                }
                return Interval.getInstance(n.word);
            }
            if (!nextBit && n.left == null) {
                while (n.word < 0) {
                    v3 = n = n.left != null ? n.left : n.right;
                }
                return Interval.getInstance(n.word);
            }
            n = nextBit != false ? n.right : n.left;
        }
        l = n;
        while (l.word < 0) {
            v4 = l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            v5 = n = n.right != null ? n.right : n.left;
        }
        if (!iterator.hasNext() && !exactMatch) {
            if (l.word == 0) {
                return Intervals.EMPTY_INTERVAL;
            }
            return Interval.getInstance(l.word - 1, n.word);
        }
        return Interval.getInstance(l.word, n.word);
    }

    private final void recToString(Node n, MutableString printPrefix, MutableString result, MutableString path, int level) {
        if (n == null) {
            return;
        }
        result.append(printPrefix).append('(').append(level).append(')');
        if (path != null) {
            path.append(path);
            result.append(" path:").append(path);
        }
        if (n.word >= 0) {
            result.append(" word: ").append(n.word).append(" (").append(path).append(')');
        }
        result.append('\n');
        path.append('0');
        this.recToString(n.left, printPrefix.append('\t').append("0 => "), result, path, level + 1);
        path.charAt(path.length() - 1, '1');
        this.recToString(n.right, printPrefix.replace(printPrefix.length() - 5, printPrefix.length(), "1 => "), result, path, level + 1);
        path.delete(path.length() - 1, path.length());
        printPrefix.delete(printPrefix.length() - 6, printPrefix.length());
        path.delete(path.length() - n.pathLength, path.length());
    }

    public String toString() {
        MutableString s = new MutableString();
        this.recToString(this.root, new MutableString(), s, new MutableString(), 0);
        return s.toString();
    }

    public ImmutableBinaryTrie(List words) {
        int numWords = words.size();
        if (numWords > 1) {
            BitVector prev = (BitVector)words.get(0);
            ListIterator i = words.listIterator(1);
            while (--numWords != 0) {
                BitVector curr = (BitVector)i.next();
                int minLength = Math.min(prev.size(), curr.size());
                int j = 0;
                while (j < minLength) {
                    if (prev.get(j) && !curr.get(j)) {
                        throw new IllegalArgumentException("The provided bit vector list is not lexicographically increasing");
                    }
                    if (!prev.get(j) && curr.get(j)) break;
                    ++j;
                }
                prev = curr;
            }
        }
        this.root = this.buildTrie(words, 0);
    }

    static {
        assert = Class.forName("[Lit.unimi.dsi.mg4j.util.ImmutableBinaryTrie;").getComponentType().desiredAssertionStatus() ^ true;
    }

    protected static class Node
    implements Serializable {
        public Node left;
        public Node right;
        public final long[] path;
        public final int pathLength;
        public final int word;

        public boolean isLeaf() {
            boolean bl = false;
            if (this.right == null && this.left == null) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return "[" + this.path + ", " + this.word + ']';
        }

        public Node(BitVector path, int word) {
            if (path == null) {
                this.path = null;
                this.pathLength = 0;
            } else {
                this.path = path.elements();
                this.pathLength = path.size();
            }
            this.word = word;
        }

        public Node(BitVector path) {
            this(path, -1);
        }
    }
}

