/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import cern.colt.bitvector.BitVector;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.mg4j.compression.Decoder;
import it.unimi.dsi.mg4j.compression.PrefixCodec;
import it.unimi.dsi.mg4j.compression.PrefixCoder;
import it.unimi.dsi.mg4j.index.PrefixMap;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.FileLinesCollection;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.Intervals;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.CopyUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ImmutableExternalPrefixDictionary
extends AbstractObjectList
implements TermMap,
PrefixMap,
Serializable {
    public static final long serialVersionUID = -7046029254386353130L;
    public static final int STD_BLOCK_SIZE = 1024;
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    protected final IntervalApproximator intervalApproximator;
    protected final long blockSize;
    protected final Decoder decoder;
    protected final char[] symbol2char;
    protected final Char2IntOpenHashMap char2symbol;
    protected final int size;
    private final int[] blockStart;
    private final boolean selfContained;
    private final long dumpStreamLength;
    private transient String tempDumpStreamFilename;
    private transient boolean iteratorIsUsable;
    private transient InputBitStream dumpStream;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$util$ImmutableExternalPrefixDictionary;
    static /* synthetic */ Class class$java$nio$charset$Charset;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$util$ImmutableExternalTriePrefixDictionary;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$CharSequence;
    private static final /* synthetic */ boolean assert;

    protected abstract PrefixCodec getPrefixCodec(int[] var1);

    protected abstract IntervalApproximator getIntervalApproximator(List var1, PrefixCoder var2);

    private final void safelyCloseDumpStream() {
        try {
            if (this.dumpStream != null) {
                this.dumpStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void ensureNotSelfContained() {
        if (this.selfContained) {
            throw new IllegalStateException("You cannot set the dump file of a self-contained external prefix dictionary");
        }
    }

    private final boolean isEncodable(CharSequence s) {
        int i = s.length();
        while (i-- != 0) {
            if (this.char2symbol.containsKey(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void setDumpStream(CharSequence dumpStreamFilename) throws FileNotFoundException {
        this.ensureNotSelfContained();
        this.safelyCloseDumpStream();
        this.iteratorIsUsable = false;
        long newLength = new File(dumpStreamFilename.toString()).length();
        if (newLength != this.dumpStreamLength) {
            throw new IllegalArgumentException("The size of the new dump file (" + newLength + ") does not match the original length (" + this.dumpStreamLength + ')');
        }
        this.dumpStream = new InputBitStream(dumpStreamFilename.toString(), (int)(this.blockSize / 8L));
    }

    public void setDumpStream(InputBitStream dumpStream) {
        this.ensureNotSelfContained();
        this.safelyCloseDumpStream();
        this.iteratorIsUsable = false;
        this.dumpStream = dumpStream;
    }

    private final void ensureStream() {
        if (this.dumpStream == null) {
            throw new IllegalStateException("This external prefix dictionary has been deserialised, but no dump stream has been set");
        }
    }

    public Interval getInterval(CharSequence prefix) {
        this.ensureStream();
        if (!this.isEncodable(prefix)) {
            return Intervals.EMPTY_INTERVAL;
        }
        Interval interval = this.intervalApproximator.getApproximatedInterval(prefix);
        if (interval == Intervals.EMPTY_INTERVAL) {
            return interval;
        }
        try {
            int i;
            int suffixLength;
            this.dumpStream.position(this.blockSize * (long)interval.left);
            this.dumpStream.readBits(0L);
            this.iteratorIsUsable = false;
            MutableString s = new MutableString();
            int prefixLength = -1;
            int count = this.blockStart[interval.left];
            int blockEnd = this.blockStart[interval.left + 1];
            int start = -1;
            int end = -1;
            while (count < blockEnd) {
                prefixLength = prefixLength < 0 ? 0 : this.dumpStream.readUnary();
                suffixLength = this.dumpStream.readUnary();
                s.delete(prefixLength, s.length());
                s.length(prefixLength + suffixLength);
                i = 0;
                while (i < suffixLength) {
                    s.charAt(i + prefixLength, this.symbol2char[this.decoder.decode(this.dumpStream)]);
                    ++i;
                }
                if (s.startsWith(prefix)) {
                    start = count;
                    break;
                }
                ++count;
            }
            if (start < 0 && interval.length() == 1) {
                return Intervals.EMPTY_INTERVAL;
            }
            start = count;
            end = start + 1;
            if (!assert && this.dumpStream.readBits() > this.blockSize) {
                throw new AssertionError();
            }
            if (interval.length() > 1) {
                this.dumpStream.position(this.blockSize * (long)interval.right);
                this.dumpStream.readBits(0L);
                s.length(0);
                end = this.blockStart[interval.right];
                blockEnd = this.blockStart[interval.right + 1];
                prefixLength = -1;
            }
            while (end < blockEnd) {
                prefixLength = prefixLength < 0 ? 0 : this.dumpStream.readUnary();
                suffixLength = this.dumpStream.readUnary();
                s.delete(prefixLength, s.length());
                s.length(prefixLength + suffixLength);
                i = 0;
                while (i < suffixLength) {
                    s.charAt(i + prefixLength, this.symbol2char[this.decoder.decode(this.dumpStream)]);
                    ++i;
                }
                if (!s.startsWith(prefix)) break;
                ++end;
            }
            return Interval.getInstance(start, end - 1);
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    public MutableString getTerm(int index, MutableString s) {
        this.ensureStream();
        this.ensureRestrictedIndex(index);
        int block = Arrays.binarySearch(this.blockStart, index);
        if (block < 0) {
            block = -block - 2;
        }
        try {
            this.dumpStream.position(this.blockSize * (long)block);
            this.dumpStream.readBits(0L);
            this.iteratorIsUsable = false;
            int prefixLength = -1;
            int i = index - this.blockStart[block] + 1;
            while (i-- != 0) {
                prefixLength = prefixLength < 0 ? 0 : this.dumpStream.readUnary();
                int suffixLength = this.dumpStream.readUnary();
                s.delete(prefixLength, s.length());
                s.length(prefixLength + suffixLength);
                int j = 0;
                while (j < suffixLength) {
                    s.charAt(j + prefixLength, this.symbol2char[this.decoder.decode(this.dumpStream)]);
                    ++j;
                }
            }
            return s;
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    public CharSequence getTerm(int index) {
        return this.getTerm(index, new MutableString());
    }

    public int getIndex(CharSequence term) {
        this.ensureStream();
        if (!this.isEncodable(term)) {
            return -1;
        }
        Interval interval = this.intervalApproximator.getApproximatedInterval(term);
        if (interval == Intervals.EMPTY_INTERVAL) {
            return -1;
        }
        try {
            this.dumpStream.position(this.blockSize * (long)interval.left);
            this.dumpStream.readBits(0L);
            this.iteratorIsUsable = false;
            MutableString s = new MutableString();
            int prefixLength = -1;
            int count = this.blockStart[interval.left];
            int blockEnd = this.blockStart[interval.left + 1];
            while (count < blockEnd) {
                prefixLength = prefixLength < 0 ? 0 : this.dumpStream.readUnary();
                int suffixLength = this.dumpStream.readUnary();
                s.delete(prefixLength, s.length());
                s.length(prefixLength + suffixLength);
                int i = 0;
                while (i < suffixLength) {
                    s.charAt(i + prefixLength, this.symbol2char[this.decoder.decode(this.dumpStream)]);
                    ++i;
                }
                if (s.equals(term)) {
                    return count;
                }
                ++count;
            }
            return -1;
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    public int indexOf(Object o) {
        return this.getIndex((CharSequence)o);
    }

    public int lastIndexOf(Object o) {
        return this.getIndex((CharSequence)o);
    }

    public Object get(int index) {
        return this.getTerm(index);
    }

    public boolean contains(CharSequence term) {
        boolean bl = false;
        if (this.getIndex(term) != -1) {
            bl = true;
        }
        return bl;
    }

    public ObjectIterator objectIterator() {
        return new DumpStreamIterator();
    }

    public int size() {
        return this.size;
    }

    public CharSequence getPrefix(Interval interval) {
        MutableString s = new MutableString();
        return this.getPrefix(interval, s);
    }

    public MutableString getPrefix(Interval interval, MutableString prefix) {
        if (interval == Intervals.EMPTY_INTERVAL || interval.left < 0 || interval.right < 0) {
            throw new IllegalArgumentException();
        }
        this.getTerm(interval.left, prefix);
        if (interval.length() == 1) {
            return prefix;
        }
        MutableString s = (MutableString)this.getTerm(interval.right);
        int l = Math.min(prefix.length(), s.length());
        int i = 0;
        while (i < l) {
            if (s.charAt(i) != prefix.charAt(i)) break;
            ++i;
        }
        return prefix.length(i);
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.selfContained) {
            FileInputStream fis = new FileInputStream(this.tempDumpStreamFilename);
            CopyUtils.copy((InputStream)fis, (OutputStream)s);
            fis.close();
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.selfContained) {
            int len;
            File temp = File.createTempFile(this.getClass().getName(), ".dump");
            temp.deleteOnExit();
            this.tempDumpStreamFilename = temp.toString();
            FileOutputStream fos = new FileOutputStream(temp);
            byte[] b = new byte[65536];
            while ((len = s.read(b)) >= 0) {
                fos.write(b, 0, len);
            }
            fos.close();
            this.dumpStream = new InputBitStream(temp, (int)(this.blockSize / 8L));
        }
    }

    public static void main(String[] arg) throws ClassNotFoundException, SecurityException, IOException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JSAPException {
        Collection<MutableString> termList;
        Class clazz = class$it$unimi$dsi$mg4j$util$ImmutableExternalPrefixDictionary;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$util$ImmutableExternalPrefixDictionary = ImmutableExternalPrefixDictionary.class("[Lit.unimi.dsi.mg4j.util.ImmutableExternalPrefixDictionary;", false);
        }
        String string = clazz.getName();
        Parameter[] parameterArray = new Parameter[7];
        parameterArray[0] = new FlaggedOption("blockSize", (StringParser)JSAP.INTSIZE_PARSER, "1Ki", false, 'b', "block-size", "The size of a block in the dump stream.");
        parameterArray[1] = new Switch("serialised", 's', "serialised", "The data source (file or standard input) provides a serialised java.util.List of terms.");
        parameterArray[2] = new FlaggedOption("termFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'o', "offline", "Read terms from this file instead of standard input.");
        Class clazz2 = class$java$nio$charset$Charset;
        if (clazz2 == null) {
            clazz2 = class$java$nio$charset$Charset = ImmutableExternalPrefixDictionary.class("[Ljava.nio.charset.Charset;", false);
        }
        parameterArray[3] = new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser((Class)clazz2), "UTF-8", false, 'e', "encoding", "The term list encoding.");
        Class clazz3 = class$it$unimi$dsi$mg4j$util$ImmutableExternalTriePrefixDictionary;
        if (clazz3 == null) {
            clazz3 = class$it$unimi$dsi$mg4j$util$ImmutableExternalTriePrefixDictionary = ImmutableExternalPrefixDictionary.class("[Lit.unimi.dsi.mg4j.util.ImmutableExternalTriePrefixDictionary;", false);
        }
        parameterArray[4] = new FlaggedOption("class", (StringParser)JSAP.CLASS_PARSER, clazz3.getName(), false, 'c', "class", "The class used to build the dictionary.");
        parameterArray[5] = new UnflaggedOption("dictionary", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised dictionary.");
        parameterArray[6] = new UnflaggedOption("dump", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "An optional dump stream (the resulting dictionary will not be self-contained).");
        SimpleJSAP jsap = new SimpleJSAP(string, "Builds an external dictionary reading from standard input a newline-separated list of terms or a serialised term list. If the dump stream name is not specified, the dictionary will be self-contained.", parameterArray);
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String termFile = jsapResult.getString("termFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        if (jsapResult.getBoolean("serialised")) {
            termList = (List)(termFile != null ? BinIO.loadObject((CharSequence)termFile) : BinIO.loadObject((InputStream)System.in));
        } else if (termFile != null) {
            termList = new FileLinesCollection(termFile, encoding.name());
        } else {
            termList = new ObjectArrayList();
            FastBufferedReader terms = new FastBufferedReader(new InputStreamReader(System.in, encoding.name()));
            MutableString term = new MutableString();
            while (terms.readLine(term) != null) {
                termList.add(term.copy());
            }
            terms.close();
        }
        Class clazz4 = jsapResult.getClass("class");
        Class[] classArray = new Class[3];
        Class clazz5 = class$java$util$Collection;
        if (clazz5 == null) {
            clazz5 = class$java$util$Collection = ImmutableExternalPrefixDictionary.class("[Ljava.util.Collection;", false);
        }
        classArray[0] = clazz5;
        classArray[1] = Integer.TYPE;
        Class clazz6 = class$java$lang$CharSequence;
        if (clazz6 == null) {
            clazz6 = class$java$lang$CharSequence = ImmutableExternalPrefixDictionary.class("[Ljava.lang.CharSequence;", false);
        }
        classArray[2] = clazz6;
        BinIO.storeObject(clazz4.getConstructor(classArray).newInstance(termList, new Integer(jsapResult.getInt("blockSize")), jsapResult.getString("dump")), (CharSequence)jsapResult.getString("dictionary"));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public ImmutableExternalPrefixDictionary(Collection terms, int blockSizeInBytes, CharSequence dumpStreamFilename) throws IOException {
        OutputBitStream output;
        CharSequence s;
        this.blockSize = blockSizeInBytes * 8;
        boolean bl = false;
        if (dumpStreamFilename == null) {
            bl = true;
        }
        this.selfContained = bl;
        int[] frequency = new int[65536];
        int maxWordLength = 0;
        int count = 0;
        MutableString prevTerm = new MutableString();
        Iterator i = terms.iterator();
        while (i.hasNext()) {
            s = (CharSequence)i.next();
            maxWordLength = Math.max(s.length(), maxWordLength);
            int j = s.length();
            while (j-- != 0) {
                char c = s.charAt(j);
                frequency[c] = frequency[c] + 1;
            }
            if (prevTerm.compareTo(s) >= 0) {
                throw new IllegalArgumentException("The provided term collection is not sorted, or contains duplicates");
            }
            ++count;
            prevTerm.replace(s);
        }
        this.size = count;
        count = 0;
        int i2 = frequency.length;
        while (i2-- != 0) {
            if (frequency[i2] == 0) continue;
            ++count;
        }
        int[] packedFrequency = new int[count];
        this.symbol2char = new char[count];
        this.char2symbol = new Char2IntOpenHashMap(count);
        this.char2symbol.defaultReturnValue(-1);
        int i3 = frequency.length;
        int k = count;
        while (i3-- != 0) {
            if (frequency[i3] == 0) continue;
            packedFrequency[--k] = frequency[i3];
            this.symbol2char[k] = (char)i3;
            this.char2symbol.put((char)i3, k);
        }
        PrefixCodec codec = this.getPrefixCodec(packedFrequency);
        PrefixCoder prefixCoder = (PrefixCoder)codec.getCoder();
        this.decoder = codec.getDecoder();
        frequency = null;
        packedFrequency = null;
        if (this.selfContained) {
            File temp = File.createTempFile(this.getClass().getName(), ".dump");
            temp.deleteOnExit();
            this.tempDumpStreamFilename = temp.toString();
            output = new OutputBitStream(temp, blockSizeInBytes);
        } else {
            this.tempDumpStreamFilename = dumpStreamFilename.toString();
            output = new OutputBitStream(this.tempDumpStreamFilename, blockSizeInBytes);
        }
        int prevTermLength = 0;
        int prefixLength = 0;
        int termCount = 0;
        int currBuffer = 0;
        IntArrayList blockStarts = new IntArrayList();
        ObjectArrayList delimiters = new ObjectArrayList();
        BitVector[] codeWord = prefixCoder.codeWords();
        prevTerm.length(0);
        Iterator i4 = terms.iterator();
        while (i4.hasNext()) {
            s = (CharSequence)i4.next();
            int length = s.length();
            boolean isDelimiter = false;
            int bits = 0;
            prefixLength = 0;
            while (prefixLength < length && prefixLength < prevTermLength && prevTerm.charAt(prefixLength) == s.charAt(prefixLength)) {
                ++prefixLength;
            }
            int j = prefixLength;
            while (j < length) {
                bits += codeWord[this.char2symbol.get(s.charAt(j))].size();
                ++j;
            }
            if ((long)(bits + length + 1) > this.blockSize) {
                throw new IllegalArgumentException("The string \"" + s + "\" is too long to be encoded with block size " + blockSizeInBytes);
            }
            if (output.writtenBits() / this.blockSize != (output.writtenBits() + (long)(length - prefixLength + 1) + (long)(prefixLength + 1) + (long)bits - 1L) / this.blockSize) {
                j = (int)(this.blockSize - output.writtenBits() % this.blockSize);
                while (j-- != 0) {
                    output.writeBit(0);
                }
            }
            if (output.writtenBits() % this.blockSize == 0L) {
                isDelimiter = true;
                prefixLength = 0;
            }
            if (!isDelimiter) {
                output.writeUnary(prefixLength);
            }
            output.writeUnary(length - prefixLength);
            j = prefixLength;
            while (j < length) {
                BitVector c = codeWord[this.char2symbol.get(s.charAt(j))];
                int k2 = 0;
                while (k2 < c.size()) {
                    output.writeBit(c.get(k2));
                    ++k2;
                }
                ++j;
            }
            if (isDelimiter) {
                blockStarts.add(termCount);
                delimiters.add((Object)new MutableString(s));
            }
            currBuffer = 1 - currBuffer;
            prevTerm.replace(s);
            prevTermLength = length;
            ++termCount;
        }
        output.align();
        this.dumpStreamLength = output.writtenBits() / 8L;
        output.close();
        this.intervalApproximator = this.getIntervalApproximator((List)delimiters, prefixCoder);
        blockStarts.add(this.size);
        this.blockStart = blockStarts.toIntArray();
        this.dumpStream = new InputBitStream(this.tempDumpStreamFilename, blockSizeInBytes);
    }

    public ImmutableExternalPrefixDictionary(Collection terms, CharSequence dumpStreamFilename) throws IOException {
        this(terms, 1024, dumpStreamFilename);
    }

    public ImmutableExternalPrefixDictionary(Collection terms, int blockSizeInBytes) throws IOException {
        this(terms, blockSizeInBytes, null);
    }

    public ImmutableExternalPrefixDictionary(Collection terms) throws IOException {
        this(terms, null);
    }

    static {
        assert = Class.forName("[Lit.unimi.dsi.mg4j.util.ImmutableExternalPrefixDictionary;").getComponentType().desiredAssertionStatus() ^ true;
    }

    public static interface IntervalApproximator {
        public Interval getApproximatedInterval(CharSequence var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class DumpStreamIterator
    extends AbstractObjectIterator {
        private int currBlock;
        private int index;
        final MutableString s;

        public final boolean hasNext() {
            if (!ImmutableExternalPrefixDictionary.this.iteratorIsUsable) {
                throw new IllegalStateException("Get methods of this dictionary have caused a stream repositioning");
            }
            boolean bl = false;
            if (this.index < ImmutableExternalPrefixDictionary.this.size) {
                bl = true;
            }
            return bl;
        }

        public final Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                int prefixLength;
                if (this.index == ImmutableExternalPrefixDictionary.this.blockStart[this.currBlock + 1]) {
                    if (ImmutableExternalPrefixDictionary.this.dumpStream.readBits() % ImmutableExternalPrefixDictionary.this.blockSize != 0L) {
                        ImmutableExternalPrefixDictionary.this.dumpStream.skip(ImmutableExternalPrefixDictionary.this.blockSize - ImmutableExternalPrefixDictionary.this.dumpStream.readBits() % ImmutableExternalPrefixDictionary.this.blockSize);
                    }
                    ++this.currBlock;
                    prefixLength = 0;
                } else {
                    prefixLength = ImmutableExternalPrefixDictionary.this.dumpStream.readUnary();
                }
                int suffixLength = ImmutableExternalPrefixDictionary.this.dumpStream.readUnary();
                this.s.delete(prefixLength, this.s.length());
                this.s.length(prefixLength + suffixLength);
                int i = 0;
                while (i < suffixLength) {
                    this.s.charAt(i + prefixLength, ImmutableExternalPrefixDictionary.this.symbol2char[ImmutableExternalPrefixDictionary.this.decoder.decode(ImmutableExternalPrefixDictionary.this.dumpStream)]);
                    ++i;
                }
                ++this.index;
                return this.s;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private final /* synthetic */ void this() {
            this.currBlock = -1;
            this.s = new MutableString();
        }

        private DumpStreamIterator() {
            this.this();
            try {
                ImmutableExternalPrefixDictionary.this.dumpStream.position(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ImmutableExternalPrefixDictionary.this.dumpStream.readBits(0L);
            ImmutableExternalPrefixDictionary.this.iteratorIsUsable = true;
        }
    }
}

