/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import it.unimi.dsi.mg4j.util.Fast;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ProgressLogger {
    public static final long ONE_SECOND = 1000L;
    public static final long TEN_SECONDS = 10000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long TEN_MINUTES = 600000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long DEFAULT_LOG_INTERVAL = 10000L;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    public final Logger logger;
    public Level priority;
    public long logInterval;
    public Object info;
    public long count;
    public long expectedUpdates;
    public String itemsName;
    public boolean displayFreeMemory;
    private long start;
    private long stop;
    private long lastLog;

    public final void update() {
        ++this.count;
        if (System.currentTimeMillis() - this.lastLog >= this.logInterval) {
            this.updateInternal();
        }
    }

    private final void updateInternal() {
        long currentTime = System.currentTimeMillis();
        long millisToEnd = Math.round((double)(this.expectedUpdates - this.count) * ((double)(currentTime - this.start) / ((double)this.count + 1.0)));
        if (this.logger.isEnabledFor((Priority)this.priority)) {
            this.logger.log((Priority)this.priority, (Object)(Fast.format(this.count) + ' ' + this.itemsName + ", " + this.millis2hms(this.millis()) + ", " + Fast.format((double)this.count * 1000.0 / (double)(currentTime - this.start)) + ' ' + this.itemsName + "/s" + (this.expectedUpdates > 0L ? "; " + Fast.format(100L * this.count / this.expectedUpdates) + "% done, " + this.millis2hms(millisToEnd) + " to end" : "") + (this.displayFreeMemory ? "; free mem: " + Fast.format(RUNTIME.freeMemory()) + '/' + Fast.format(RUNTIME.totalMemory()) : "") + (this.info != null ? "; " + this.info : "")));
        }
        this.lastLog = currentTime;
    }

    public final void start(CharSequence message) {
        if (message != null) {
            this.logger.log((Priority)this.priority, (Object)message);
        }
        this.start = this.lastLog = System.currentTimeMillis();
        this.count = 0L;
        this.stop = -1;
    }

    public final void start() {
        this.start(null);
    }

    public final void stop(CharSequence message) {
        if (this.stop != (long)-1) {
            return;
        }
        if (message != null) {
            this.logger.log((Priority)this.priority, (Object)message);
        }
        this.stop = System.currentTimeMillis();
        this.expectedUpdates = -1;
    }

    public final void stop() {
        this.stop(null);
    }

    public final void done() {
        this.stop("Completed.");
        this.logger.log((Priority)this.priority, (Object)this);
    }

    public final long millis() {
        if (this.stop != (long)-1) {
            return this.stop - this.start;
        }
        return System.currentTimeMillis() - this.start;
    }

    private final String millis2hms(long t) {
        if (t < 1000L) {
            return t + "ms";
        }
        long s = t / 1000L % 60L;
        long m = t / 1000L / 60L % 60L;
        long h = t / 3600000L;
        if (h == 0L && m == 0L) {
            return "" + s + 's';
        }
        if (h == 0L) {
            return m + "m " + s + 's';
        }
        return h + "h " + m + "m " + s + 's';
    }

    public final String toString() {
        long t = this.stop - this.start + 1L;
        if (t <= 0L) {
            return "Illegal progress logger state";
        }
        return "Elapsed: " + this.millis2hms(t) + (this.count != 0L ? " [" + Fast.format(this.count) + ' ' + this.itemsName + ", " + Fast.format((double)this.count / ((double)t / 1000.0)) + ' ' + this.itemsName + "/s]" : "");
    }

    private final /* synthetic */ void this() {
        this.priority = Level.INFO;
    }

    public ProgressLogger() {
        this(Logger.getRootLogger());
    }

    public ProgressLogger(Logger logger) {
        this(logger, 10000L);
    }

    public ProgressLogger(Logger logger, String itemsName) {
        this(logger, 10000L, itemsName);
    }

    public ProgressLogger(Logger logger, long logInterval) {
        this(logger, logInterval, "items");
    }

    public ProgressLogger(Logger logger, long logInterval, String itemsName) {
        this.this();
        this.logger = logger;
        this.logInterval = logInterval;
        this.itemsName = itemsName;
        this.expectedUpdates = -1;
    }
}

