/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.mg4j.index.PrefixMap;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.Intervals;
import it.unimi.dsi.mg4j.util.ImmutableExternalPrefixDictionary;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressMeter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TernaryIntervalSearchTree
extends AbstractObjectList
implements PrefixMap,
TermMap,
ImmutableExternalPrefixDictionary.IntervalApproximator,
Serializable {
    private static final String THIS_CLASS_NAME;
    private Node root;
    private int size;
    private boolean modified;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$util$TernaryIntervalSearchTree;
    static /* synthetic */ Class class$java$nio$charset$Charset;

    public Interval getInterval(CharSequence s) {
        int l = s.length();
        Node e = this.root;
        int offset = 0;
        int wordsAtLeft = 0;
        while (e != null) {
            char[] path = e.path;
            int i = 0;
            while (i < path.length - 1 && offset + i < l && s.charAt(offset + i) == path[i]) {
                ++i;
            }
            if (offset + i == l) {
                return Interval.getInstance(wordsAtLeft, wordsAtLeft + e.numNodes - 1);
            }
            if (i < path.length - 1) {
                return Intervals.EMPTY_INTERVAL;
            }
            char c = s.charAt(offset += i);
            if (c < path[i]) {
                e = e.left;
                continue;
            }
            if (c > path[i]) {
                if (e.left != null) {
                    wordsAtLeft += e.left.numNodes;
                }
                if (e.middle != null) {
                    wordsAtLeft += e.middle.numNodes;
                }
                if (e.isWord) {
                    ++wordsAtLeft;
                }
                e = e.right;
                continue;
            }
            ++offset;
            if (e.left != null) {
                wordsAtLeft += e.left.numNodes;
            }
            if (offset == l) {
                int n = wordsAtLeft + e.isWord;
                int n2 = 0;
                if (e.middle != null) {
                    n2 = e.middle.numNodes;
                }
                return Interval.getInstance(wordsAtLeft, n + n2 - 1);
            }
            if (e.isWord) {
                ++wordsAtLeft;
            }
            e = e.middle;
        }
        return Intervals.EMPTY_INTERVAL;
    }

    public Interval getApproximatedInterval(CharSequence s) {
        int l = s.length();
        Node e = this.root;
        int offset = 0;
        int wordsAtLeft = 0;
        while (e != null) {
            char[] path = e.path;
            int i = 0;
            while (i < path.length - 1 && offset + i < l && s.charAt(offset + i) == path[i]) {
                ++i;
            }
            if (offset + i == l) {
                return wordsAtLeft > 0 ? Interval.getInstance(wordsAtLeft - 1, wordsAtLeft + e.numNodes - 1) : Interval.getInstance(wordsAtLeft, wordsAtLeft + e.numNodes - 1);
            }
            if (i < path.length - 1) {
                if (s.charAt(offset + i) < path[i]) {
                    return wordsAtLeft > 0 ? Interval.getInstance(wordsAtLeft - 1) : Intervals.EMPTY_INTERVAL;
                }
                return Interval.getInstance(wordsAtLeft + e.numNodes - 1);
            }
            char c = s.charAt(offset += i);
            if (c < path[i]) {
                e = e.left;
                continue;
            }
            if (c > path[i]) {
                if (e.left != null) {
                    wordsAtLeft += e.left.numNodes;
                }
                if (e.middle != null) {
                    wordsAtLeft += e.middle.numNodes;
                }
                if (e.isWord) {
                    ++wordsAtLeft;
                }
                e = e.right;
                continue;
            }
            ++offset;
            if (e.left != null) {
                wordsAtLeft += e.left.numNodes;
            }
            if (offset == l) {
                int n = wordsAtLeft - (1 - e.isWord);
                int n2 = wordsAtLeft + e.isWord;
                int n3 = 0;
                if (e.middle != null) {
                    n3 = e.middle.numNodes;
                }
                return Interval.getInstance(n, n2 + n3 - 1);
            }
            if (e.isWord) {
                ++wordsAtLeft;
            }
            e = e.middle;
        }
        return wordsAtLeft > 0 ? Interval.getInstance(wordsAtLeft - 1) : Intervals.EMPTY_INTERVAL;
    }

    public boolean contains(CharSequence s) {
        boolean bl = false;
        if (this.getIndex(s) != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(Object o) {
        return this.contains((CharSequence)o);
    }

    public CharSequence getTerm(int index) {
        MutableString s = new MutableString();
        return this.getTerm(index, s);
    }

    public MutableString getTerm(int index, MutableString s) {
        this.ensureIndex(index);
        s.length(0);
        Node e = this.root;
        while (true) {
            if (e.left != null) {
                if (index < e.left.numNodes) {
                    s.append(e.path, 0, e.path.length - 1);
                    e = e.left;
                    continue;
                }
                index -= e.left.numNodes;
            }
            if (e.isWord) {
                if (index == 0) {
                    return s.append(e.path).compact();
                }
                --index;
            }
            if (e.middle != null) {
                if (index < e.middle.numNodes) {
                    s.append(e.path);
                    e = e.middle;
                    continue;
                }
                index -= e.middle.numNodes;
            }
            s.append(e.path, 0, e.path.length - 1);
            e = e.right;
        }
    }

    public Object get(int index) {
        return this.getTerm(index);
    }

    public int getIndex(CharSequence s) {
        int l = s.length();
        Node e = this.root;
        int offset = 0;
        int wordsAtLeft = 0;
        while (e != null) {
            char[] path = e.path;
            int i = 0;
            while (i < path.length - 1) {
                if (offset + i == l || s.charAt(offset + i) != path[i]) {
                    return -1;
                }
                ++i;
            }
            if ((offset += i) == l) {
                return -1;
            }
            char c = s.charAt(offset);
            if (c < e.path[i]) {
                e = e.left;
                continue;
            }
            if (c > e.path[i]) {
                if (e.left != null) {
                    wordsAtLeft += e.left.numNodes;
                }
                if (e.middle != null) {
                    wordsAtLeft += e.middle.numNodes;
                }
                if (e.isWord) {
                    ++wordsAtLeft;
                }
                e = e.right;
                continue;
            }
            ++offset;
            if (e.left != null) {
                wordsAtLeft += e.left.numNodes;
            }
            if (offset == l) {
                return e.isWord ? wordsAtLeft : -1;
            }
            if (e.isWord) {
                ++wordsAtLeft;
            }
            e = e.middle;
        }
        return -1;
    }

    public boolean add(CharSequence s) {
        this.modified = false;
        this.root = this.addRec(s, 0, s.length(), this.root);
        return this.modified;
    }

    public boolean add(Object o) {
        return this.add((CharSequence)o);
    }

    public CharSequence getPrefix(Interval interval) {
        MutableString s = new MutableString();
        return this.getPrefix(interval, s);
    }

    public MutableString getPrefix(Interval interval, MutableString prefix) {
        if (interval == Intervals.EMPTY_INTERVAL || interval.left < 0 || interval.right < 0) {
            throw new IllegalArgumentException();
        }
        this.getTerm(interval.left, prefix);
        if (interval.length() == 1) {
            return prefix;
        }
        MutableString s = (MutableString)this.getTerm(interval.right);
        int l = Math.min(prefix.length(), s.length());
        int i = 0;
        while (i < l) {
            if (s.charAt(i) != prefix.charAt(i)) break;
            ++i;
        }
        return prefix.length(i);
    }

    private final Node addRec(CharSequence s, int offset, int length, Node e) {
        char c;
        if (e == null) {
            this.modified = true;
            ++this.size;
            return new Node(s, offset, length, true, 1);
        }
        Node n = null;
        char[] path = e.path;
        int i = 0;
        while (i < path.length - 1) {
            c = s.charAt(offset + i);
            if (c < path[i]) {
                n = new Node(path, 0, i + 1, false, e.numNodes + 1);
                n.middle = e;
                e.removePathPrefix(i + 1);
                n.left = this.addRec(s, offset + i, length - i, null);
                break;
            }
            if (c > path[i]) {
                n = new Node(path, 0, i + 1, false, e.numNodes + 1);
                n.middle = e;
                e.removePathPrefix(i + 1);
                n.right = this.addRec(s, offset + i, length - i, null);
                break;
            }
            if (i == length - 1) {
                n = new Node(s, offset, length, true, e.numNodes + 1);
                n.middle = e;
                e.removePathPrefix(length);
                ++this.size;
                this.modified = true;
                break;
            }
            ++i;
        }
        if (i < path.length - 1) {
            return n;
        }
        c = s.charAt(offset + i);
        if (c < path[i]) {
            e.left = this.addRec(s, offset + i, length - i, e.left);
            if (this.modified) {
                ++e.numNodes;
            }
        } else if (c > path[i]) {
            e.right = this.addRec(s, offset + i, length - i, e.right);
            if (this.modified) {
                ++e.numNodes;
            }
        } else if (i == length - 1) {
            this.modified = e.isWord ^ true;
            if (this.modified) {
                ++e.numNodes;
                ++this.size;
            }
            e.isWord = true;
        } else {
            e.middle = this.addRec(s, offset + i + 1, length - i - 1, e.middle);
            if (this.modified) {
                ++e.numNodes;
            }
        }
        return e;
    }

    public int size() {
        return this.size;
    }

    public static void main(String[] arg) throws IOException, JSAPException, SecurityException, NoSuchMethodException {
        Class clazz = class$it$unimi$dsi$mg4j$util$TernaryIntervalSearchTree;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$util$TernaryIntervalSearchTree = TernaryIntervalSearchTree.class("[Lit.unimi.dsi.mg4j.util.TernaryIntervalSearchTree;", false);
        }
        String string = clazz.getName();
        Parameter[] parameterArray = new Parameter[3];
        parameterArray[0] = new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read terms.");
        Class clazz2 = class$java$nio$charset$Charset;
        if (clazz2 == null) {
            clazz2 = class$java$nio$charset$Charset = TernaryIntervalSearchTree.class("[Ljava.nio.charset.Charset;", false);
        }
        parameterArray[1] = new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser((Class)clazz2), "UTF-8", false, 'e', "encoding", "The term file encoding.");
        parameterArray[2] = new UnflaggedOption("tree", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised tree.");
        SimpleJSAP jsap = new SimpleJSAP(string, "Builds a ternary interval search tree reading from standard input a newline-separated list of terms.", parameterArray);
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        TernaryIntervalSearchTree tree = new TernaryIntervalSearchTree();
        MutableString term = new MutableString();
        ProgressMeter pm = new ProgressMeter(100000, "terms");
        FastBufferedReader terms = new FastBufferedReader(new InputStreamReader(System.in, (Charset)jsapResult.getObject("encoding")), jsapResult.getInt("bufferSize"));
        pm.start("Reading terms...");
        while (terms.readLine(term) != null) {
            pm.update();
            tree.add(term);
        }
        pm.done();
        BinIO.storeObject((Object)tree, (CharSequence)jsapResult.getString("tree"));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public TernaryIntervalSearchTree() {
    }

    public TernaryIntervalSearchTree(Collection c) {
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            this.add(i.next());
        }
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$util$TernaryIntervalSearchTree;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$util$TernaryIntervalSearchTree = TernaryIntervalSearchTree.class("[Lit.unimi.dsi.mg4j.util.TernaryIntervalSearchTree;", false);
        }
        THIS_CLASS_NAME = clazz.getName();
    }

    private static final class Node
    implements Serializable {
        public Node left;
        public Node middle;
        public Node right;
        public char[] path;
        public boolean isWord;
        public int numNodes;

        public final void removePathPrefix(int length) {
            char[] a = new char[this.path.length - length];
            System.arraycopy(this.path, length, a, 0, a.length);
            this.path = a;
        }

        public Node(CharSequence s, int offset, int length, boolean isWord, int numNodes) {
            this.path = new char[length];
            MutableString.getChars(s, offset, offset + length, this.path, 0);
            this.isWord = isWord;
            this.numNodes = numNodes;
        }

        public Node(char[] a, int offset, int length, boolean isWord, int numNodes) {
            this.path = new char[length];
            System.arraycopy(a, offset, this.path, 0, length);
            this.isWord = isWord;
            this.numNodes = numNodes;
        }
    }
}

