/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util.parser;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.TextPattern;
import it.unimi.dsi.mg4j.util.parser.Attribute;
import it.unimi.dsi.mg4j.util.parser.Element;
import it.unimi.dsi.mg4j.util.parser.Entity;
import it.unimi.dsi.mg4j.util.parser.callback.Callback;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BulletParser {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private static final int STATE_TEXT = 0;
    private static final int STATE_BEFORE_START_TAG_NAME = 1;
    private static final int STATE_BEFORE_END_TAG_NAME = 2;
    private static final int STATE_IN_START_TAG = 3;
    private static final int STATE_IN_END_TAG = 4;
    private static final int MAX_ENTITY_VALUE = 65535;
    private static final int HEXADECIMAL = 16;
    private static final int MAX_HEX_ENTITY_LENGTH = 8;
    private static final int MAX_DEC_ENTITY_LENGTH = 9;
    private static final TextPattern SCRIPT_CLOSE_TAG_PATTERN = new TextPattern("</script>", 1);
    private static final TextPattern STYLE_CLOSE_TAG_PATTERN = new TextPattern("</style>", 1);
    private static final char[] NONSPACE_WHITESPACE = new char[]{'\n', '\r', '\t'};
    private static final char[] SPACE = new char[]{' ', ' ', ' '};
    private static final TextPattern CLOSED_COMMENT = new TextPattern("->");
    private static final TextPattern CLOSED_PERCENT = new TextPattern("%>");
    private static final TextPattern CLOSED_PIC = new TextPattern("?>");
    private static final TextPattern CLOSED_SECTION = new TextPattern("]>");
    private static final TextPattern CLOSED_BOH = new TextPattern("!>");
    private Callback callback;
    private Reference2ObjectMap attrMap;
    private boolean parseText;
    private boolean parseCDATA;
    private boolean parseTags;
    private boolean parseAttributes;
    private ReferenceOpenHashSet parsedAttrs;
    public ReferenceSet parsedAttributes;
    private char lastEntity;

    public boolean parseText() {
        return this.parseText;
    }

    public BulletParser parseText(boolean parseText) {
        this.parseText = parseText;
        return this;
    }

    public boolean parseCDATA() {
        return this.parseCDATA;
    }

    public BulletParser parseCDATA(boolean parseCDATA) {
        this.parseCDATA = parseCDATA;
        return this;
    }

    public boolean parseTags() {
        return this.parseTags;
    }

    public BulletParser parseTags(boolean parseTags) {
        this.parseTags = parseTags;
        return this;
    }

    public boolean parseAttributes() {
        return this.parseAttributes;
    }

    public BulletParser parseAttributes(boolean parseAttributes) {
        this.parseAttributes = parseAttributes;
        return this;
    }

    public BulletParser parseAttribute(Attribute attribute) {
        this.parsedAttrs.add((Object)attribute);
        return this;
    }

    public BulletParser setCallback(Callback callback) {
        this.callback = callback;
        this.parseTags = false;
        this.parseAttributes = false;
        this.parseText = false;
        this.parseCDATA = false;
        this.parsedAttrs.clear();
        callback.configure(this);
        return this;
    }

    private final int scanEntity(char[] a, int offset, int length, boolean loose, MutableString entity) {
        int c = 0;
        if (length < 2) {
            return -1;
        }
        if (a[offset + 1] == '#') {
            int i;
            if (length > 2 && a[offset + 2] == 'x') {
                i = 3;
                while (i < length && i < 8 && Character.digit(a[i + offset], 16) != -1) {
                    ++i;
                }
                String tmpEntity = new String(a, offset + 3, i - 3);
                if (i != 3) {
                    c = Integer.parseInt(tmpEntity, 16);
                }
            } else {
                i = 2;
                while (i < length && i < 9 && Character.isDigit(a[i + offset])) {
                    ++i;
                }
                String tmpEntity = new String(a, offset + 2, i - 2);
                if (i != 2) {
                    c = Integer.parseInt(tmpEntity);
                }
            }
            if (c > 0 && c < (int)-1) {
                this.lastEntity = (char)c;
                if (i < length && a[i + offset] == ';') {
                    ++i;
                }
                return i + offset;
            }
        } else if (Character.isLetter(a[offset + 1])) {
            int i = 2;
            while (i < length && Character.isLetterOrDigit(a[offset + i])) {
                ++i;
            }
            if (i != 1 && (loose || Character.isWhitespace(a[offset + i]) || a[offset + i] == ';') && (this.lastEntity = Entity.entity2Char(entity.length(0).append(a, offset + 1, i - 1))) != '\u0000') {
                if (i < length && a[i + offset] == ';') {
                    ++i;
                }
                return i + offset;
            }
        }
        return -1;
    }

    private final void replaceEntities(MutableString s, MutableString entity, boolean loose) {
        int length;
        char[] a = s.array();
        int i = length = s.length();
        while (i-- > 0) {
            int j;
            if (a[i] != '&' || (j = this.scanEntity(a, i, length - i, loose, entity)) == -1) continue;
            length = s.replace(i, j, this.lastEntity).length();
        }
    }

    private final int handleMarkup(char[] text, int pos, int end) {
        switch (text[++pos]) {
            case 'D': 
            case 'd': {
                while (pos < end && text[pos++] != '>') {
                }
                break;
            }
            case '-': {
                pos = CLOSED_COMMENT.search(text, pos, end);
                if (pos == -1) {
                    pos = end;
                    break;
                }
                pos += CLOSED_COMMENT.length();
                break;
            }
            default: {
                while (pos < end && text[pos++] != '>') {
                }
                break;
            }
        }
        return pos;
    }

    private final int handleProcessingInstruction(char[] text, int pos, int end) {
        switch (text[++pos]) {
            case '%': {
                pos = CLOSED_PERCENT.search(text, pos, end);
                if (pos == -1) {
                    pos = end;
                    break;
                }
                pos += CLOSED_PERCENT.length();
                break;
            }
            case '?': {
                pos = CLOSED_PIC.search(text, pos, end);
                if (pos == -1) {
                    pos = end;
                    break;
                }
                pos += CLOSED_PIC.length();
                break;
            }
            case '[': {
                pos = CLOSED_SECTION.search(text, pos, end);
                if (pos == -1) {
                    pos = end;
                    break;
                }
                pos += CLOSED_SECTION.length();
                break;
            }
            default: {
                while (pos < end && text[pos++] != '>') {
                }
                break;
            }
        }
        return pos;
    }

    public void parse(char[] text, int offset, int length) {
        MutableString tagElemTypeName = new MutableString();
        MutableString attrName = new MutableString();
        MutableString attrValue = new MutableString();
        MutableString entity = new MutableString();
        MutableString characters = new MutableString();
        boolean flowBroken = false;
        Attribute currAttr = null;
        this.attrMap = new Reference2ObjectOpenHashMap();
        this.callback.startDocument();
        tagElemTypeName.length(0);
        attrName.length(0);
        attrValue.length(0);
        entity.length(0);
        int state = 0;
        Element currentElement = null;
        int end = offset + length;
        int pos = offset;
        block10: while (pos < end) {
            block0 : switch (state) {
                case 0: {
                    char currChar = text[pos];
                    if (currChar == '&') {
                        int k = this.scanEntity(text, pos, end - pos, true, entity);
                        if (k == -1) {
                            currChar = '&';
                            ++pos;
                        } else {
                            currChar = this.lastEntity;
                            pos = k;
                        }
                        if (!this.parseText) continue block10;
                        characters.append(currChar);
                        break;
                    }
                    if (currChar != '<' || pos >= end - 2) {
                        if (this.parseText) {
                            characters.append(currChar);
                        }
                        ++pos;
                        break;
                    }
                    switch (text[++pos]) {
                        case '!': {
                            pos = this.handleMarkup(text, pos, end);
                            break;
                        }
                        case '%': 
                        case '?': {
                            pos = this.handleProcessingInstruction(text, pos, end);
                            break;
                        }
                        default: {
                            if (Character.isLetter(text[pos])) {
                                state = 1;
                                break;
                            }
                            if (text[pos] == '/' && (Character.isLetter(text[pos + 1]) || text[pos + 1] == '>')) {
                                state = 2;
                                ++pos;
                                break;
                            }
                            if (!this.parseText) continue block10;
                            characters.append('<');
                            break block0;
                        }
                    }
                    if (this.parseText && characters.length() != 0) {
                        this.callback.characters(characters.array(), 0, characters.length(), flowBroken);
                        characters.length(0);
                    }
                    flowBroken = false;
                    break;
                }
                case 1: 
                case 2: {
                    tagElemTypeName.length(0);
                    int start = pos;
                    while (pos < end && (Character.isLetterOrDigit(text[pos]) || text[pos] == ':')) {
                        ++pos;
                    }
                    tagElemTypeName.append(text, start, pos - start);
                    tagElemTypeName.toLowerCase();
                    currentElement = Element.valueOf(tagElemTypeName);
                    if (currentElement != null && currentElement.breaksFlow) {
                        flowBroken = true;
                    }
                    while (pos < end && Character.isWhitespace(text[pos])) {
                        ++pos;
                    }
                    int n = 0;
                    if (state == 1) {
                        n = 1;
                    }
                    state = 4 - n;
                    break;
                }
                case 3: {
                    int start;
                    char currChar = text[pos];
                    if (currChar != '>' && (currChar != '/' || pos == end - 1 || text[pos + 1] != '>')) {
                        if (Character.isLetter(currChar)) {
                            char delim;
                            boolean parseCurrAttr = false;
                            attrName.length(0);
                            start = pos;
                            while (pos < end && (Character.isLetter(text[pos]) || text[pos] == '-')) {
                                ++pos;
                            }
                            if (currentElement != null && this.parseAttributes) {
                                attrName.append(text, start, pos - start);
                                attrName.toLowerCase();
                                currAttr = Attribute.valueOf(attrName);
                                parseCurrAttr = this.parsedAttrs.contains((Object)currAttr);
                            }
                            while (pos < end && Character.isWhitespace(text[pos])) {
                                ++pos;
                            }
                            if (pos == end) continue block10;
                            if (text[pos] != '=') {
                                if (!parseCurrAttr) continue block10;
                                this.attrMap.put((Object)currAttr, (Object)currAttr.name);
                                break;
                            }
                            ++pos;
                            while (pos < end && Character.isWhitespace(text[pos])) {
                                ++pos;
                            }
                            if (pos == end) continue block10;
                            attrValue.length(0);
                            if (pos < end && ((delim = text[pos]) == '\"' || (delim = text[pos]) == '\'')) {
                                start = ++pos;
                                while (pos < end && text[pos] != delim) {
                                    ++pos;
                                }
                                if (parseCurrAttr) {
                                    attrValue.append(text, start, pos - start).replace(NONSPACE_WHITESPACE, SPACE);
                                }
                                if (pos < end) {
                                    ++pos;
                                }
                            } else {
                                start = pos;
                                while (pos < end && !Character.isWhitespace(text[pos]) && text[pos] != '>') {
                                    ++pos;
                                }
                                if (parseCurrAttr) {
                                    attrValue.append(text, start, pos - start);
                                }
                            }
                            if (parseCurrAttr) {
                                this.replaceEntities(attrValue, entity, false);
                                this.attrMap.put((Object)currAttr, (Object)attrValue.copy());
                            }
                            while (pos < end && Character.isWhitespace(text[pos])) {
                                ++pos;
                            }
                            continue block10;
                        }
                        while (++pos < end && text[pos] != '>' && !Character.isWhitespace(text[pos])) {
                        }
                        while (pos < end && Character.isWhitespace(text[pos])) {
                            ++pos;
                        }
                        continue block10;
                    }
                    if (this.parseTags && !this.callback.startElement(currentElement, (Map)this.attrMap)) continue block10;
                    if (this.attrMap != null) {
                        this.attrMap.clear();
                    }
                    if (currentElement == Element.SCRIPT || currentElement == Element.STYLE) {
                        TextPattern pattern = currentElement == Element.SCRIPT ? SCRIPT_CLOSE_TAG_PATTERN : STYLE_CLOSE_TAG_PATTERN;
                        pos = pattern.search(text, start = pos + 1, end);
                        if (pos == -1) {
                            pos = end;
                        }
                        if (this.parseText) {
                            this.callback.cdata(currentElement, text, start, pos - start);
                        }
                        if (pos < end) {
                            if (this.parseTags) {
                                this.callback.endElement(currentElement);
                            }
                            pos += pattern.length();
                        }
                    } else {
                        int n = 0;
                        if (currChar == '/') {
                            n = 1;
                        }
                        pos += n + 1;
                    }
                    state = 0;
                    break;
                }
                case 4: {
                    while (pos < end && text[pos] != '>') {
                        ++pos;
                    }
                    if (this.parseTags && currentElement != null && !this.callback.endElement(currentElement)) continue block10;
                    state = 0;
                    ++pos;
                    break;
                }
            }
        }
        if (state == 3 && this.parseTags && currentElement != null) {
            this.callback.startElement(currentElement, (Map)this.attrMap);
        }
        if (state == 4 && this.parseTags && currentElement != null) {
            this.callback.endElement(currentElement);
        }
        if (state == 0 && this.parseText && characters.length() > 0) {
            this.callback.characters(characters.array(), 0, characters.length(), flowBroken);
        }
        this.callback.endDocument();
    }

    private final /* synthetic */ void this() {
        this.parsedAttrs = new ReferenceOpenHashSet(16, 0.5f);
        this.parsedAttributes = ReferenceSets.unmodifiable((ReferenceSet)this.parsedAttrs);
    }

    public BulletParser() {
        this.this();
    }
}

