/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util.parser.callback;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.TextPattern;
import it.unimi.dsi.mg4j.util.parser.Attribute;
import it.unimi.dsi.mg4j.util.parser.BulletParser;
import it.unimi.dsi.mg4j.util.parser.Element;
import it.unimi.dsi.mg4j.util.parser.callback.DefaultCallback;
import java.util.Map;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinkExtractor
extends DefaultCallback {
    private static final TextPattern URLEQUAL_PATTERN = new TextPattern("URL=", 1);
    public final Set urls;
    private String metaRefresh;
    private String metaLocation;
    private String base;

    public void configure(BulletParser parser) {
        parser.parseTags(true);
        parser.parseAttributes(true);
        parser.parseAttribute(Attribute.SRC);
        parser.parseAttribute(Attribute.HREF);
        parser.parseAttribute(Attribute.HTTP_EQUIV);
        parser.parseAttribute(Attribute.CONTENT);
    }

    public void startDocument() {
        this.urls.clear();
        this.metaRefresh = null;
        this.metaLocation = null;
        this.base = null;
    }

    public boolean startElement(Element element, Map attrMap) {
        Object s;
        if ((element == Element.A || element == Element.AREA || element == Element.LINK) && (s = attrMap.get(Attribute.HREF)) != null) {
            this.urls.add(s.toString());
        }
        if ((element == Element.IFRAME || element == Element.FRAME || element == Element.EMBED) && (s = attrMap.get(Attribute.SRC)) != null) {
            this.urls.add(s.toString());
        }
        if (element == Element.BASE && this.base == null && (s = attrMap.get(Attribute.HREF)) != null) {
            this.base = s.toString();
        }
        if (element == Element.META) {
            MutableString equiv = (MutableString)attrMap.get(Attribute.HTTP_EQUIV);
            MutableString content = (MutableString)attrMap.get(Attribute.CONTENT);
            if (equiv != null && content != null) {
                int pos;
                equiv.toLowerCase();
                if (equiv.equals("refresh") && this.metaRefresh == null && (pos = URLEQUAL_PATTERN.search(content)) != -1) {
                    this.metaRefresh = content.substring(pos + URLEQUAL_PATTERN.length()).toString();
                }
                if (equiv.equals("location") && this.metaLocation == null) {
                    this.metaLocation = attrMap.get(Attribute.CONTENT).toString();
                }
            }
        }
        return true;
    }

    public String metaLocation() {
        return this.metaLocation;
    }

    public String base() {
        return this.base;
    }

    public String metaRefresh() {
        return this.metaRefresh;
    }

    private final /* synthetic */ void this() {
        this.urls = new ObjectLinkedOpenHashSet();
        this.metaRefresh = null;
        this.metaLocation = null;
        this.base = null;
    }

    public LinkExtractor() {
        this.this();
    }
}

