/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.impl.jdbc.ClobAsciiStream;
import org.apache.derby.impl.jdbc.ClobUpdatableReader;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.StoreStreamClob;
import org.apache.derby.impl.jdbc.TemporaryClob;
import org.apache.derby.impl.jdbc.Util;

final class EmbedClob
extends ConnectionChild
implements Clob,
EngineLOB {
    private InternalClob clob;
    private boolean isValid = true;
    private int locator;

    EmbedClob(EmbedConnection embedConnection) throws SQLException {
        super(embedConnection);
        this.clob = new TemporaryClob(this);
        embedConnection.addLOBReference(this);
    }

    protected EmbedClob(EmbedConnection embedConnection, StringDataValue stringDataValue) throws StandardException {
        super(embedConnection);
        if (stringDataValue.hasStream()) {
            CharacterStreamDescriptor characterStreamDescriptor = stringDataValue.getStreamWithDescriptor();
            try {
                this.clob = new StoreStreamClob(characterStreamDescriptor, this);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("40XD0")) {
                    throw StandardException.newException("XJ073.S");
                }
                throw standardException;
            }
        }
        try {
            this.clob = new TemporaryClob(stringDataValue.getString(), this);
        }
        catch (SQLException sQLException) {
            throw StandardException.newException(sQLException.getSQLState(), sQLException);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XJ022.S", iOException);
        }
        embedConnection.addLOBReference(this);
    }

    public long length() throws SQLException {
        this.checkValidity();
        try {
            return this.clob.getCharLength();
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    public String getSubString(long l, int n) throws SQLException {
        String string;
        this.checkValidity();
        if (l < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        if (n < 0) {
            throw Util.generateCsSQLException("XJ071.S", new Integer(n));
        }
        try {
            int n2;
            int n3;
            Reader reader;
            try {
                reader = this.clob.getInternalReader(l);
            }
            catch (EOFException eOFException) {
                throw Util.generateCsSQLException("XJ076.S", (Object)new Long(l), eOFException);
            }
            char[] cArray = new char[n];
            for (n2 = 0; n2 < n && (n3 = reader.read(cArray, n2, n - n2)) != -1; n2 += n3) {
            }
            reader.close();
            string = n2 == 0 ? "" : String.copyValueOf(cArray, 0, n2);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        return string;
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkValidity();
        try {
            return new ClobUpdatableReader(this);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        return new ReaderToAscii(this.getCharacterStream());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position(String string, long l) throws SQLException {
        long l2;
        boolean bl;
        block22: {
            long l3;
            this.checkValidity();
            if (l < 1L) {
                throw Util.generateCsSQLException("XJ070.S", new Long(l));
            }
            if (string == null) {
                throw Util.generateCsSQLException("XJ072.S");
            }
            if ("".equals(string)) {
                return l;
            }
            bl = false;
            EmbedConnection embedConnection = this.getEmbedConnection();
            try {
                try {
                    Object object;
                    Object object2 = object = this.getConnectionSynchronization();
                    synchronized (object2) {
                        boolean bl2 = bl = !embedConnection.isClosed();
                        if (bl) {
                            this.setupContextStack();
                        }
                        int n = 0;
                        long l4 = l;
                        long l5 = -1L;
                        Reader reader = this.clob.getInternalReader(l);
                        char[] cArray = new char[4096];
                        while (true) {
                            boolean bl3 = false;
                            int n2 = reader.read(cArray);
                            if (n2 == -1) {
                                EmbedClob.restoreIntrFlagIfSeen(bl, embedConnection);
                                l3 = -1L;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 20, 5, 9] lbl28 : MonitorExitStatement: MONITOREXIT : var7_8
                                Object var22_18 = null;
                                if (!bl) return l3;
                                break;
                            }
                            for (int i = 0; i < n2; ++i) {
                                if (cArray[i] == string.charAt(n)) {
                                    if (n != 0 && l5 == -1L && cArray[i] == string.charAt(0)) {
                                        l5 = l4 + (long)i + 1L;
                                    }
                                    if (++n != string.length()) continue;
                                    EmbedClob.restoreIntrFlagIfSeen(bl, embedConnection);
                                    l2 = l4 + (long)i - (long)string.length() + 1L;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 19, 5, 9, 10] lbl40 : MonitorExitStatement: MONITOREXIT : var7_8
                                    break block22;
                                }
                                if (n <= 0) continue;
                                if (l5 == -1L) {
                                    if (n > 1) {
                                        --i;
                                    }
                                    n = 0;
                                    continue;
                                }
                                n = 0;
                                if (l5 < l4) {
                                    l4 = l5;
                                    reader.close();
                                    reader = this.clob.getInternalReader(l5);
                                    l5 = -1L;
                                    bl3 = true;
                                    break;
                                }
                                i = (int)(l5 - l4) - 1;
                                l5 = -1L;
                            }
                            if (bl3) continue;
                            l4 += (long)n2;
                        }
                    }
                }
                catch (EOFException eOFException) {
                    EmbedClob.restoreIntrFlagIfSeen(bl, embedConnection);
                    throw Util.generateCsSQLException("XJ076.S", eOFException);
                }
                catch (IOException iOException) {
                    EmbedClob.restoreIntrFlagIfSeen(bl, embedConnection);
                    throw Util.setStreamFailure(iOException);
                }
            }
            catch (Throwable throwable) {
                Object var22_20 = null;
                if (!bl) throw throwable;
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return l3;
        }
        Object var22_19 = null;
        if (!bl) return l2;
        this.restoreContextStack();
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position(Clob clob, long l) throws SQLException {
        long l2;
        boolean bl;
        block23: {
            long l3;
            block22: {
                long l4;
                block21: {
                    this.checkValidity();
                    if (l < 1L) {
                        throw Util.generateCsSQLException("XJ070.S", new Long(l));
                    }
                    if (clob == null) {
                        throw Util.generateCsSQLException("XJ072.S");
                    }
                    bl = false;
                    EmbedConnection embedConnection = this.getEmbedConnection();
                    try {
                        try {
                            Object object = this.getConnectionSynchronization();
                            synchronized (object) {
                                char[] cArray = new char[1024];
                                boolean bl2 = false;
                                block9: while (true) {
                                    long l5 = -1L;
                                    Reader reader = clob.getCharacterStream();
                                    while (true) {
                                        int n;
                                        if ((n = reader.read(cArray, 0, cArray.length)) == -1) {
                                            if (!bl2) {
                                                EmbedClob.restoreIntrFlagIfSeen(bl, embedConnection);
                                                l4 = l;
                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 19, 20, 6, 9, 10] lbl22 : MonitorExitStatement: MONITOREXIT : var6_5
                                                Object var20_16 = null;
                                                if (!bl) return l4;
                                                break block21;
                                            }
                                            EmbedClob.restoreIntrFlagIfSeen(bl, embedConnection);
                                            l3 = l5;
                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 20, 6, 9, 10] lbl29 : MonitorExitStatement: MONITOREXIT : var6_5
                                            break block22;
                                        }
                                        if (n == 0) continue;
                                        bl2 = true;
                                        String string = new String(cArray, 0, n);
                                        long l6 = this.position(string, l);
                                        if (l6 == -1L) {
                                            if (l5 == -1L) {
                                                EmbedClob.restoreIntrFlagIfSeen(bl, embedConnection);
                                                l2 = -1L;
                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 18, 6, 9, 10, 15] lbl40 : MonitorExitStatement: MONITOREXIT : var6_5
                                                break block23;
                                            } else {
                                                l = l5 + 1L;
                                                continue block9;
                                            }
                                        }
                                        if (l5 == -1L) {
                                            l5 = l6;
                                        } else if (l6 != l) {
                                            l = l5 + 1L;
                                            continue block9;
                                        }
                                        l = l6 + (long)n;
                                    }
                                    break;
                                }
                            }
                        }
                        catch (IOException iOException) {
                            EmbedClob.restoreIntrFlagIfSeen(bl, embedConnection);
                            throw Util.setStreamFailure(iOException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var20_19 = null;
                        if (!bl) throw throwable;
                        this.restoreContextStack();
                        throw throwable;
                    }
                }
                this.restoreContextStack();
                return l4;
            }
            Object var20_17 = null;
            if (!bl) return l3;
            this.restoreContextStack();
            return l3;
        }
        Object var20_18 = null;
        if (!bl) return l2;
        this.restoreContextStack();
        return l2;
    }

    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.checkValidity();
        if (l < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        if (l > this.length() + 1L) {
            throw Util.generateCsSQLException("XJ076.S");
        }
        if (string == null) {
            throw Util.generateCsSQLException("XJ072.S");
        }
        if (string.length() == 0) {
            return 0;
        }
        if (n < 0 || n >= string.length()) {
            throw Util.generateCsSQLException("XJ078.S");
        }
        if (n2 < 0) {
            throw Util.generateCsSQLException("XJ071.S");
        }
        if (n2 + n > string.length()) {
            throw Util.generateCsSQLException("22011.S.1", new Integer(n), new Integer(n2), string);
        }
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone();
            }
            this.clob.insertString(string.substring(n, n + n2), l);
        }
        catch (EOFException eOFException) {
            throw Util.generateCsSQLException("XJ076.S", new Long(l));
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        return string.length();
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        this.checkValidity();
        try {
            return new ClobAsciiStream(this.clob.getWriter(l));
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    public Writer setCharacterStream(long l) throws SQLException {
        this.checkValidity();
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone();
            }
            return this.clob.getWriter(l);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    public void truncate(long l) throws SQLException {
        this.checkValidity();
        if (l < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(l));
        }
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone(l);
            } else {
                this.clob.truncate(l);
            }
        }
        catch (EOFException eOFException) {
            throw Util.generateCsSQLException("XJ079.S", (Object)new Long(l), eOFException);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    public void free() throws SQLException {
        if (this.isValid) {
            this.isValid = false;
            try {
                try {
                    this.clob.release();
                }
                catch (IOException iOException) {
                    throw Util.setStreamFailure(iOException);
                }
                Object var3_1 = null;
                this.localConn.removeLOBMapping(this.locator);
                this.clob = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.localConn.removeLOBMapping(this.locator);
                this.clob = null;
                throw throwable;
            }
        }
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        this.checkValidity();
        if (l <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        if (l2 < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(l2));
        }
        if (l2 > this.length() - (l - 1L)) {
            throw Util.generateCsSQLException("XJ087.S", (Object)new Long(l), new Long(l2));
        }
        try {
            return new ClobUpdatableReader(this, l, l2);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    private void checkValidity() throws SQLException {
        this.localConn.checkIfClosed();
        if (!this.isValid) {
            throw this.newSQLException("XJ215.S");
        }
    }

    private void makeWritableClobClone() throws IOException, SQLException {
        InternalClob internalClob = this.clob;
        this.clob = TemporaryClob.cloneClobContent(this.getEmbedConnection().getDBName(), this, internalClob);
        internalClob.release();
    }

    private void makeWritableClobClone(long l) throws IOException, SQLException {
        InternalClob internalClob = this.clob;
        this.clob = TemporaryClob.cloneClobContent(this.getEmbedConnection().getDBName(), this, internalClob, l);
        internalClob.release();
    }

    InternalClob getInternalClob() {
        return this.clob;
    }

    public int getLocator() {
        if (this.locator == 0) {
            this.locator = this.localConn.addLOBMapping(this);
        }
        return this.locator;
    }
}

