/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.net.InetAddress;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.params.HostParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolFactory;
import org.apache.commons.httpclient.util.LangUtils;

public class HostConfiguration
implements Cloneable {
    public static final HostConfiguration ANY_HOST_CONFIGURATION = new HostConfiguration();
    private HttpHost host = null;
    private ProxyHost proxyHost = null;
    private InetAddress localAddress = null;
    private HostParams params = new HostParams();

    public HostConfiguration() {
    }

    public HostConfiguration(HostConfiguration hostConfiguration) {
        this.init(hostConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(HostConfiguration hostConfiguration) {
        HostConfiguration hostConfiguration2 = hostConfiguration;
        synchronized (hostConfiguration2) {
            try {
                this.host = hostConfiguration.host != null ? (HttpHost)hostConfiguration.host.clone() : null;
                this.proxyHost = hostConfiguration.proxyHost != null ? (ProxyHost)hostConfiguration.proxyHost.clone() : null;
                this.localAddress = hostConfiguration.getLocalAddress();
                this.params = (HostParams)hostConfiguration.getParams().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalArgumentException("Host configuration could not be cloned");
            }
        }
    }

    public Object clone() {
        HostConfiguration hostConfiguration;
        try {
            hostConfiguration = (HostConfiguration)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException("Host configuration could not be cloned");
        }
        hostConfiguration.init(this);
        return hostConfiguration;
    }

    public synchronized String toString() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("HostConfiguration[");
        if (this.host != null) {
            bl = true;
            stringBuffer.append("host=").append(this.host);
        }
        if (this.proxyHost != null) {
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append("proxyHost=").append(this.proxyHost);
        }
        if (this.localAddress != null) {
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append("localAddress=").append(this.localAddress);
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append("params=").append(this.params);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public synchronized boolean hostEquals(HttpConnection httpConnection) {
        if (httpConnection == null) {
            throw new IllegalArgumentException("Connection may not be null");
        }
        if (this.host != null) {
            if (!this.host.getHostName().equalsIgnoreCase(httpConnection.getHost())) {
                return false;
            }
            if (this.host.getPort() != httpConnection.getPort()) {
                return false;
            }
            if (!this.host.getProtocol().equals(httpConnection.getProtocol())) {
                return false;
            }
            return !(this.localAddress != null ? !this.localAddress.equals(httpConnection.getLocalAddress()) : httpConnection.getLocalAddress() != null);
        }
        return false;
    }

    public synchronized boolean proxyEquals(HttpConnection httpConnection) {
        if (httpConnection == null) {
            throw new IllegalArgumentException("Connection may not be null");
        }
        if (this.proxyHost != null) {
            return this.proxyHost.getHostName().equalsIgnoreCase(httpConnection.getProxyHost()) && this.proxyHost.getPort() == httpConnection.getProxyPort();
        }
        return httpConnection.getProxyHost() == null;
    }

    public synchronized boolean isHostSet() {
        return this.host != null;
    }

    public synchronized void setHost(HttpHost httpHost) {
        this.host = httpHost;
    }

    public synchronized void setHost(String string, int n, String string2) {
        this.host = this.params.getParameter("http.protocol.factory") != null ? new HttpHost(string, n, ((ProtocolFactory)this.params.getParameter("http.protocol.factory")).getProtocol(string2)) : new HttpHost(string, n, Protocol.getProtocol(string2));
    }

    public synchronized void setHost(String string, String string2, int n, Protocol protocol) {
        this.setHost(string, n, protocol);
        this.params.setVirtualHost(string2);
    }

    public synchronized void setHost(String string, int n, Protocol protocol) {
        if (string == null) {
            throw new IllegalArgumentException("host must not be null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol must not be null");
        }
        this.host = new HttpHost(string, n, protocol);
    }

    public synchronized void setHost(String string, int n) {
        this.setHost(string, n, "http");
    }

    public synchronized void setHost(String string) {
        Protocol protocol = this.params.getParameter("http.protocol.factory") != null ? ((ProtocolFactory)this.params.getParameter("http.protocol.factory")).getProtocol("http") : Protocol.getProtocol("http");
        this.setHost(string, protocol.getDefaultPort(), protocol);
    }

    public synchronized void setHost(URI uRI) {
        try {
            this.setHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
        }
        catch (URIException uRIException) {
            throw new IllegalArgumentException(uRIException.toString());
        }
    }

    public synchronized String getHostURL() {
        if (this.host == null) {
            throw new IllegalStateException("Host must be set to create a host URL");
        }
        return this.host.toURI();
    }

    public synchronized String getHost() {
        if (this.host != null) {
            return this.host.getHostName();
        }
        return null;
    }

    public synchronized String getVirtualHost() {
        return this.params.getVirtualHost();
    }

    public synchronized int getPort() {
        if (this.host != null) {
            return this.host.getPort();
        }
        return -1;
    }

    public synchronized Protocol getProtocol() {
        if (this.host != null) {
            return this.host.getProtocol();
        }
        return null;
    }

    public synchronized boolean isProxySet() {
        return this.proxyHost != null;
    }

    public synchronized void setProxyHost(ProxyHost proxyHost) {
        this.proxyHost = proxyHost;
    }

    public synchronized void setProxy(String string, int n) {
        this.proxyHost = new ProxyHost(string, n);
    }

    public synchronized String getProxyHost() {
        if (this.proxyHost != null) {
            return this.proxyHost.getHostName();
        }
        return null;
    }

    public synchronized int getProxyPort() {
        if (this.proxyHost != null) {
            return this.proxyHost.getPort();
        }
        return -1;
    }

    public synchronized void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
    }

    public synchronized InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public HostParams getParams() {
        return this.params;
    }

    public void setParams(HostParams hostParams) {
        if (hostParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = hostParams;
    }

    public synchronized boolean equals(Object object) {
        if (object instanceof HostConfiguration) {
            if (object == this) {
                return true;
            }
            HostConfiguration hostConfiguration = (HostConfiguration)object;
            return LangUtils.equals(this.host, hostConfiguration.host) && LangUtils.equals(this.proxyHost, hostConfiguration.proxyHost) && LangUtils.equals(this.localAddress, hostConfiguration.localAddress);
        }
        return false;
    }

    public synchronized int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.host);
        n = LangUtils.hashCode(n, this.proxyHost);
        n = LangUtils.hashCode(n, this.localAddress);
        return n;
    }
}

