/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.util.EncodingUtil;

final class NTLM {
    protected static final int FLAG_UNICODE_ENCODING = 1;
    protected static final int FLAG_TARGET_DESIRED = 4;
    protected static final int FLAG_NEGOTIATE_SIGN = 16;
    protected static final int FLAG_NEGOTIATE_SEAL = 32;
    protected static final int FLAG_NEGOTIATE_NTLM = 512;
    protected static final int FLAG_NEGOTIATE_ALWAYS_SIGN = 32768;
    protected static final int FLAG_NEGOTIATE_NTLM2 = 524288;
    protected static final int FLAG_NEGOTIATE_128 = 0x20000000;
    protected static final int FLAG_NEGOTIATE_KEY_EXCH = 0x40000000;
    private static SecureRandom randomGenerator;
    private static final String signatureString = "NTLMSSP";
    public static final String DEFAULT_CHARSET = "ASCII";
    private String credentialCharset = "ASCII";
    private static byte[] signatureBytes;

    NTLM() {
    }

    public final String getResponseFor(String string, String string2, String string3, String string4, String string5) throws AuthenticationException {
        String string6;
        if (string == null || string.trim().equals("")) {
            string6 = this.getType1Message(string4, string5);
        } else {
            Type2Message type2Message = new Type2Message(string);
            string6 = this.getType3Message(string2, string3, string4, string5, type2Message.getChallenge(), type2Message.getFlags(), type2Message.getTarget(), type2Message.getTargetInfo());
        }
        return string6;
    }

    public String getType1Message(String string, String string2) throws AuthenticationException {
        return new Type1Message(string2, string).getResponse();
    }

    public String getType3Message(String string, String string2, String string3, String string4, byte[] byArray, int n, String string5, byte[] byArray2) throws AuthenticationException {
        return new Type3Message(string4, string3, string, string2, byArray, n, string5, byArray2).getResponse();
    }

    public String getCredentialCharset() {
        return this.credentialCharset;
    }

    public void setCredentialCharset(String string) {
        this.credentialCharset = string;
    }

    private static String stripDotSuffix(String string) {
        int n = string.indexOf(".");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static String convertHost(String string) {
        return NTLM.stripDotSuffix(string);
    }

    private static String convertDomain(String string) {
        return NTLM.stripDotSuffix(string);
    }

    private static int readULong(byte[] byArray, int n) throws AuthenticationException {
        if (byArray.length < n + 4) {
            throw new AuthenticationException("NTLM authentication - buffer too small for DWORD");
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private static int readUShort(byte[] byArray, int n) throws AuthenticationException {
        if (byArray.length < n + 2) {
            throw new AuthenticationException("NTLM authentication - buffer too small for WORD");
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static byte[] readSecurityBuffer(byte[] byArray, int n) throws AuthenticationException {
        int n2 = NTLM.readUShort(byArray, n);
        int n3 = NTLM.readULong(byArray, n + 4);
        if (byArray.length < n3 + n2) {
            throw new AuthenticationException("NTLM authentication - buffer too small for data item");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3, byArray2, 0, n2);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeRandomChallenge() {
        byte[] byArray = new byte[8];
        SecureRandom secureRandom = randomGenerator;
        synchronized (secureRandom) {
            randomGenerator.nextBytes(byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeNTLM2RandomChallenge() {
        byte[] byArray = new byte[24];
        SecureRandom secureRandom = randomGenerator;
        synchronized (secureRandom) {
            randomGenerator.nextBytes(byArray);
        }
        Arrays.fill(byArray, 8, 24, (byte)0);
        return byArray;
    }

    public static byte[] getLMResponse(String string, byte[] byArray) throws AuthenticationException {
        byte[] byArray2 = NTLM.lmHash(string);
        return NTLM.lmResponse(byArray2, byArray);
    }

    public static byte[] getNTLMResponse(String string, byte[] byArray) throws AuthenticationException {
        byte[] byArray2 = NTLM.ntlmHash(string);
        return NTLM.lmResponse(byArray2, byArray);
    }

    public static byte[] getNTLMv2Response(String string, String string2, String string3, byte[] byArray, byte[] byArray2, byte[] byArray3) throws AuthenticationException {
        byte[] byArray4 = NTLM.ntlmv2Hash(string, string2, string3);
        byte[] byArray5 = NTLM.createBlob(byArray2, byArray3);
        return NTLM.lmv2Response(byArray4, byArray, byArray5);
    }

    public static byte[] getLMv2Response(String string, String string2, String string3, byte[] byArray, byte[] byArray2) throws AuthenticationException {
        byte[] byArray3 = NTLM.ntlmv2Hash(string, string2, string3);
        return NTLM.lmv2Response(byArray3, byArray, byArray2);
    }

    public static byte[] getNTLM2SessionResponse(String string, byte[] byArray, byte[] byArray2) throws AuthenticationException {
        try {
            byte[] byArray3 = NTLM.ntlmHash(string);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            byte[] byArray4 = messageDigest.digest();
            byte[] byArray5 = new byte[8];
            System.arraycopy(byArray4, 0, byArray5, 0, 8);
            return NTLM.lmResponse(byArray3, byArray5);
        }
        catch (Exception exception) {
            if (exception instanceof AuthenticationException) {
                throw (AuthenticationException)exception;
            }
            throw new AuthenticationException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmHash(String string) throws AuthenticationException {
        try {
            byte[] byArray = string.toUpperCase().getBytes("US-ASCII");
            int n = Math.min(byArray.length, 14);
            byte[] byArray2 = new byte[14];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            Key key = NTLM.createDESKey(byArray2, 0);
            Key key2 = NTLM.createDESKey(byArray2, 7);
            byte[] byArray3 = "KGS!@#$%".getBytes("US-ASCII");
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] byArray4 = cipher.doFinal(byArray3);
            cipher.init(1, key2);
            byte[] byArray5 = cipher.doFinal(byArray3);
            byte[] byArray6 = new byte[16];
            System.arraycopy(byArray4, 0, byArray6, 0, 8);
            System.arraycopy(byArray5, 0, byArray6, 8, 8);
            return byArray6;
        }
        catch (Exception exception) {
            throw new AuthenticationException(exception.getMessage(), exception);
        }
    }

    private static byte[] ntlmHash(String string) throws AuthenticationException {
        try {
            byte[] byArray = string.getBytes("UnicodeLittleUnmarked");
            MD4 mD4 = new MD4();
            mD4.update(byArray);
            return mD4.getOutput();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationException("Unicode not supported: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static byte[] ntlmv2Hash(String string, String string2, String string3) throws AuthenticationException {
        try {
            byte[] byArray = NTLM.ntlmHash(string3);
            HMACMD5 hMACMD5 = new HMACMD5(byArray);
            hMACMD5.update(string2.toUpperCase().getBytes("UnicodeLittleUnmarked"));
            hMACMD5.update(string.getBytes("UnicodeLittleUnmarked"));
            return hMACMD5.getOutput();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationException("Unicode not supported! " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static byte[] lmResponse(byte[] byArray, byte[] byArray2) throws AuthenticationException {
        try {
            byte[] byArray3 = new byte[21];
            System.arraycopy(byArray, 0, byArray3, 0, 16);
            Key key = NTLM.createDESKey(byArray3, 0);
            Key key2 = NTLM.createDESKey(byArray3, 7);
            Key key3 = NTLM.createDESKey(byArray3, 14);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] byArray4 = cipher.doFinal(byArray2);
            cipher.init(1, key2);
            byte[] byArray5 = cipher.doFinal(byArray2);
            cipher.init(1, key3);
            byte[] byArray6 = cipher.doFinal(byArray2);
            byte[] byArray7 = new byte[24];
            System.arraycopy(byArray4, 0, byArray7, 0, 8);
            System.arraycopy(byArray5, 0, byArray7, 8, 8);
            System.arraycopy(byArray6, 0, byArray7, 16, 8);
            return byArray7;
        }
        catch (Exception exception) {
            throw new AuthenticationException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmv2Response(byte[] byArray, byte[] byArray2, byte[] byArray3) throws AuthenticationException {
        HMACMD5 hMACMD5 = new HMACMD5(byArray);
        hMACMD5.update(byArray2);
        hMACMD5.update(byArray3);
        byte[] byArray4 = hMACMD5.getOutput();
        byte[] byArray5 = new byte[byArray4.length + byArray3.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
        return byArray5;
    }

    private static byte[] createBlob(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[]{1, 1, 0, 0};
        byte[] byArray4 = new byte[]{0, 0, 0, 0};
        byte[] byArray5 = new byte[]{0, 0, 0, 0};
        long l = System.currentTimeMillis();
        l += 11644473600000L;
        l *= 10000L;
        byte[] byArray6 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray6[i] = (byte)l;
            l >>>= 8;
        }
        byte[] byArray7 = new byte[byArray3.length + byArray4.length + byArray6.length + 8 + byArray5.length + byArray2.length];
        int n = 0;
        System.arraycopy(byArray3, 0, byArray7, n, byArray3.length);
        System.arraycopy(byArray4, 0, byArray7, n += byArray3.length, byArray4.length);
        System.arraycopy(byArray6, 0, byArray7, n += byArray4.length, byArray6.length);
        System.arraycopy(byArray, 0, byArray7, n += byArray6.length, 8);
        System.arraycopy(byArray5, 0, byArray7, n += 8, byArray5.length);
        System.arraycopy(byArray2, 0, byArray7, n += byArray5.length, byArray2.length);
        return byArray7;
    }

    private static Key createDESKey(byte[] byArray, int n) {
        byte[] byArray2 = new byte[7];
        System.arraycopy(byArray, n, byArray2, 0, 7);
        byte[] byArray3 = new byte[]{byArray2[0], (byte)(byArray2[0] << 7 | (byArray2[1] & 0xFF) >>> 1), (byte)(byArray2[1] << 6 | (byArray2[2] & 0xFF) >>> 2), (byte)(byArray2[2] << 5 | (byArray2[3] & 0xFF) >>> 3), (byte)(byArray2[3] << 4 | (byArray2[4] & 0xFF) >>> 4), (byte)(byArray2[4] << 3 | (byArray2[5] & 0xFF) >>> 5), (byte)(byArray2[5] << 2 | (byArray2[6] & 0xFF) >>> 6), (byte)(byArray2[6] << 1)};
        NTLM.oddParity(byArray3);
        return new SecretKeySpec(byArray3, "DES");
    }

    private static void oddParity(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            byte by = byArray[i];
            boolean bl2 = bl = ((by >>> 7 ^ by >>> 6 ^ by >>> 5 ^ by >>> 4 ^ by >>> 3 ^ by >>> 2 ^ by >>> 1) & 1) == 0;
            if (bl) {
                int n = i;
                byArray[n] = (byte)(byArray[n] | 1);
                continue;
            }
            int n = i;
            byArray[n] = (byte)(byArray[n] & 0xFFFFFFFE);
        }
    }

    protected static void writeULong(byte[] byArray, int n, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }

    protected static int F(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    protected static int G(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    protected static int H(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    protected static int rotintlft(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    public static void main(String[] stringArray) throws Exception {
        NTLM.checkMD4("", "31d6cfe0d16ae931b73c59d7e0c089c0");
        NTLM.checkMD4("a", "bde52cb31de33e46245e05fbdbd6fb24");
        NTLM.checkMD4("abc", "a448017aaf21d8525fc10ae87aa6729d");
        NTLM.checkMD4("message digest", "d9130a8164549fe818874806e1c7014b");
        NTLM.checkMD4("abcdefghijklmnopqrstuvwxyz", "d79e1c308aa5bbcdeea8ed63df412da9");
        NTLM.checkMD4("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "043f8582f241db351ce627e153e7f0e4");
        NTLM.checkMD4("12345678901234567890123456789012345678901234567890123456789012345678901234567890", "e33b4ddc9c38f2199c3e7b164fcc0536");
        System.out.println("Tests pass");
    }

    protected static byte checkToNibble(char c) {
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        return (byte)(c - 48);
    }

    protected static byte[] checkToBytes(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(NTLM.checkToNibble(string.charAt(i * 2)) << 4 | NTLM.checkToNibble(string.charAt(i * 2 + 1)));
        }
        return byArray;
    }

    protected static void checkMD4(String string, String string2) throws Exception {
        MD4 mD4 = new MD4();
        mD4.update(string.getBytes(DEFAULT_CHARSET));
        byte[] byArray = mD4.getOutput();
        byte[] byArray2 = NTLM.checkToBytes(string2);
        if (byArray.length != byArray2.length) {
            throw new Exception("Answer length disagrees for MD4('" + string + "')");
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            throw new Exception("Answer value for MD4('" + string + "') disagrees at position " + Integer.toString(i));
        }
    }

    static {
        try {
            randomGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            System.err.println("Couldn't initialize random generator: " + exception.getMessage());
            exception.printStackTrace(System.err);
        }
        byte[] byArray = EncodingUtil.getBytes(signatureString, DEFAULT_CHARSET);
        signatureBytes = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, signatureBytes, 0, byArray.length);
        NTLM.signatureBytes[byArray.length] = 0;
    }

    protected static class HMACMD5 {
        protected byte[] ipad;
        protected byte[] opad;
        protected MessageDigest md5;

        public HMACMD5(byte[] byArray) throws AuthenticationException {
            int n;
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                throw new AuthenticationException("Error getting md5 message digest implementation: " + exception.getMessage(), exception);
            }
            this.ipad = new byte[64];
            this.opad = new byte[64];
            int n2 = byArray.length;
            if (n2 > 64) {
                this.md5.update(byArray);
                byArray = this.md5.digest();
                n2 = byArray.length;
            }
            for (n = 0; n < n2; ++n) {
                this.ipad[n] = (byte)(byArray[n] ^ 0x36);
                this.opad[n] = (byte)(byArray[n] ^ 0x5C);
            }
            while (n < 64) {
                this.ipad[n] = 54;
                this.opad[n] = 92;
                ++n;
            }
            this.md5.reset();
            this.md5.update(this.ipad);
        }

        public byte[] getOutput() {
            byte[] byArray = this.md5.digest();
            this.md5.update(this.opad);
            return this.md5.digest(byArray);
        }

        public void update(byte[] byArray) {
            this.md5.update(byArray);
        }

        public void update(byte[] byArray, int n, int n2) {
            this.md5.update(byArray, n, n2);
        }
    }

    protected static class MD4 {
        protected int A = 1732584193;
        protected int B = -271733879;
        protected int C = -1732584194;
        protected int D = 271733878;
        protected long count = 0L;
        protected byte[] dataBuffer = new byte[64];

        public void update(byte[] byArray) {
            int n;
            int n2 = (int)(this.count & 0x3FL);
            int n3 = 0;
            while (byArray.length - n3 + n2 >= this.dataBuffer.length) {
                n = this.dataBuffer.length - n2;
                System.arraycopy(byArray, n3, this.dataBuffer, n2, n);
                this.count += (long)n;
                n2 = 0;
                n3 += n;
                this.processBuffer();
            }
            if (n3 < byArray.length) {
                n = byArray.length - n3;
                System.arraycopy(byArray, n3, this.dataBuffer, n2, n);
                this.count += (long)n;
                n2 += n;
            }
        }

        public byte[] getOutput() {
            int n = (int)(this.count & 0x3FL);
            int n2 = n < 56 ? 56 - n : 120 - n;
            byte[] byArray = new byte[n2 + 8];
            byArray[0] = -128;
            for (int i = 0; i < 8; ++i) {
                byArray[n2 + i] = (byte)(this.count * 8L >>> 8 * i);
            }
            this.update(byArray);
            byte[] byArray2 = new byte[16];
            NTLM.writeULong(byArray2, this.A, 0);
            NTLM.writeULong(byArray2, this.B, 4);
            NTLM.writeULong(byArray2, this.C, 8);
            NTLM.writeULong(byArray2, this.D, 12);
            return byArray2;
        }

        protected void processBuffer() {
            int n;
            int[] nArray = new int[16];
            for (n = 0; n < 16; ++n) {
                nArray[n] = (this.dataBuffer[n * 4] & 0xFF) + ((this.dataBuffer[n * 4 + 1] & 0xFF) << 8) + ((this.dataBuffer[n * 4 + 2] & 0xFF) << 16) + ((this.dataBuffer[n * 4 + 3] & 0xFF) << 24);
            }
            n = this.A;
            int n2 = this.B;
            int n3 = this.C;
            int n4 = this.D;
            this.round1(nArray);
            this.round2(nArray);
            this.round3(nArray);
            this.A += n;
            this.B += n2;
            this.C += n3;
            this.D += n4;
        }

        protected void round1(int[] nArray) {
            this.A = NTLM.rotintlft(this.A + NTLM.F(this.B, this.C, this.D) + nArray[0], 3);
            this.D = NTLM.rotintlft(this.D + NTLM.F(this.A, this.B, this.C) + nArray[1], 7);
            this.C = NTLM.rotintlft(this.C + NTLM.F(this.D, this.A, this.B) + nArray[2], 11);
            this.B = NTLM.rotintlft(this.B + NTLM.F(this.C, this.D, this.A) + nArray[3], 19);
            this.A = NTLM.rotintlft(this.A + NTLM.F(this.B, this.C, this.D) + nArray[4], 3);
            this.D = NTLM.rotintlft(this.D + NTLM.F(this.A, this.B, this.C) + nArray[5], 7);
            this.C = NTLM.rotintlft(this.C + NTLM.F(this.D, this.A, this.B) + nArray[6], 11);
            this.B = NTLM.rotintlft(this.B + NTLM.F(this.C, this.D, this.A) + nArray[7], 19);
            this.A = NTLM.rotintlft(this.A + NTLM.F(this.B, this.C, this.D) + nArray[8], 3);
            this.D = NTLM.rotintlft(this.D + NTLM.F(this.A, this.B, this.C) + nArray[9], 7);
            this.C = NTLM.rotintlft(this.C + NTLM.F(this.D, this.A, this.B) + nArray[10], 11);
            this.B = NTLM.rotintlft(this.B + NTLM.F(this.C, this.D, this.A) + nArray[11], 19);
            this.A = NTLM.rotintlft(this.A + NTLM.F(this.B, this.C, this.D) + nArray[12], 3);
            this.D = NTLM.rotintlft(this.D + NTLM.F(this.A, this.B, this.C) + nArray[13], 7);
            this.C = NTLM.rotintlft(this.C + NTLM.F(this.D, this.A, this.B) + nArray[14], 11);
            this.B = NTLM.rotintlft(this.B + NTLM.F(this.C, this.D, this.A) + nArray[15], 19);
        }

        protected void round2(int[] nArray) {
            this.A = NTLM.rotintlft(this.A + NTLM.G(this.B, this.C, this.D) + nArray[0] + 1518500249, 3);
            this.D = NTLM.rotintlft(this.D + NTLM.G(this.A, this.B, this.C) + nArray[4] + 1518500249, 5);
            this.C = NTLM.rotintlft(this.C + NTLM.G(this.D, this.A, this.B) + nArray[8] + 1518500249, 9);
            this.B = NTLM.rotintlft(this.B + NTLM.G(this.C, this.D, this.A) + nArray[12] + 1518500249, 13);
            this.A = NTLM.rotintlft(this.A + NTLM.G(this.B, this.C, this.D) + nArray[1] + 1518500249, 3);
            this.D = NTLM.rotintlft(this.D + NTLM.G(this.A, this.B, this.C) + nArray[5] + 1518500249, 5);
            this.C = NTLM.rotintlft(this.C + NTLM.G(this.D, this.A, this.B) + nArray[9] + 1518500249, 9);
            this.B = NTLM.rotintlft(this.B + NTLM.G(this.C, this.D, this.A) + nArray[13] + 1518500249, 13);
            this.A = NTLM.rotintlft(this.A + NTLM.G(this.B, this.C, this.D) + nArray[2] + 1518500249, 3);
            this.D = NTLM.rotintlft(this.D + NTLM.G(this.A, this.B, this.C) + nArray[6] + 1518500249, 5);
            this.C = NTLM.rotintlft(this.C + NTLM.G(this.D, this.A, this.B) + nArray[10] + 1518500249, 9);
            this.B = NTLM.rotintlft(this.B + NTLM.G(this.C, this.D, this.A) + nArray[14] + 1518500249, 13);
            this.A = NTLM.rotintlft(this.A + NTLM.G(this.B, this.C, this.D) + nArray[3] + 1518500249, 3);
            this.D = NTLM.rotintlft(this.D + NTLM.G(this.A, this.B, this.C) + nArray[7] + 1518500249, 5);
            this.C = NTLM.rotintlft(this.C + NTLM.G(this.D, this.A, this.B) + nArray[11] + 1518500249, 9);
            this.B = NTLM.rotintlft(this.B + NTLM.G(this.C, this.D, this.A) + nArray[15] + 1518500249, 13);
        }

        protected void round3(int[] nArray) {
            this.A = NTLM.rotintlft(this.A + NTLM.H(this.B, this.C, this.D) + nArray[0] + 1859775393, 3);
            this.D = NTLM.rotintlft(this.D + NTLM.H(this.A, this.B, this.C) + nArray[8] + 1859775393, 9);
            this.C = NTLM.rotintlft(this.C + NTLM.H(this.D, this.A, this.B) + nArray[4] + 1859775393, 11);
            this.B = NTLM.rotintlft(this.B + NTLM.H(this.C, this.D, this.A) + nArray[12] + 1859775393, 15);
            this.A = NTLM.rotintlft(this.A + NTLM.H(this.B, this.C, this.D) + nArray[2] + 1859775393, 3);
            this.D = NTLM.rotintlft(this.D + NTLM.H(this.A, this.B, this.C) + nArray[10] + 1859775393, 9);
            this.C = NTLM.rotintlft(this.C + NTLM.H(this.D, this.A, this.B) + nArray[6] + 1859775393, 11);
            this.B = NTLM.rotintlft(this.B + NTLM.H(this.C, this.D, this.A) + nArray[14] + 1859775393, 15);
            this.A = NTLM.rotintlft(this.A + NTLM.H(this.B, this.C, this.D) + nArray[1] + 1859775393, 3);
            this.D = NTLM.rotintlft(this.D + NTLM.H(this.A, this.B, this.C) + nArray[9] + 1859775393, 9);
            this.C = NTLM.rotintlft(this.C + NTLM.H(this.D, this.A, this.B) + nArray[5] + 1859775393, 11);
            this.B = NTLM.rotintlft(this.B + NTLM.H(this.C, this.D, this.A) + nArray[13] + 1859775393, 15);
            this.A = NTLM.rotintlft(this.A + NTLM.H(this.B, this.C, this.D) + nArray[3] + 1859775393, 3);
            this.D = NTLM.rotintlft(this.D + NTLM.H(this.A, this.B, this.C) + nArray[11] + 1859775393, 9);
            this.C = NTLM.rotintlft(this.C + NTLM.H(this.D, this.A, this.B) + nArray[7] + 1859775393, 11);
            this.B = NTLM.rotintlft(this.B + NTLM.H(this.C, this.D, this.A) + nArray[15] + 1859775393, 15);
        }
    }

    public static class Type3Message
    extends NTLMMessage {
        protected int type2Flags;
        protected byte[] domainBytes;
        protected byte[] hostBytes;
        protected byte[] userBytes;
        protected byte[] lmResp;
        protected byte[] ntResp;

        public Type3Message(String string, String string2, String string3, String string4, byte[] byArray, int n, String string5, byte[] byArray2) throws AuthenticationException {
            this.type2Flags = n;
            string2 = NTLM.convertHost(string2);
            string = NTLM.convertDomain(string);
            try {
                byte[] byArray3;
                if (byArray2 != null && string5 != null) {
                    byArray3 = NTLM.makeRandomChallenge();
                    this.ntResp = NTLM.getNTLMv2Response(string5, string3, string4, byArray, byArray3, byArray2);
                    this.lmResp = NTLM.getLMv2Response(string5, string3, string4, byArray, byArray3);
                } else if ((n & 0x80000) != 0) {
                    byArray3 = NTLM.makeNTLM2RandomChallenge();
                    this.ntResp = NTLM.getNTLM2SessionResponse(string4, byArray, byArray3);
                    this.lmResp = byArray3;
                } else {
                    this.ntResp = NTLM.getNTLMResponse(string4, byArray);
                    this.lmResp = NTLM.getLMResponse(string4, byArray);
                }
            }
            catch (AuthenticationException authenticationException) {
                this.ntResp = new byte[0];
                this.lmResp = NTLM.getLMResponse(string4, byArray);
            }
            try {
                this.domainBytes = string.toUpperCase().getBytes("UnicodeLittleUnmarked");
                this.hostBytes = string2.getBytes("UnicodeLittleUnmarked");
                this.userBytes = string3.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AuthenticationException("Unicode not supported: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }

        public String getResponse() {
            int n = this.ntResp.length;
            int n2 = this.lmResp.length;
            int n3 = this.domainBytes.length;
            int n4 = this.hostBytes.length;
            int n5 = this.userBytes.length;
            int n6 = 64;
            int n7 = n6 + n2;
            int n8 = n7 + n;
            int n9 = n8 + n3;
            int n10 = n9 + n5;
            int n11 = n10 + n4;
            int n12 = n11 + 0;
            this.prepareResponse(n12, 3);
            this.addUShort(n2);
            this.addUShort(n2);
            this.addULong(n6);
            this.addUShort(n);
            this.addUShort(n);
            this.addULong(n7);
            this.addUShort(n3);
            this.addUShort(n3);
            this.addULong(n8);
            this.addUShort(n5);
            this.addUShort(n5);
            this.addULong(n9);
            this.addUShort(n4);
            this.addUShort(n4);
            this.addULong(n10);
            this.addULong(0);
            this.addULong(n12);
            this.addULong(0x20000205 | this.type2Flags & 0x80000 | this.type2Flags & 0x10 | this.type2Flags & 0x20 | this.type2Flags & 0x40000000 | this.type2Flags & 0x8000);
            this.addBytes(this.lmResp);
            this.addBytes(this.ntResp);
            this.addBytes(this.domainBytes);
            this.addBytes(this.userBytes);
            this.addBytes(this.hostBytes);
            return super.getResponse();
        }
    }

    public static class Type2Message
    extends NTLMMessage {
        protected byte[] challenge = new byte[8];
        protected String target;
        protected byte[] targetInfo;
        protected int flags;

        public Type2Message(String string) throws AuthenticationException {
            super(string, 2);
            byte[] byArray;
            this.readBytes(this.challenge, 24);
            this.flags = this.readULong(20);
            if ((this.flags & 1) == 0) {
                throw new AuthenticationException("NTLM type 2 message has flags that make no sense: " + Integer.toString(this.flags));
            }
            this.target = null;
            if (this.getMessageLength() >= 20 && (byArray = this.readSecurityBuffer(12)).length != 0) {
                try {
                    this.target = new String(byArray, "UnicodeLittleUnmarked");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new AuthenticationException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
            }
            this.targetInfo = null;
            if (this.getMessageLength() >= 48 && (byArray = this.readSecurityBuffer(40)).length != 0) {
                this.targetInfo = byArray;
            }
        }

        public byte[] getChallenge() {
            return this.challenge;
        }

        public String getTarget() {
            return this.target;
        }

        public byte[] getTargetInfo() {
            return this.targetInfo;
        }

        public int getFlags() {
            return this.flags;
        }
    }

    public static class Type1Message
    extends NTLMMessage {
        protected byte[] hostBytes;
        protected byte[] domainBytes;

        public Type1Message(String string, String string2) throws AuthenticationException {
            try {
                string2 = NTLM.convertHost(string2);
                string = NTLM.convertDomain(string);
                this.hostBytes = string2.getBytes("UnicodeLittleUnmarked");
                this.domainBytes = string.toUpperCase().getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AuthenticationException("Unicode unsupported: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }

        public String getResponse() {
            int n = 32 + this.hostBytes.length + this.domainBytes.length;
            this.prepareResponse(n, 1);
            this.addULong(537395765);
            this.addUShort(this.domainBytes.length);
            this.addUShort(this.domainBytes.length);
            this.addULong(this.hostBytes.length + 32);
            this.addUShort(this.hostBytes.length);
            this.addUShort(this.hostBytes.length);
            this.addULong(32);
            this.addBytes(this.hostBytes);
            this.addBytes(this.domainBytes);
            return super.getResponse();
        }
    }

    protected static class NTLMMessage {
        private byte[] messageContents = null;
        private int currentOutputPosition = 0;

        public NTLMMessage() {
        }

        public NTLMMessage(String string, int n) throws AuthenticationException {
            this.messageContents = Base64.decodeBase64((byte[])EncodingUtil.getBytes(string, NTLM.DEFAULT_CHARSET));
            if (this.messageContents.length < signatureBytes.length) {
                throw new AuthenticationException("NTLM message decoding error - packet too short");
            }
            for (int i = 0; i < signatureBytes.length; ++i) {
                if (this.messageContents[i] == signatureBytes[i]) continue;
                throw new AuthenticationException("NTLM message expected - instead got unrecognized bytes");
            }
            int n2 = this.readULong(signatureBytes.length);
            if (n2 != n) {
                throw new AuthenticationException("NTLM type " + Integer.toString(n) + " message expected - instead got type " + Integer.toString(n2));
            }
            this.currentOutputPosition = this.messageContents.length;
        }

        protected int getPreambleLength() {
            return signatureBytes.length + 4;
        }

        protected int getMessageLength() {
            return this.currentOutputPosition;
        }

        protected byte readByte(int n) throws AuthenticationException {
            if (this.messageContents.length < n + 1) {
                throw new AuthenticationException("NTLM: Message too short");
            }
            return this.messageContents[n];
        }

        protected void readBytes(byte[] byArray, int n) throws AuthenticationException {
            if (this.messageContents.length < n + byArray.length) {
                throw new AuthenticationException("NTLM: Message too short");
            }
            System.arraycopy(this.messageContents, n, byArray, 0, byArray.length);
        }

        protected int readUShort(int n) throws AuthenticationException {
            return NTLM.readUShort(this.messageContents, n);
        }

        protected int readULong(int n) throws AuthenticationException {
            return NTLM.readULong(this.messageContents, n);
        }

        protected byte[] readSecurityBuffer(int n) throws AuthenticationException {
            return NTLM.readSecurityBuffer(this.messageContents, n);
        }

        protected void prepareResponse(int n, int n2) {
            this.messageContents = new byte[n];
            this.currentOutputPosition = 0;
            this.addBytes(signatureBytes);
            this.addULong(n2);
        }

        protected void addByte(byte by) {
            this.messageContents[this.currentOutputPosition] = by;
            ++this.currentOutputPosition;
        }

        protected void addBytes(byte[] byArray) {
            for (int i = 0; i < byArray.length; ++i) {
                this.messageContents[this.currentOutputPosition] = byArray[i];
                ++this.currentOutputPosition;
            }
        }

        protected void addUShort(int n) {
            this.addByte((byte)(n & 0xFF));
            this.addByte((byte)(n >> 8 & 0xFF));
        }

        protected void addULong(int n) {
            this.addByte((byte)(n & 0xFF));
            this.addByte((byte)(n >> 8 & 0xFF));
            this.addByte((byte)(n >> 16 & 0xFF));
            this.addByte((byte)(n >> 24 & 0xFF));
        }

        public String getResponse() {
            byte[] byArray;
            if (this.messageContents.length > this.currentOutputPosition) {
                byte[] byArray2 = new byte[this.currentOutputPosition];
                for (int i = 0; i < this.currentOutputPosition; ++i) {
                    byArray2[i] = this.messageContents[i];
                }
                byArray = byArray2;
            } else {
                byArray = this.messageContents;
            }
            return EncodingUtil.getAsciiString(Base64.encodeBase64((byte[])byArray));
        }
    }
}

