/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieSpecBase
implements CookieSpec {
    protected static final Log LOG = LogFactory.getLog(CookieSpec.class);
    private Collection datepatterns = null;

    public Cookie[] parse(String string, int n, String string2, boolean bl, String string3) throws MalformedCookieException {
        LOG.trace((Object)"enter CookieSpecBase.parse(String, port, path, boolean, Header)");
        if (string == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (string.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Header may not be null.");
        }
        if (string2.trim().equals("")) {
            string2 = "/";
        }
        string = string.toLowerCase(Locale.ENGLISH);
        String string4 = string2;
        int n2 = string4.lastIndexOf("/");
        if (n2 >= 0) {
            if (n2 == 0) {
                n2 = 1;
            }
            string4 = string4.substring(0, n2);
        }
        HeaderElement[] headerElementArray = null;
        boolean bl2 = false;
        int n3 = string3.toLowerCase(Locale.ENGLISH).indexOf("expires=");
        if (n3 != -1) {
            int n4 = string3.indexOf(";", n3 += "expires=".length());
            if (n4 == -1) {
                n4 = string3.length();
            }
            try {
                DateUtil.parseDate(string3.substring(n3, n4), this.datepatterns);
                bl2 = true;
            }
            catch (DateParseException dateParseException) {
                // empty catch block
            }
        }
        headerElementArray = bl2 ? new HeaderElement[]{new HeaderElement(string3.toCharArray())} : HeaderElement.parseElements(string3.toCharArray());
        Cookie[] cookieArray = new Cookie[headerElementArray.length];
        for (int i = 0; i < headerElementArray.length; ++i) {
            HeaderElement headerElement = headerElementArray[i];
            Cookie cookie = null;
            try {
                cookie = new Cookie(string, headerElement.getName(), headerElement.getValue(), string4, null, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedCookieException(illegalArgumentException.getMessage());
            }
            NameValuePair[] nameValuePairArray = headerElement.getParameters();
            if (nameValuePairArray != null) {
                for (int j = 0; j < nameValuePairArray.length; ++j) {
                    this.parseAttribute(nameValuePairArray[j], cookie);
                }
            }
            cookieArray[i] = cookie;
        }
        return cookieArray;
    }

    public Cookie[] parse(String string, int n, String string2, boolean bl, Header header) throws MalformedCookieException {
        LOG.trace((Object)"enter CookieSpecBase.parse(String, port, path, boolean, String)");
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null.");
        }
        return this.parse(string, n, string2, bl, header.getValue());
    }

    public void parseAttribute(NameValuePair nameValuePair, Cookie cookie) throws MalformedCookieException {
        if (nameValuePair == null) {
            throw new IllegalArgumentException("Attribute may not be null.");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null.");
        }
        String string = nameValuePair.getName().toLowerCase(Locale.ENGLISH);
        String string2 = nameValuePair.getValue();
        if (string.equals("path")) {
            if (string2 == null || string2.trim().equals("")) {
                string2 = "/";
            }
            cookie.setPath(string2);
            cookie.setPathAttributeSpecified(true);
        } else if (string.equals("domain")) {
            if (string2 == null) {
                throw new MalformedCookieException("Missing value for domain attribute");
            }
            if (string2.trim().equals("")) {
                throw new MalformedCookieException("Blank value for domain attribute");
            }
            cookie.setDomain(string2);
            cookie.setDomainAttributeSpecified(true);
        } else if (string.equals("max-age")) {
            int n;
            if (string2 == null) {
                throw new MalformedCookieException("Missing value for max-age attribute");
            }
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedCookieException("Invalid max-age attribute: " + numberFormatException.getMessage());
            }
            cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)n * 1000L));
        } else if (string.equals("secure")) {
            cookie.setSecure(true);
        } else if (string.equals("comment")) {
            cookie.setComment(string2);
        } else if (string.equals("expires")) {
            if (string2 == null) {
                throw new MalformedCookieException("Missing value for expires attribute");
            }
            try {
                cookie.setExpiryDate(DateUtil.parseDate(string2, this.datepatterns));
            }
            catch (DateParseException dateParseException) {
                LOG.debug((Object)"Error parsing cookie date", (Throwable)dateParseException);
                throw new MalformedCookieException("Unable to parse expiration date parameter: " + string2);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unrecognized cookie attribute: " + nameValuePair.toString()));
        }
    }

    public Collection getValidDateFormats() {
        return this.datepatterns;
    }

    public void setValidDateFormats(Collection collection) {
        this.datepatterns = collection;
    }

    public void validate(String string, int n, String string2, boolean bl, Cookie cookie) throws MalformedCookieException {
        LOG.trace((Object)"enter CookieSpecBase.validate(String, port, path, boolean, Cookie)");
        if (string == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (string.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (string2.trim().equals("")) {
            string2 = "/";
        }
        string = string.toLowerCase(Locale.ENGLISH);
        if (cookie.getVersion() < 0) {
            throw new MalformedCookieException("Illegal version number " + cookie.getValue());
        }
        if (string.indexOf(".") >= 0) {
            if (!string.endsWith(cookie.getDomain())) {
                String string3 = cookie.getDomain();
                if (string3.startsWith(".")) {
                    string3 = string3.substring(1, string3.length());
                }
                if (!string.equals(string3)) {
                    throw new MalformedCookieException("Illegal domain attribute \"" + cookie.getDomain() + "\". Domain of origin: \"" + string + "\"");
                }
            }
        } else if (!string.equals(cookie.getDomain())) {
            throw new MalformedCookieException("Illegal domain attribute \"" + cookie.getDomain() + "\". Domain of origin: \"" + string + "\"");
        }
        if (!string2.startsWith(cookie.getPath())) {
            throw new MalformedCookieException("Illegal path attribute \"" + cookie.getPath() + "\". Path of origin: \"" + string2 + "\"");
        }
    }

    public boolean match(String string, int n, String string2, boolean bl, Cookie cookie) {
        LOG.trace((Object)"enter CookieSpecBase.match(String, int, String, boolean, Cookie");
        if (string == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (string.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (string2.trim().equals("")) {
            string2 = "/";
        }
        string = string.toLowerCase(Locale.ENGLISH);
        if (cookie.getDomain() == null) {
            LOG.warn((Object)"Invalid cookie state: domain not specified");
            return false;
        }
        if (cookie.getPath() == null) {
            LOG.warn((Object)"Invalid cookie state: path not specified");
            return false;
        }
        return !(cookie.getExpiryDate() != null && !cookie.getExpiryDate().after(new Date()) || !this.domainMatch(string, cookie.getDomain()) || !this.pathMatch(string2, cookie.getPath()) || cookie.getSecure() && !bl);
    }

    public boolean domainMatch(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (!string2.startsWith(".")) {
            string2 = "." + string2;
        }
        return string.endsWith(string2) || string.equals(string2.substring(1));
    }

    public boolean pathMatch(String string, String string2) {
        boolean bl = string.startsWith(string2);
        if (bl && string.length() != string2.length() && !string2.endsWith("/")) {
            bl = string.charAt(string2.length()) == PATH_DELIM_CHAR;
        }
        return bl;
    }

    public Cookie[] match(String string, int n, String string2, boolean bl, Cookie[] cookieArray) {
        LOG.trace((Object)"enter CookieSpecBase.match(String, int, String, boolean, Cookie[])");
        if (cookieArray == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!this.match(string, n, string2, bl, cookieArray[i])) continue;
            CookieSpecBase.addInPathOrder(linkedList, cookieArray[i]);
        }
        return linkedList.toArray(new Cookie[linkedList.size()]);
    }

    private static void addInPathOrder(List list, Cookie cookie) {
        Cookie cookie2;
        int n = 0;
        for (n = 0; n < list.size() && cookie.compare(cookie, cookie2 = (Cookie)list.get(n)) <= 0; ++n) {
        }
        list.add(n, cookie);
    }

    public String formatCookie(Cookie cookie) {
        LOG.trace((Object)"enter CookieSpecBase.formatCookie(Cookie)");
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cookie.getName());
        stringBuffer.append("=");
        String string = cookie.getValue();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String formatCookies(Cookie[] cookieArray) throws IllegalArgumentException {
        LOG.trace((Object)"enter CookieSpecBase.formatCookies(Cookie[])");
        if (cookieArray == null) {
            throw new IllegalArgumentException("Cookie array may not be null");
        }
        if (cookieArray.length == 0) {
            throw new IllegalArgumentException("Cookie array may not be empty");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cookieArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(this.formatCookie(cookieArray[i]));
        }
        return stringBuffer.toString();
    }

    public Header formatCookieHeader(Cookie[] cookieArray) {
        LOG.trace((Object)"enter CookieSpecBase.formatCookieHeader(Cookie[])");
        return new Header("Cookie", this.formatCookies(cookieArray));
    }

    public Header formatCookieHeader(Cookie cookie) {
        LOG.trace((Object)"enter CookieSpecBase.formatCookieHeader(Cookie)");
        return new Header("Cookie", this.formatCookie(cookie));
    }
}

