/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import java.util.Locale;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieSpecMediumSecurity
extends CookieSpecBase {
    protected static final Log LOG = LogFactory.getLog(CookieSpecMediumSecurity.class);

    public void validate(String string, int n, String string2, boolean bl, Cookie cookie) throws MalformedCookieException {
        LOG.trace((Object)"enter CookieSpecMediumSecurity.validate(String, port, path, boolean, Cookie)");
        if (string == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (string.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (string2.trim().equals("")) {
            string2 = "/";
        }
        string = string.toLowerCase(Locale.ENGLISH);
        if (cookie.getVersion() < 0) {
            throw new MalformedCookieException("Illegal version number " + cookie.getValue());
        }
        if (string.indexOf(".") >= 0) {
            if (!string.endsWith(cookie.getDomain())) {
                String string3 = cookie.getDomain();
                if (string3.startsWith(".")) {
                    string3 = string3.substring(1, string3.length());
                }
                if (!string.equals(string3)) {
                    throw new MalformedCookieException("Illegal domain attribute \"" + cookie.getDomain() + "\". Domain of origin: \"" + string + "\"");
                }
            }
        } else if (!string.equals(cookie.getDomain())) {
            throw new MalformedCookieException("Illegal domain attribute \"" + cookie.getDomain() + "\". Domain of origin: \"" + string + "\"");
        }
    }
}

