/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;

public class ProtocolFactory {
    private Map PROTOCOLS = Collections.synchronizedMap(new HashMap());

    public void registerProtocol(String string, Protocol protocol) {
        if (string == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        this.PROTOCOLS.put(string, protocol);
    }

    public void unregisterProtocol(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.PROTOCOLS.remove(string);
    }

    public Protocol getProtocol(String string) throws IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("id is null");
        }
        Protocol protocol = (Protocol)this.PROTOCOLS.get(string);
        if (protocol == null) {
            protocol = this.lazyRegisterProtocol(string);
        }
        return protocol;
    }

    private Protocol lazyRegisterProtocol(String string) throws IllegalStateException {
        if ("http".equals(string)) {
            Protocol protocol = new Protocol("http", DefaultProtocolSocketFactory.getSocketFactory(), 80);
            Protocol.registerProtocol("http", protocol);
            return protocol;
        }
        if ("https".equals(string)) {
            Protocol protocol = new Protocol("https", SSLProtocolSocketFactory.getSocketFactory(), 443);
            Protocol.registerProtocol("https", protocol);
            return protocol;
        }
        throw new IllegalStateException("unsupported protocol: '" + string + "'");
    }
}

