/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanSet;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanIterators;

public class BooleanArraySet
extends AbstractBooleanSet {
    private static final long serialVersionUID = 1L;
    private boolean[] a;
    private int size;

    public BooleanArraySet(boolean[] a) {
        this.a = a;
    }

    public BooleanArraySet() {
        this.a = BooleanArrays.EMPTY_ARRAY;
    }

    public BooleanArraySet(boolean[] a, int size) {
        this.a = a;
        this.size = size;
        if (size > a.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a.length + ")");
        }
    }

    private int findKey(boolean o) {
        int i = this.size;
        while (i-- != 0) {
            if (this.a[i] != o) continue;
            return i;
        }
        return -1;
    }

    public BooleanIterator iterator() {
        return BooleanIterators.wrap(this.a, 0, this.size);
    }

    public boolean contains(boolean k) {
        return this.findKey(k) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(boolean k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        System.arraycopy(this.a, pos + 1, this.a, pos, this.size - pos - 1);
        --this.size;
        return true;
    }

    public boolean add(boolean k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            this.a = BooleanArrays.grow(this.a, this.size + 1);
        }
        this.a[this.size++] = k;
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size != 0;
    }
}

