/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteIterators;

public class ByteArraySet
extends AbstractByteSet {
    private static final long serialVersionUID = 1L;
    private byte[] a;
    private int size;

    public ByteArraySet(byte[] a) {
        this.a = a;
    }

    public ByteArraySet() {
        this.a = ByteArrays.EMPTY_ARRAY;
    }

    public ByteArraySet(byte[] a, int size) {
        this.a = a;
        this.size = size;
        if (size > a.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a.length + ")");
        }
    }

    private int findKey(byte o) {
        int i = this.size;
        while (i-- != 0) {
            if (this.a[i] != o) continue;
            return i;
        }
        return -1;
    }

    public ByteIterator iterator() {
        return ByteIterators.wrap(this.a, 0, this.size);
    }

    public boolean contains(byte k) {
        return this.findKey(k) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(byte k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        System.arraycopy(this.a, pos + 1, this.a, pos, this.size - pos - 1);
        --this.size;
        return true;
    }

    public boolean add(byte k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            this.a = ByteArrays.grow(this.a, this.size + 1);
        }
        this.a[this.size++] = k;
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size != 0;
    }
}

