/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2CharMap;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChar2CharMap
implements Char2CharMap,
Serializable {
    protected char defRetValue;

    protected AbstractChar2CharMap() {
    }

    @Override
    public void defaultReturnValue(char rv) {
        this.defRetValue = rv;
    }

    @Override
    public char defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public char put(char key, char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char remove(char key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character get(Object ok) {
        char k = ((Character)ok).charValue();
        return this.containsKey(k) ? Character.valueOf(this.get(k)) : null;
    }

    @Override
    public Character put(Character ok, Character ov) {
        char k = ok.charValue();
        char v = this.put(k, ov.charValue());
        return this.containsKey(k) ? Character.valueOf(v) : null;
    }

    @Override
    public Character remove(Object ok) {
        char k = ((Character)ok).charValue();
        char v = this.remove(k);
        return this.containsKey(k) ? Character.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue(((Character)ov).charValue());
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey(((Character)ok).charValue());
    }

    @Override
    public boolean containsValue(char v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(char k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Character> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Character, ? extends Character>> i = m.entrySet().iterator();
        if (m instanceof Char2CharMap) {
            while (n-- != 0) {
                Char2CharMap.Entry e = (Char2CharMap.Entry)i.next();
                this.put(e.getCharKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Character, ? extends Character> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            public boolean contains(char k) {
                return AbstractChar2CharMap.this.containsKey(k);
            }

            public int size() {
                return AbstractChar2CharMap.this.size();
            }

            public void clear() {
                AbstractChar2CharMap.this.clear();
            }

            public CharIterator iterator() {
                return new AbstractCharIterator(){
                    final ObjectIterator<Map.Entry<Character, Character>> i;
                    {
                        this.i = AbstractChar2CharMap.this.entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Char2CharMap.Entry)this.i.next()).getCharKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            public boolean contains(char k) {
                return AbstractChar2CharMap.this.containsValue(k);
            }

            public int size() {
                return AbstractChar2CharMap.this.size();
            }

            public void clear() {
                AbstractChar2CharMap.this.clear();
            }

            public CharIterator iterator() {
                return new AbstractCharIterator(){
                    final ObjectIterator<Map.Entry<Character, Character>> i;
                    {
                        this.i = AbstractChar2CharMap.this.entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Char2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Character, Character>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Character, Character>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Char2CharMap.Entry e = (Char2CharMap.Entry)i.next();
            s.append(String.valueOf(e.getCharKey()));
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Char2CharMap.Entry {
        protected char key;
        protected char value;

        public BasicEntry(Character key, Character value) {
            this.key = key.charValue();
            this.value = value.charValue();
        }

        public BasicEntry(char key, char value) {
            this.key = key;
            this.value = value;
        }

        public Character getKey() {
            return Character.valueOf(this.key);
        }

        public char getCharKey() {
            return this.key;
        }

        public Character getValue() {
            return Character.valueOf(this.value);
        }

        public char getCharValue() {
            return this.value;
        }

        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        public Character setValue(Character value) {
            return Character.valueOf(this.setValue(value.charValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Character)e.getKey()).charValue() && this.value == ((Character)e.getValue()).charValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

