/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2ShortMap;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDouble2ShortMap
implements Double2ShortMap,
Serializable {
    protected short defRetValue;

    protected AbstractDouble2ShortMap() {
    }

    @Override
    public void defaultReturnValue(short rv) {
        this.defRetValue = rv;
    }

    @Override
    public short defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public short put(double key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short remove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short get(Object ok) {
        double k = (Double)ok;
        return this.containsKey(k) ? Short.valueOf(this.get(k)) : null;
    }

    @Override
    public Short put(Double ok, Short ov) {
        double k = ok;
        short v = this.put(k, (short)ov);
        return this.containsKey(k) ? Short.valueOf(v) : null;
    }

    @Override
    public Short remove(Object ok) {
        double k = (Double)ok;
        short v = this.remove(k);
        return this.containsKey(k) ? Short.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Short)ov);
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey((Double)ok);
    }

    @Override
    public boolean containsValue(short v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(double k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Short> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Double, ? extends Short>> i = m.entrySet().iterator();
        if (m instanceof Double2ShortMap) {
            while (n-- != 0) {
                Double2ShortMap.Entry e = (Double2ShortMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getShortValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Double, ? extends Short> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            public boolean contains(double k) {
                return AbstractDouble2ShortMap.this.containsKey(k);
            }

            public int size() {
                return AbstractDouble2ShortMap.this.size();
            }

            public void clear() {
                AbstractDouble2ShortMap.this.clear();
            }

            public DoubleIterator iterator() {
                return new AbstractDoubleIterator(){
                    final ObjectIterator<Map.Entry<Double, Short>> i;
                    {
                        this.i = AbstractDouble2ShortMap.this.entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Double2ShortMap.Entry)this.i.next()).getDoubleKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ShortCollection values() {
        return new AbstractShortCollection(){

            public boolean contains(short k) {
                return AbstractDouble2ShortMap.this.containsValue(k);
            }

            public int size() {
                return AbstractDouble2ShortMap.this.size();
            }

            public void clear() {
                AbstractDouble2ShortMap.this.clear();
            }

            public ShortIterator iterator() {
                return new AbstractShortIterator(){
                    final ObjectIterator<Map.Entry<Double, Short>> i;
                    {
                        this.i = AbstractDouble2ShortMap.this.entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Double2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Double, Short>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Double, Short>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Double2ShortMap.Entry e = (Double2ShortMap.Entry)i.next();
            s.append(String.valueOf(e.getDoubleKey()));
            s.append("=>");
            s.append(String.valueOf(e.getShortValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Double2ShortMap.Entry {
        protected double key;
        protected short value;

        public BasicEntry(Double key, Short value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(double key, short value) {
            this.key = key;
            this.value = value;
        }

        public Double getKey() {
            return this.key;
        }

        public double getDoubleKey() {
            return this.key;
        }

        public Short getValue() {
            return this.value;
        }

        public short getShortValue() {
            return this.value;
        }

        public short setValue(short value) {
            throw new UnsupportedOperationException();
        }

        public Short setValue(Short value) {
            return this.setValue((short)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Double)e.getKey() && this.value == (Short)e.getValue();
        }

        public int hashCode() {
            return HashCommon.double2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

