/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.AbstractDouble2ShortMap;
import it.unimi.dsi.fastutil.doubles.Double2ShortMap;
import it.unimi.dsi.fastutil.doubles.DoubleArraySet;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollections;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Double2ShortArrayMap
extends AbstractDouble2ShortMap {
    private static final long serialVersionUID = 1L;
    private double[] key;
    private short[] value;
    private int size;

    public Double2ShortArrayMap(double[] key, short[] value) {
        this.key = key;
        this.value = value;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Double2ShortArrayMap() {
        this.key = DoubleArrays.EMPTY_ARRAY;
        this.value = ShortArrays.EMPTY_ARRAY;
    }

    @Override
    public ObjectSet<Map.Entry<Double, Short>> entrySet() {
        return new AbstractObjectSet<Map.Entry<Double, Short>>(){

            @Override
            public ObjectIterator<Map.Entry<Double, Short>> iterator() {
                return new AbstractObjectIterator<Map.Entry<Double, Short>>(){
                    int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < Double2ShortArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<Double, Short> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractDouble2ShortMap.BasicEntry(Double2ShortArrayMap.this.key[this.next], Double2ShortArrayMap.this.value[this.next++]);
                    }
                };
            }

            @Override
            public int size() {
                return Double2ShortArrayMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Double2ShortMap.Entry e = (Double2ShortMap.Entry)o;
                return Double2ShortArrayMap.this.containsKey(e.getKey()) && Double2ShortArrayMap.this.get(e.getKey()) == e.getValue();
            }
        };
    }

    private int findKey(double k) {
        double[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return i;
        }
        return -1;
    }

    @Override
    public short get(double k) {
        double[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return this.value[i];
        }
        return this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean containsKey(double k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(short v) {
        int i = this.size;
        while (i-- != 0) {
            if (this.value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public short put(double k, short v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            short oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            this.key = DoubleArrays.grow(this.key, this.size + 1);
            this.value = ShortArrays.grow(this.value, this.size + 1);
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return this.defRetValue;
    }

    @Override
    public short remove(double k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return this.defRetValue;
        }
        short oldValue = this.value[oldPos];
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, this.size - oldPos - 1);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, this.size - oldPos - 1);
        --this.size;
        return oldValue;
    }

    @Override
    public DoubleSet keySet() {
        return new DoubleArraySet(this.key, this.size);
    }

    @Override
    public ShortCollection values() {
        return ShortCollections.unmodifiable(new ShortArraySet(this.value, this.size));
    }
}

