/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.AbstractFloat2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollections;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Float2FloatArrayMap
extends AbstractFloat2FloatMap {
    private static final long serialVersionUID = 1L;
    private float[] key;
    private float[] value;
    private int size;

    public Float2FloatArrayMap(float[] key, float[] value) {
        this.key = key;
        this.value = value;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Float2FloatArrayMap() {
        this.key = FloatArrays.EMPTY_ARRAY;
        this.value = FloatArrays.EMPTY_ARRAY;
    }

    @Override
    public ObjectSet<Map.Entry<Float, Float>> entrySet() {
        return new AbstractObjectSet<Map.Entry<Float, Float>>(){

            @Override
            public ObjectIterator<Map.Entry<Float, Float>> iterator() {
                return new AbstractObjectIterator<Map.Entry<Float, Float>>(){
                    int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < Float2FloatArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<Float, Float> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractFloat2FloatMap.BasicEntry(Float2FloatArrayMap.this.key[this.next], Float2FloatArrayMap.this.value[this.next++]);
                    }
                };
            }

            @Override
            public int size() {
                return Float2FloatArrayMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Float2FloatMap.Entry e = (Float2FloatMap.Entry)o;
                return Float2FloatArrayMap.this.containsKey(e.getKey()) && Float2FloatArrayMap.this.get(e.getKey()) == e.getValue();
            }
        };
    }

    private int findKey(float k) {
        float[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return i;
        }
        return -1;
    }

    @Override
    public float get(float k) {
        float[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return this.value[i];
        }
        return this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean containsKey(float k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(float v) {
        int i = this.size;
        while (i-- != 0) {
            if (this.value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public float put(float k, float v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            float oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            this.key = FloatArrays.grow(this.key, this.size + 1);
            this.value = FloatArrays.grow(this.value, this.size + 1);
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return this.defRetValue;
    }

    @Override
    public float remove(float k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return this.defRetValue;
        }
        float oldValue = this.value[oldPos];
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, this.size - oldPos - 1);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, this.size - oldPos - 1);
        --this.size;
        return oldValue;
    }

    @Override
    public FloatSet keySet() {
        return new FloatArraySet(this.key, this.size);
    }

    @Override
    public FloatCollection values() {
        return FloatCollections.unmodifiable(new FloatArraySet(this.value, this.size));
    }
}

