/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatIterators;

public class FloatArraySet
extends AbstractFloatSet {
    private static final long serialVersionUID = 1L;
    private float[] a;
    private int size;

    public FloatArraySet(float[] a) {
        this.a = a;
    }

    public FloatArraySet() {
        this.a = FloatArrays.EMPTY_ARRAY;
    }

    public FloatArraySet(float[] a, int size) {
        this.a = a;
        this.size = size;
        if (size > a.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a.length + ")");
        }
    }

    private int findKey(float o) {
        int i = this.size;
        while (i-- != 0) {
            if (this.a[i] != o) continue;
            return i;
        }
        return -1;
    }

    public FloatIterator iterator() {
        return FloatIterators.wrap(this.a, 0, this.size);
    }

    public boolean contains(float k) {
        return this.findKey(k) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(float k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        System.arraycopy(this.a, pos + 1, this.a, pos, this.size - pos - 1);
        --this.size;
        return true;
    }

    public boolean add(float k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            this.a = FloatArrays.grow(this.a, this.size + 1);
        }
        this.a[this.size++] = k;
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size != 0;
    }
}

