/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractInt2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongCollections;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Int2LongArrayMap
extends AbstractInt2LongMap {
    private static final long serialVersionUID = 1L;
    private int[] key;
    private long[] value;
    private int size;

    public Int2LongArrayMap(int[] key, long[] value) {
        this.key = key;
        this.value = value;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Int2LongArrayMap() {
        this.key = IntArrays.EMPTY_ARRAY;
        this.value = LongArrays.EMPTY_ARRAY;
    }

    @Override
    public ObjectSet<Map.Entry<Integer, Long>> entrySet() {
        return new AbstractObjectSet<Map.Entry<Integer, Long>>(){

            @Override
            public ObjectIterator<Map.Entry<Integer, Long>> iterator() {
                return new AbstractObjectIterator<Map.Entry<Integer, Long>>(){
                    int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < Int2LongArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<Integer, Long> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractInt2LongMap.BasicEntry(Int2LongArrayMap.this.key[this.next], Int2LongArrayMap.this.value[this.next++]);
                    }
                };
            }

            @Override
            public int size() {
                return Int2LongArrayMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Int2LongMap.Entry e = (Int2LongMap.Entry)o;
                return Int2LongArrayMap.this.containsKey(e.getKey()) && Int2LongArrayMap.this.get(e.getKey()) == e.getValue();
            }
        };
    }

    private int findKey(int k) {
        int[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return i;
        }
        return -1;
    }

    @Override
    public long get(int k) {
        int[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return this.value[i];
        }
        return this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean containsKey(int k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(long v) {
        int i = this.size;
        while (i-- != 0) {
            if (this.value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public long put(int k, long v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            long oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            this.key = IntArrays.grow(this.key, this.size + 1);
            this.value = LongArrays.grow(this.value, this.size + 1);
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return this.defRetValue;
    }

    @Override
    public long remove(int k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return this.defRetValue;
        }
        long oldValue = this.value[oldPos];
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, this.size - oldPos - 1);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, this.size - oldPos - 1);
        --this.size;
        return oldValue;
    }

    @Override
    public IntSet keySet() {
        return new IntArraySet(this.key, this.size);
    }

    @Override
    public LongCollection values() {
        return LongCollections.unmodifiable(new LongArraySet(this.value, this.size));
    }
}

