/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractInt2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceCollections;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Int2ReferenceArrayMap<V>
extends AbstractInt2ReferenceMap<V> {
    private static final long serialVersionUID = 1L;
    private int[] key;
    private V[] value;
    private int size;

    public Int2ReferenceArrayMap(int[] key, V[] value) {
        this.key = key;
        this.value = value;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Int2ReferenceArrayMap(Class<V> valueClass) {
        this.key = IntArrays.EMPTY_ARRAY;
        this.value = (Object[])Array.newInstance(valueClass, 0);
    }

    @Override
    public ObjectSet<Map.Entry<Integer, V>> entrySet() {
        return new AbstractObjectSet<Map.Entry<Integer, V>>(){

            @Override
            public ObjectIterator<Map.Entry<Integer, V>> iterator() {
                return new AbstractObjectIterator<Map.Entry<Integer, V>>(){
                    int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < Int2ReferenceArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<Integer, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractInt2ReferenceMap.BasicEntry<Object>(Int2ReferenceArrayMap.this.key[this.next], Int2ReferenceArrayMap.this.value[this.next++]);
                    }
                };
            }

            @Override
            public int size() {
                return Int2ReferenceArrayMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Int2ReferenceMap.Entry e = (Int2ReferenceMap.Entry)o;
                return Int2ReferenceArrayMap.this.containsKey(e.getKey()) && Int2ReferenceArrayMap.this.get(e.getKey()) == e.getValue();
            }
        };
    }

    private int findKey(int k) {
        int[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return i;
        }
        return -1;
    }

    @Override
    public V get(int k) {
        int[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return this.value[i];
        }
        return (V)this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        int i = this.size;
        while (i-- != 0) {
            this.value[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsKey(int k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(Object v) {
        int i = this.size;
        while (i-- != 0) {
            if (this.value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V put(int k, V v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            V oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            this.key = IntArrays.grow(this.key, this.size + 1);
            this.value = ObjectArrays.grow(this.value, this.size + 1);
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return (V)this.defRetValue;
    }

    @Override
    public V remove(int k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return (V)this.defRetValue;
        }
        V oldValue = this.value[oldPos];
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, this.size - oldPos - 1);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, this.size - oldPos - 1);
        --this.size;
        this.value[this.size] = null;
        return oldValue;
    }

    @Override
    public IntSet keySet() {
        return new IntArraySet(this.key, this.size);
    }

    @Override
    public ReferenceCollection<V> values() {
        return ReferenceCollections.unmodifiable(new ReferenceArraySet<V>(this.value, this.size));
    }
}

