/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntHeaps;
import java.util.NoSuchElementException;

public class IntHeapPriorityQueue
extends AbstractIntPriorityQueue {
    protected int[] heap = IntArrays.EMPTY_ARRAY;
    protected int size;
    protected IntComparator c;

    public IntHeapPriorityQueue(int capacity, IntComparator c) {
        if (capacity > 0) {
            this.heap = new int[capacity];
        }
        this.c = c;
    }

    public IntHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public IntHeapPriorityQueue(IntComparator c) {
        this(0, c);
    }

    public IntHeapPriorityQueue() {
        this(0, null);
    }

    public IntHeapPriorityQueue(int[] a, int size, IntComparator c) {
        this(c);
        this.heap = a;
        this.size = size;
        IntHeaps.makeHeap(a, size, c);
    }

    public IntHeapPriorityQueue(int[] a, IntComparator c) {
        this(a, a.length, c);
    }

    public IntHeapPriorityQueue(int[] a, int size) {
        this(a, size, null);
    }

    public IntHeapPriorityQueue(int[] a) {
        this(a, a.length);
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    public void enqueue(int x) {
        if (this.size == this.heap.length) {
            this.heap = IntArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x;
        IntHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    public int dequeueInt() {
        this.ensureNonEmpty();
        int result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            IntHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    public int firstInt() {
        this.ensureNonEmpty();
        return this.heap[0];
    }

    public void changed() {
        this.ensureNonEmpty();
        IntHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = IntArrays.trim(this.heap, this.size);
    }

    public IntComparator comparator() {
        return this.c;
    }
}

