/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.longs.AbstractLong2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectCollections;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Long2ObjectArrayMap<V>
extends AbstractLong2ObjectMap<V> {
    private static final long serialVersionUID = 1L;
    private long[] key;
    private V[] value;
    private int size;

    public Long2ObjectArrayMap(long[] key, V[] value) {
        this.key = key;
        this.value = value;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Long2ObjectArrayMap(Class<V> valueClass) {
        this.key = LongArrays.EMPTY_ARRAY;
        this.value = (Object[])Array.newInstance(valueClass, 0);
    }

    @Override
    public ObjectSet<Map.Entry<Long, V>> entrySet() {
        return new AbstractObjectSet<Map.Entry<Long, V>>(){

            @Override
            public ObjectIterator<Map.Entry<Long, V>> iterator() {
                return new AbstractObjectIterator<Map.Entry<Long, V>>(){
                    int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < Long2ObjectArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<Long, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractLong2ObjectMap.BasicEntry<Object>(Long2ObjectArrayMap.this.key[this.next], Long2ObjectArrayMap.this.value[this.next++]);
                    }
                };
            }

            @Override
            public int size() {
                return Long2ObjectArrayMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Long2ObjectMap.Entry e = (Long2ObjectMap.Entry)o;
                return Long2ObjectArrayMap.this.containsKey(e.getKey()) && (Long2ObjectArrayMap.this.get(e.getKey()) == null ? e.getValue() == null : Long2ObjectArrayMap.this.get(e.getKey()).equals(e.getValue()));
            }
        };
    }

    private int findKey(long k) {
        long[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return i;
        }
        return -1;
    }

    @Override
    public V get(long k) {
        long[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return this.value[i];
        }
        return (V)this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        int i = this.size;
        while (i-- != 0) {
            this.value[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsKey(long k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(Object v) {
        int i = this.size;
        while (i-- != 0) {
            if (!(this.value[i] == null ? v == null : this.value[i].equals(v))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V put(long k, V v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            V oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            this.key = LongArrays.grow(this.key, this.size + 1);
            this.value = ObjectArrays.grow(this.value, this.size + 1);
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return (V)this.defRetValue;
    }

    @Override
    public V remove(long k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return (V)this.defRetValue;
        }
        V oldValue = this.value[oldPos];
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, this.size - oldPos - 1);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, this.size - oldPos - 1);
        --this.size;
        this.value[this.size] = null;
        return oldValue;
    }

    @Override
    public LongSet keySet() {
        return new LongArraySet(this.key, this.size);
    }

    @Override
    public ObjectCollection<V> values() {
        return ObjectCollections.unmodifiable(new ObjectArraySet<V>(this.value, this.size));
    }
}

