/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;

public class LongArraySet
extends AbstractLongSet {
    private static final long serialVersionUID = 1L;
    private long[] a;
    private int size;

    public LongArraySet(long[] a) {
        this.a = a;
    }

    public LongArraySet() {
        this.a = LongArrays.EMPTY_ARRAY;
    }

    public LongArraySet(long[] a, int size) {
        this.a = a;
        this.size = size;
        if (size > a.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a.length + ")");
        }
    }

    private int findKey(long o) {
        int i = this.size;
        while (i-- != 0) {
            if (this.a[i] != o) continue;
            return i;
        }
        return -1;
    }

    public LongIterator iterator() {
        return LongIterators.wrap(this.a, 0, this.size);
    }

    public boolean contains(long k) {
        return this.findKey(k) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(long k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        System.arraycopy(this.a, pos + 1, this.a, pos, this.size - pos - 1);
        --this.size;
        return true;
    }

    public boolean add(long k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            this.a = LongArrays.grow(this.a, this.size + 1);
        }
        this.a[this.size++] = k;
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size != 0;
    }
}

