/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharCollections;
import it.unimi.dsi.fastutil.objects.AbstractObject2CharMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2CharMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object2CharArrayMap<K>
extends AbstractObject2CharMap<K> {
    private static final long serialVersionUID = 1L;
    private K[] key;
    private char[] value;
    private int size;

    public Object2CharArrayMap(K[] key, char[] value) {
        this.key = key;
        this.value = value;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Object2CharArrayMap(Class<K> keyClass) {
        this.key = (Object[])Array.newInstance(keyClass, 0);
        this.value = CharArrays.EMPTY_ARRAY;
    }

    @Override
    public ObjectSet<Map.Entry<K, Character>> entrySet() {
        return new AbstractObjectSet<Map.Entry<K, Character>>(){

            @Override
            public ObjectIterator<Map.Entry<K, Character>> iterator() {
                return new AbstractObjectIterator<Map.Entry<K, Character>>(){
                    int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < Object2CharArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<K, Character> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractObject2CharMap.BasicEntry<Object>(Object2CharArrayMap.this.key[this.next], Object2CharArrayMap.this.value[this.next++]);
                    }
                };
            }

            @Override
            public int size() {
                return Object2CharArrayMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Object2CharMap.Entry e = (Object2CharMap.Entry)o;
                return Object2CharArrayMap.this.containsKey(e.getKey()) && Object2CharArrayMap.this.get(e.getKey()) == e.getValue();
            }
        };
    }

    private int findKey(Object k) {
        K[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (!(key[i] == null ? k == null : key[i].equals(k))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public char getChar(Object k) {
        K[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (!(key[i] == null ? k == null : key[i].equals(k))) continue;
            return this.value[i];
        }
        return this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        int i = this.size;
        while (i-- != 0) {
            this.key[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(char v) {
        int i = this.size;
        while (i-- != 0) {
            if (this.value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public char put(K k, char v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            char oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            this.key = ObjectArrays.grow(this.key, this.size + 1);
            this.value = CharArrays.grow(this.value, this.size + 1);
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return this.defRetValue;
    }

    @Override
    public char removeChar(Object k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return this.defRetValue;
        }
        char oldValue = this.value[oldPos];
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, this.size - oldPos - 1);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, this.size - oldPos - 1);
        --this.size;
        this.key[this.size] = null;
        return oldValue;
    }

    @Override
    public ObjectSet<K> keySet() {
        return new ObjectArraySet<K>(this.key, this.size);
    }

    @Override
    public CharCollection values() {
        return CharCollections.unmodifiable(new CharArraySet(this.value, this.size));
    }
}

