/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.doubles.DoubleArraySet;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollections;
import it.unimi.dsi.fastutil.objects.AbstractObject2DoubleMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object2DoubleArrayMap<K>
extends AbstractObject2DoubleMap<K> {
    private static final long serialVersionUID = 1L;
    private K[] key;
    private double[] value;
    private int size;

    public Object2DoubleArrayMap(K[] key, double[] value) {
        this.key = key;
        this.value = value;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Object2DoubleArrayMap(Class<K> keyClass) {
        this.key = (Object[])Array.newInstance(keyClass, 0);
        this.value = DoubleArrays.EMPTY_ARRAY;
    }

    @Override
    public ObjectSet<Map.Entry<K, Double>> entrySet() {
        return new AbstractObjectSet<Map.Entry<K, Double>>(){

            @Override
            public ObjectIterator<Map.Entry<K, Double>> iterator() {
                return new AbstractObjectIterator<Map.Entry<K, Double>>(){
                    int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < Object2DoubleArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<K, Double> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractObject2DoubleMap.BasicEntry<Object>(Object2DoubleArrayMap.this.key[this.next], Object2DoubleArrayMap.this.value[this.next++]);
                    }
                };
            }

            @Override
            public int size() {
                return Object2DoubleArrayMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Object2DoubleMap.Entry e = (Object2DoubleMap.Entry)o;
                return Object2DoubleArrayMap.this.containsKey(e.getKey()) && Object2DoubleArrayMap.this.get(e.getKey()) == e.getValue();
            }
        };
    }

    private int findKey(Object k) {
        K[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (!(key[i] == null ? k == null : key[i].equals(k))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double getDouble(Object k) {
        K[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (!(key[i] == null ? k == null : key[i].equals(k))) continue;
            return this.value[i];
        }
        return this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        int i = this.size;
        while (i-- != 0) {
            this.key[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(double v) {
        int i = this.size;
        while (i-- != 0) {
            if (this.value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public double put(K k, double v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            double oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            this.key = ObjectArrays.grow(this.key, this.size + 1);
            this.value = DoubleArrays.grow(this.value, this.size + 1);
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return this.defRetValue;
    }

    @Override
    public double removeDouble(Object k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return this.defRetValue;
        }
        double oldValue = this.value[oldPos];
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, this.size - oldPos - 1);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, this.size - oldPos - 1);
        --this.size;
        this.key[this.size] = null;
        return oldValue;
    }

    @Override
    public ObjectSet<K> keySet() {
        return new ObjectArraySet<K>(this.key, this.size);
    }

    @Override
    public DoubleCollection values() {
        return DoubleCollections.unmodifiable(new DoubleArraySet(this.value, this.size));
    }
}

