/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractObject2ReferenceMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceCollections;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object2ReferenceArrayMap<K, V>
extends AbstractObject2ReferenceMap<K, V> {
    private static final long serialVersionUID = 1L;
    private K[] key;
    private V[] value;
    private int size;

    public Object2ReferenceArrayMap(K[] key, V[] value) {
        this.key = key;
        this.value = value;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Object2ReferenceArrayMap(Class<K> keyClass, Class<V> valueClass) {
        this.key = (Object[])Array.newInstance(keyClass, 0);
        this.value = (Object[])Array.newInstance(valueClass, 0);
    }

    @Override
    public ObjectSet<Map.Entry<K, V>> entrySet() {
        return new AbstractObjectSet<Map.Entry<K, V>>(){

            @Override
            public ObjectIterator<Map.Entry<K, V>> iterator() {
                return new AbstractObjectIterator<Map.Entry<K, V>>(){
                    int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < Object2ReferenceArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractObject2ReferenceMap.BasicEntry<Object, Object>(Object2ReferenceArrayMap.this.key[this.next], Object2ReferenceArrayMap.this.value[this.next++]);
                    }
                };
            }

            @Override
            public int size() {
                return Object2ReferenceArrayMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Object2ReferenceMap.Entry e = (Object2ReferenceMap.Entry)o;
                return Object2ReferenceArrayMap.this.containsKey(e.getKey()) && Object2ReferenceArrayMap.this.get(e.getKey()) == e.getValue();
            }
        };
    }

    private int findKey(Object k) {
        K[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (!(key[i] == null ? k == null : key[i].equals(k))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public V get(Object k) {
        K[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (!(key[i] == null ? k == null : key[i].equals(k))) continue;
            return this.value[i];
        }
        return (V)this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        int i = this.size;
        while (i-- != 0) {
            this.key[i] = null;
            this.value[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(Object v) {
        int i = this.size;
        while (i-- != 0) {
            if (this.value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V put(K k, V v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            V oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            this.key = ObjectArrays.grow(this.key, this.size + 1);
            this.value = ObjectArrays.grow(this.value, this.size + 1);
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return (V)this.defRetValue;
    }

    @Override
    public V remove(Object k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return (V)this.defRetValue;
        }
        V oldValue = this.value[oldPos];
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, this.size - oldPos - 1);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, this.size - oldPos - 1);
        --this.size;
        this.key[this.size] = null;
        this.value[this.size] = null;
        return oldValue;
    }

    @Override
    public ObjectSet<K> keySet() {
        return new ObjectArraySet<K>(this.key, this.size);
    }

    @Override
    public ReferenceCollection<V> values() {
        return ReferenceCollections.unmodifiable(new ReferenceArraySet<V>(this.value, this.size));
    }
}

