/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArraySet<K>
extends AbstractObjectSet<K> {
    private static final long serialVersionUID = 1L;
    private K[] a;
    private int size;

    public ObjectArraySet(K[] a) {
        this.a = a;
    }

    public ObjectArraySet(Class<K> klass) {
        this.a = (Object[])Array.newInstance(klass, 0);
    }

    public ObjectArraySet(K[] a, int size) {
        this.a = a;
        this.size = size;
        if (size > a.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a.length + ")");
        }
    }

    private int findKey(K o) {
        int i = this.size;
        while (i-- != 0) {
            if (!(this.a[i] == null ? o == null : this.a[i].equals(o))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ObjectIterator<K> iterator() {
        return ObjectIterators.wrap(this.a, 0, this.size);
    }

    @Override
    public boolean contains(Object k) {
        return this.findKey(k) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(Object k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        System.arraycopy(this.a, pos + 1, this.a, pos, this.size - pos - 1);
        --this.size;
        this.a[this.size] = null;
        return true;
    }

    @Override
    public boolean add(K k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            this.a = ObjectArrays.grow(this.a, this.size + 1);
        }
        this.a[this.size++] = k;
        return true;
    }

    @Override
    public void clear() {
        int i = this.size;
        while (i-- != 0) {
            this.a[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size != 0;
    }
}

